/* rygel-gst-player.c generated by valac, the Vala compiler
 * generated from rygel-gst-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_GST_PLAYER (rygel_gst_player_get_type ())
#define RYGEL_GST_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_PLAYER, RygelGstPlayer))
#define RYGEL_GST_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_PLAYER, RygelGstPlayerClass))
#define RYGEL_IS_GST_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_PLAYER))
#define RYGEL_IS_GST_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_PLAYER))
#define RYGEL_GST_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_PLAYER, RygelGstPlayerClass))

typedef struct _RygelGstPlayer RygelGstPlayer;
typedef struct _RygelGstPlayerClass RygelGstPlayerClass;
typedef struct _RygelGstPlayerPrivate RygelGstPlayerPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TIME (time_get_type ())
#define TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIME, Time))
#define TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIME, TimeClass))
#define IS_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIME))
#define IS_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIME))
#define TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIME, TimeClass))

typedef struct _Time Time;
typedef struct _TimeClass TimeClass;
typedef struct _TimePrivate TimePrivate;
typedef struct _ParamSpecTime ParamSpecTime;

struct _RygelGstPlayer {
	GObject parent_instance;
	RygelGstPlayerPrivate * priv;
};

struct _RygelGstPlayerClass {
	GObjectClass parent_class;
};

struct _RygelGstPlayerPrivate {
	GstElement* playbin;
	char* _playback_state;
};

struct _Time {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TimePrivate * priv;
};

struct _TimeClass {
	GTypeClass parent_class;
	void (*finalize) (Time *self);
};

struct _ParamSpecTime {
	GParamSpec parent_instance;
};


static RygelGstPlayer* rygel_gst_player_player;
static RygelGstPlayer* rygel_gst_player_player = NULL;
static gpointer rygel_gst_player_parent_class = NULL;
static gpointer time_parent_class = NULL;

GType rygel_gst_player_get_type (void);
#define RYGEL_GST_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_PLAYER, RygelGstPlayerPrivate))
enum  {
	RYGEL_GST_PLAYER_DUMMY_PROPERTY,
	RYGEL_GST_PLAYER_PLAYBACK_STATE,
	RYGEL_GST_PLAYER_URI,
	RYGEL_GST_PLAYER_VOLUME,
	RYGEL_GST_PLAYER_DURATION,
	RYGEL_GST_PLAYER_POSITION
};
static gboolean rygel_gst_player_bus_handler (RygelGstPlayer* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_gst_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static RygelGstPlayer* rygel_gst_player_new (void);
static RygelGstPlayer* rygel_gst_player_construct (GType object_type);
RygelGstPlayer* rygel_gst_player_get_default (void);
GstClockTime time_from_string (const char* str);
gboolean rygel_gst_player_seek (RygelGstPlayer* self, const char* time);
void rygel_gst_player_set_playback_state (RygelGstPlayer* self, const char* value);
const char* rygel_gst_player_get_playback_state (RygelGstPlayer* self);
static inline const char* _dynamic_get_uri0 (GstElement* obj);
const char* rygel_gst_player_get_uri (RygelGstPlayer* self);
static inline void _dynamic_set_uri1 (GstElement* obj, const char* value);
void rygel_gst_player_set_uri (RygelGstPlayer* self, const char* value);
static inline double _dynamic_get_volume2 (GstElement* obj);
double rygel_gst_player_get_volume (RygelGstPlayer* self);
static inline void _dynamic_set_volume3 (GstElement* obj, double value);
void rygel_gst_player_set_volume (RygelGstPlayer* self, double value);
char* time_to_string (GstClockTime time);
char* rygel_gst_player_get_duration (RygelGstPlayer* self);
char* rygel_gst_player_get_position (RygelGstPlayer* self);
static void rygel_gst_player_finalize (GObject* obj);
static void rygel_gst_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_gst_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer time_ref (gpointer instance);
void time_unref (gpointer instance);
GParamSpec* param_spec_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_time (GValue* value, gpointer v_object);
gpointer value_get_time (const GValue* value);
GType time_get_type (void);
enum  {
	TIME_DUMMY_PROPERTY
};
Time* time_new (void);
Time* time_construct (GType object_type);
static void time_finalize (Time* obj);



#line 137 "rygel-gst-player.vala"
static gboolean _rygel_gst_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
#line 154 "rygel-gst-player.c"
	return rygel_gst_player_bus_handler (self, bus, message);
}


#line 109 "rygel-gst-player.vala"
static RygelGstPlayer* rygel_gst_player_construct (GType object_type) {
#line 161 "rygel-gst-player.c"
	RygelGstPlayer * self;
	GstElement* _tmp0_;
	GstBus* bus;
#line 109 "rygel-gst-player.vala"
	self = (RygelGstPlayer*) g_object_new (object_type, NULL);
#line 110 "rygel-gst-player.vala"
	self->priv->playbin = (_tmp0_ = gst_element_factory_make ("playbin2", NULL), _gst_object_unref0 (self->priv->playbin), _tmp0_);
#line 111 "rygel-gst-player.vala"
	g_assert (self->priv->playbin != NULL);
#line 114 "rygel-gst-player.vala"
	bus = gst_element_get_bus (self->priv->playbin);
#line 115 "rygel-gst-player.vala"
	gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _rygel_gst_player_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
#line 175 "rygel-gst-player.c"
	_gst_object_unref0 (bus);
	return self;
}


#line 109 "rygel-gst-player.vala"
static RygelGstPlayer* rygel_gst_player_new (void) {
#line 109 "rygel-gst-player.vala"
	return rygel_gst_player_construct (RYGEL_TYPE_GST_PLAYER);
#line 185 "rygel-gst-player.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 118 "rygel-gst-player.vala"
RygelGstPlayer* rygel_gst_player_get_default (void) {
#line 196 "rygel-gst-player.c"
	RygelGstPlayer* result;
#line 119 "rygel-gst-player.vala"
	if (rygel_gst_player_player == NULL) {
#line 200 "rygel-gst-player.c"
		RygelGstPlayer* _tmp0_;
#line 120 "rygel-gst-player.vala"
		rygel_gst_player_player = (_tmp0_ = rygel_gst_player_new (), _g_object_unref0 (rygel_gst_player_player), _tmp0_);
#line 204 "rygel-gst-player.c"
	}
	result = _g_object_ref0 (rygel_gst_player_player);
#line 123 "rygel-gst-player.vala"
	return result;
#line 209 "rygel-gst-player.c"
}


#line 126 "rygel-gst-player.vala"
gboolean rygel_gst_player_seek (RygelGstPlayer* self, const char* time) {
#line 215 "rygel-gst-player.c"
	gboolean result;
#line 126 "rygel-gst-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 126 "rygel-gst-player.vala"
	g_return_val_if_fail (time != NULL, FALSE);
#line 127 "rygel-gst-player.vala"
	g_debug ("rygel-gst-player.vala:127: Seeking to %s.", time);
#line 223 "rygel-gst-player.c"
	result = gst_element_seek (self->priv->playbin, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, (gint64) time_from_string (time), GST_SEEK_TYPE_NONE, (gint64) (-1));
#line 128 "rygel-gst-player.vala"
	return result;
#line 227 "rygel-gst-player.c"
}


#line 137 "rygel-gst-player.vala"
static gboolean rygel_gst_player_bus_handler (RygelGstPlayer* self, GstBus* bus, GstMessage* message) {
#line 233 "rygel-gst-player.c"
	gboolean result;
#line 137 "rygel-gst-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 137 "rygel-gst-player.vala"
	g_return_val_if_fail (bus != NULL, FALSE);
#line 137 "rygel-gst-player.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 139 "rygel-gst-player.vala"
	if (message->type == GST_MESSAGE_EOS) {
#line 140 "rygel-gst-player.vala"
		g_debug ("rygel-gst-player.vala:140: EOS");
#line 141 "rygel-gst-player.vala"
		rygel_gst_player_set_playback_state (self, "STOPPED");
#line 247 "rygel-gst-player.c"
	}
	result = TRUE;
#line 144 "rygel-gst-player.vala"
	return result;
#line 252 "rygel-gst-player.c"
}


const char* rygel_gst_player_get_playback_state (RygelGstPlayer* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_playback_state;
#line 38 "rygel-gst-player.vala"
	return result;
#line 262 "rygel-gst-player.c"
}


void rygel_gst_player_set_playback_state (RygelGstPlayer* self, const char* value) {
	char* _tmp0_;
	GQuark _tmp2_;
	const char* _tmp1_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	static GQuark _tmp2__label2 = 0;
	g_return_if_fail (self != NULL);
#line 42 "rygel-gst-player.vala"
	g_debug ("rygel-gst-player.vala:42: Changing playback state to %s..", value);
#line 43 "rygel-gst-player.vala"
	self->priv->_playback_state = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_playback_state), _tmp0_);
#line 278 "rygel-gst-player.c"
	_tmp1_ = self->priv->_playback_state;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("STOPPED"))))
	do {
#line 47 "rygel-gst-player.vala"
		gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
#line 48 "rygel-gst-player.vala"
		break;
#line 287 "rygel-gst-player.c"
	} while (0); else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("PAUSED_PLAYBACK"))))
	do {
#line 50 "rygel-gst-player.vala"
		gst_element_set_state (self->priv->playbin, GST_STATE_PAUSED);
#line 51 "rygel-gst-player.vala"
		break;
#line 294 "rygel-gst-player.c"
	} while (0); else if (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("PLAYING"))))
	do {
#line 53 "rygel-gst-player.vala"
		gst_element_set_state (self->priv->playbin, GST_STATE_PLAYING);
#line 54 "rygel-gst-player.vala"
		break;
#line 301 "rygel-gst-player.c"
	} while (0); else
	do {
#line 56 "rygel-gst-player.vala"
		break;
#line 306 "rygel-gst-player.c"
	} while (0);
	g_object_notify ((GObject *) self, "playback-state");
}


static inline const char* _dynamic_get_uri0 (GstElement* obj) {
	const char* result;
	g_object_get (obj, "uri", &result, NULL);
	return result;
}


const char* rygel_gst_player_get_uri (RygelGstPlayer* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = _dynamic_get_uri0 (self->priv->playbin);
#line 63 "rygel-gst-player.vala"
	return result;
#line 325 "rygel-gst-player.c"
}


static inline void _dynamic_set_uri1 (GstElement* obj, const char* value) {
	g_object_set (obj, "uri", value, NULL);
}


void rygel_gst_player_set_uri (RygelGstPlayer* self, const char* value) {
	g_return_if_fail (self != NULL);
#line 67 "rygel-gst-player.vala"
	_dynamic_set_uri1 (self->priv->playbin, value);
#line 68 "rygel-gst-player.vala"
	g_debug ("rygel-gst-player.vala:68: URI set to %s.", value);
#line 340 "rygel-gst-player.c"
	g_object_notify ((GObject *) self, "uri");
}


static inline double _dynamic_get_volume2 (GstElement* obj) {
	double result;
	g_object_get (obj, "volume", &result, NULL);
	return result;
}


double rygel_gst_player_get_volume (RygelGstPlayer* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = _dynamic_get_volume2 (self->priv->playbin);
#line 74 "rygel-gst-player.vala"
	return result;
#line 358 "rygel-gst-player.c"
}


static inline void _dynamic_set_volume3 (GstElement* obj, double value) {
	g_object_set (obj, "volume", value, NULL);
}


void rygel_gst_player_set_volume (RygelGstPlayer* self, double value) {
	g_return_if_fail (self != NULL);
#line 78 "rygel-gst-player.vala"
	_dynamic_set_volume3 (self->priv->playbin, value);
#line 79 "rygel-gst-player.vala"
	g_debug ("rygel-gst-player.vala:79: volume set to %f.", value);
#line 373 "rygel-gst-player.c"
	g_object_notify ((GObject *) self, "volume");
}


char* rygel_gst_player_get_duration (RygelGstPlayer* self) {
	char* result;
	GstFormat format;
	gint64 dur = 0LL;
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "rygel-gst-player.vala"
	format = GST_FORMAT_TIME;
#line 88 "rygel-gst-player.vala"
	if (gst_element_query_duration (self->priv->playbin, &format, &dur)) {
#line 387 "rygel-gst-player.c"
		result = time_to_string ((GstClockTime) dur);
#line 89 "rygel-gst-player.vala"
		return result;
#line 391 "rygel-gst-player.c"
	} else {
		result = g_strdup ("00:00:00");
#line 91 "rygel-gst-player.vala"
		return result;
#line 396 "rygel-gst-player.c"
	}
}


char* rygel_gst_player_get_position (RygelGstPlayer* self) {
	char* result;
	GstFormat format;
	gint64 pos = 0LL;
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "rygel-gst-player.vala"
	format = GST_FORMAT_TIME;
#line 101 "rygel-gst-player.vala"
	if (gst_element_query_position (self->priv->playbin, &format, &pos)) {
#line 410 "rygel-gst-player.c"
		result = time_to_string ((GstClockTime) pos);
#line 102 "rygel-gst-player.vala"
		return result;
#line 414 "rygel-gst-player.c"
	} else {
		result = g_strdup ("00:00:00");
#line 104 "rygel-gst-player.vala"
		return result;
#line 419 "rygel-gst-player.c"
	}
}


static void rygel_gst_player_class_init (RygelGstPlayerClass * klass) {
	rygel_gst_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_gst_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_gst_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_PLAYER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_PLAYER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_PLAYER_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_PLAYER_DURATION, g_param_spec_string ("duration", "duration", "duration", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_PLAYER_POSITION, g_param_spec_string ("position", "position", "position", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_gst_player_instance_init (RygelGstPlayer * self) {
	self->priv = RYGEL_GST_PLAYER_GET_PRIVATE (self);
	self->priv->_playback_state = g_strdup ("STOPPED");
}


static void rygel_gst_player_finalize (GObject* obj) {
	RygelGstPlayer * self;
	self = RYGEL_GST_PLAYER (obj);
	_gst_object_unref0 (self->priv->playbin);
	_g_free0 (self->priv->_playback_state);
	G_OBJECT_CLASS (rygel_gst_player_parent_class)->finalize (obj);
}


GType rygel_gst_player_get_type (void) {
	static GType rygel_gst_player_type_id = 0;
	if (rygel_gst_player_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstPlayer), 0, (GInstanceInitFunc) rygel_gst_player_instance_init, NULL };
		rygel_gst_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstPlayer", &g_define_type_info, 0);
	}
	return rygel_gst_player_type_id;
}


static void rygel_gst_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelGstPlayer * self;
	self = RYGEL_GST_PLAYER (object);
	switch (property_id) {
		case RYGEL_GST_PLAYER_PLAYBACK_STATE:
		g_value_set_string (value, rygel_gst_player_get_playback_state (self));
		break;
		case RYGEL_GST_PLAYER_URI:
		g_value_set_string (value, rygel_gst_player_get_uri (self));
		break;
		case RYGEL_GST_PLAYER_VOLUME:
		g_value_set_double (value, rygel_gst_player_get_volume (self));
		break;
		case RYGEL_GST_PLAYER_DURATION:
		g_value_set_string (value, rygel_gst_player_get_duration (self));
		break;
		case RYGEL_GST_PLAYER_POSITION:
		g_value_set_string (value, rygel_gst_player_get_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_gst_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelGstPlayer * self;
	self = RYGEL_GST_PLAYER (object);
	switch (property_id) {
		case RYGEL_GST_PLAYER_PLAYBACK_STATE:
		rygel_gst_player_set_playback_state (self, g_value_get_string (value));
		break;
		case RYGEL_GST_PLAYER_URI:
		rygel_gst_player_set_uri (self, g_value_get_string (value));
		break;
		case RYGEL_GST_PLAYER_VOLUME:
		rygel_gst_player_set_volume (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


#line 151 "rygel-gst-player.vala"
GstClockTime time_from_string (const char* str) {
#line 511 "rygel-gst-player.c"
	GstClockTime result;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
#line 151 "rygel-gst-player.vala"
	g_return_val_if_fail (str != NULL, 0ULL);
#line 154 "rygel-gst-player.vala"
	sscanf (str, "%llu:%2llu:%2llu%*s", &hours, &minutes, &seconds);
#line 520 "rygel-gst-player.c"
	result = (GstClockTime) ((((hours * 3600) + (minutes * 60)) + seconds) * GST_SECOND);
#line 156 "rygel-gst-player.vala"
	return result;
#line 524 "rygel-gst-player.c"
}


#line 160 "rygel-gst-player.vala"
char* time_to_string (GstClockTime time) {
#line 530 "rygel-gst-player.c"
	char* result;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
#line 163 "rygel-gst-player.vala"
	hours = (guint64) ((time / GST_SECOND) / 3600);
#line 164 "rygel-gst-player.vala"
	seconds = (guint64) ((time / GST_SECOND) % 3600);
#line 165 "rygel-gst-player.vala"
	minutes = seconds / 60;
#line 166 "rygel-gst-player.vala"
	seconds = seconds % 60;
#line 543 "rygel-gst-player.c"
	result = g_strdup_printf ("%llu:%.2llu:%.2llu", hours, minutes, seconds);
#line 168 "rygel-gst-player.vala"
	return result;
#line 547 "rygel-gst-player.c"
}


#line 150 "rygel-gst-player.vala"
Time* time_construct (GType object_type) {
#line 553 "rygel-gst-player.c"
	Time* self;
	self = (Time*) g_type_create_instance (object_type);
	return self;
}


#line 150 "rygel-gst-player.vala"
Time* time_new (void) {
#line 150 "rygel-gst-player.vala"
	return time_construct (TYPE_TIME);
#line 564 "rygel-gst-player.c"
}


static void value_time_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_time_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		time_unref (value->data[0].v_pointer);
	}
}


static void value_time_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = time_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_time_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_time_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Time* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = time_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_time_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Time** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = time_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTime* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TIME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_time (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIME), NULL);
	return value->data[0].v_pointer;
}


void value_set_time (GValue* value, gpointer v_object) {
	Time* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TIME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		time_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		time_unref (old);
	}
}


static void time_class_init (TimeClass * klass) {
	time_parent_class = g_type_class_peek_parent (klass);
	TIME_CLASS (klass)->finalize = time_finalize;
}


static void time_instance_init (Time * self) {
	self->ref_count = 1;
}


static void time_finalize (Time* obj) {
	Time * self;
	self = TIME (obj);
}


GType time_get_type (void) {
	static GType time_type_id = 0;
	if (time_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_time_init, value_time_free_value, value_time_copy_value, value_time_peek_pointer, "p", value_time_collect_value, "p", value_time_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Time), 0, (GInstanceInitFunc) time_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		time_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Time", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return time_type_id;
}


gpointer time_ref (gpointer instance) {
	Time* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void time_unref (gpointer instance) {
	Time* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TIME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




