/* rygel-lms-all-videos.c generated by valac 0.30.0.35-2c9e8, the Vala compiler
 * generated from rygel-lms-all-videos.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define RYGEL_LMS_TYPE_CATEGORY_CONTAINER (rygel_lms_category_container_get_type ())
#define RYGEL_LMS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer))
#define RYGEL_LMS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))

typedef struct _RygelLMSCategoryContainer RygelLMSCategoryContainer;
typedef struct _RygelLMSCategoryContainerClass RygelLMSCategoryContainerClass;
typedef struct _RygelLMSCategoryContainerPrivate RygelLMSCategoryContainerPrivate;

#define RYGEL_LMS_TYPE_ALL_VIDEOS (rygel_lms_all_videos_get_type ())
#define RYGEL_LMS_ALL_VIDEOS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_ALL_VIDEOS, RygelLMSAllVideos))
#define RYGEL_LMS_ALL_VIDEOS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_ALL_VIDEOS, RygelLMSAllVideosClass))
#define RYGEL_LMS_IS_ALL_VIDEOS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_ALL_VIDEOS))
#define RYGEL_LMS_IS_ALL_VIDEOS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_ALL_VIDEOS))
#define RYGEL_LMS_ALL_VIDEOS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_ALL_VIDEOS, RygelLMSAllVideosClass))

typedef struct _RygelLMSAllVideos RygelLMSAllVideos;
typedef struct _RygelLMSAllVideosClass RygelLMSAllVideosClass;
typedef struct _RygelLMSAllVideosPrivate RygelLMSAllVideosPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_LMS_TYPE_DATABASE (rygel_lms_database_get_type ())
#define RYGEL_LMS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabase))
#define RYGEL_LMS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))
#define RYGEL_LMS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))

typedef struct _RygelLMSDatabase RygelLMSDatabase;
typedef struct _RygelLMSDatabaseClass RygelLMSDatabaseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelLMSCategoryContainer {
	RygelMediaContainer parent_instance;
	RygelLMSCategoryContainerPrivate * priv;
	sqlite3_stmt* stmt_all;
	sqlite3_stmt* stmt_find_object;
	sqlite3_stmt* stmt_added;
	sqlite3_stmt* stmt_removed;
	gchar* child_prefix;
	gchar* ref_prefix;
};

struct _RygelLMSCategoryContainerClass {
	RygelMediaContainerClass parent_class;
	RygelMediaObject* (*object_from_statement) (RygelLMSCategoryContainer* self, sqlite3_stmt* statement);
	gchar* (*get_sql_all_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	gchar* (*get_sql_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	guint (*get_child_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args);
	RygelMediaObjects* (*get_children_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count);
};

struct _RygelLMSAllVideos {
	RygelLMSCategoryContainer parent_instance;
	RygelLMSAllVideosPrivate * priv;
};

struct _RygelLMSAllVideosClass {
	RygelLMSCategoryContainerClass parent_class;
};

typedef enum  {
	RYGEL_LMS_DATABASE_ERROR_OPEN,
	RYGEL_LMS_DATABASE_ERROR_PREPARE,
	RYGEL_LMS_DATABASE_ERROR_BIND,
	RYGEL_LMS_DATABASE_ERROR_STEP,
	RYGEL_LMS_DATABASE_ERROR_NOT_FOUND
} RygelLMSDatabaseError;
#define RYGEL_LMS_DATABASE_ERROR rygel_lms_database_error_quark ()

static gpointer rygel_lms_all_videos_parent_class = NULL;

GType rygel_lms_category_container_get_type (void) G_GNUC_CONST;
GType rygel_lms_all_videos_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_LMS_ALL_VIDEOS_DUMMY_PROPERTY
};
#define RYGEL_LMS_ALL_VIDEOS_SQL_ALL "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime = 0 AND videos.id = files.id " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_COUNT "SELECT count(videos.id) " "FROM videos, files " "WHERE dtime = 0 AND videos.id = files.id;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_FIND_OBJECT "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime = 0 AND files.id = ? AND videos.id = files.id;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_ADDED "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime = 0 AND videos.id = files.id " "AND update_id > ? AND update_id <= ?;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_REMOVED "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime <> 0 AND videos.id = files.id " "AND update_id > ? AND update_id <= ?;"
static RygelMediaObject* rygel_lms_all_videos_real_object_from_statement (RygelLMSCategoryContainer* base, sqlite3_stmt* statement);
gchar* rygel_lms_category_container_build_child_id (RygelLMSCategoryContainer* self, gint db_id);
gpointer rygel_lms_database_ref (gpointer instance);
void rygel_lms_database_unref (gpointer instance);
GParamSpec* rygel_lms_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_lms_value_set_database (GValue* value, gpointer v_object);
void rygel_lms_value_take_database (GValue* value, gpointer v_object);
gpointer rygel_lms_value_get_database (const GValue* value);
GType rygel_lms_database_get_type (void) G_GNUC_CONST;
RygelLMSDatabase* rygel_lms_category_container_get_lms_db (RygelLMSCategoryContainer* self);
GQuark rygel_lms_database_error_quark (void);
sqlite3_stmt* rygel_lms_database_prepare (RygelLMSDatabase* self, const gchar* query_string, GError** error);
void rygel_lms_database_find_object (const gchar* id, sqlite3_stmt* stmt, GError** error);
RygelLMSAllVideos* rygel_lms_all_videos_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db);
RygelLMSAllVideos* rygel_lms_all_videos_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db);
RygelLMSCategoryContainer* rygel_lms_category_container_construct (GType object_type, const gchar* db_id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db, const gchar* sql_all, const gchar* sql_find_object, const gchar* sql_count, const gchar* sql_added, const gchar* sql_removed);


static RygelMediaObject* rygel_lms_all_videos_real_object_from_statement (RygelLMSCategoryContainer* base, sqlite3_stmt* statement) {
	RygelLMSAllVideos * self;
	RygelMediaObject* result = NULL;
	gint id = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* mime_type = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* path = NULL;
	sqlite3_stmt* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gchar* title = NULL;
	sqlite3_stmt* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	RygelVideoItem* video = NULL;
	gint _tmp20_ = 0;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	RygelVideoItem* _tmp24_ = NULL;
	RygelVideoItem* _tmp25_ = NULL;
	RygelVideoItem* _tmp26_ = NULL;
	sqlite3_stmt* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	RygelVideoItem* _tmp29_ = NULL;
	sqlite3_stmt* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	GTimeVal tv = {0};
	sqlite3_stmt* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	GTimeVal _tmp34_ = {0};
	RygelVideoItem* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	RygelVideoItem* _tmp38_ = NULL;
	sqlite3_stmt* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	RygelVideoItem* _tmp41_ = NULL;
	sqlite3_stmt* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	RygelVideoItem* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	RygelVideoItem* _tmp46_ = NULL;
	GFile* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* video_data = NULL;
	gchar* _tmp50_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelLMSAllVideos*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	_tmp0_ = statement;
	_tmp1_ = sqlite3_column_int (_tmp0_, 0);
	id = _tmp1_;
	_tmp2_ = statement;
	_tmp3_ = sqlite3_column_text (_tmp2_, 8);
	_tmp4_ = g_strdup (_tmp3_);
	mime_type = _tmp4_;
	_tmp5_ = statement;
	_tmp6_ = sqlite3_column_text (_tmp5_, 4);
	_tmp7_ = g_strdup (_tmp6_);
	path = _tmp7_;
	_tmp8_ = path;
	_tmp9_ = g_file_new_for_path (_tmp8_);
	file = _tmp9_;
	_tmp11_ = mime_type;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp12_ = mime_type;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_ == 0;
	}
	if (_tmp10_) {
		gint _tmp15_ = 0;
		const gchar* _tmp16_ = NULL;
		_tmp15_ = id;
		_tmp16_ = path;
		g_debug ("rygel-lms-all-videos.vala:76: Video item %d (%s) has no MIME type", _tmp15_, _tmp16_);
	}
	_tmp17_ = statement;
	_tmp18_ = sqlite3_column_text (_tmp17_, 1);
	_tmp19_ = g_strdup (_tmp18_);
	title = _tmp19_;
	_tmp20_ = id;
	_tmp21_ = rygel_lms_category_container_build_child_id ((RygelLMSCategoryContainer*) self, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = title;
	_tmp24_ = rygel_video_item_new (_tmp22_, (RygelMediaContainer*) self, _tmp23_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp22_);
	video = _tmp25_;
	_tmp26_ = video;
	_tmp27_ = statement;
	_tmp28_ = sqlite3_column_text (_tmp27_, 2);
	rygel_media_object_set_creator ((RygelMediaObject*) _tmp26_, _tmp28_);
	_tmp29_ = video;
	_tmp30_ = statement;
	_tmp31_ = sqlite3_column_int (_tmp30_, 3);
	rygel_audio_item_set_duration ((RygelAudioItem*) _tmp29_, (glong) _tmp31_);
	_tmp32_ = statement;
	_tmp33_ = sqlite3_column_int (_tmp32_, 5);
	_tmp34_.tv_sec = (glong) _tmp33_;
	_tmp34_.tv_usec = (glong) 0;
	tv = _tmp34_;
	_tmp35_ = video;
	_tmp36_ = g_time_val_to_iso8601 (&tv);
	_tmp37_ = _tmp36_;
	rygel_media_object_set_date ((RygelMediaObject*) _tmp35_, _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = video;
	_tmp39_ = statement;
	_tmp40_ = sqlite3_column_int (_tmp39_, 6);
	rygel_media_file_item_set_size ((RygelMediaFileItem*) _tmp38_, (gint64) _tmp40_);
	_tmp41_ = video;
	_tmp42_ = statement;
	_tmp43_ = sqlite3_column_text (_tmp42_, 7);
	rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) _tmp41_, _tmp43_);
	_tmp44_ = video;
	_tmp45_ = mime_type;
	rygel_media_file_item_set_mime_type ((RygelMediaFileItem*) _tmp44_, _tmp45_);
	_tmp46_ = video;
	_tmp47_ = file;
	_tmp48_ = g_file_get_uri (_tmp47_);
	_tmp49_ = _tmp48_;
	rygel_media_object_add_uri ((RygelMediaObject*) _tmp46_, _tmp49_);
	_g_free0 (_tmp49_);
	_tmp50_ = g_strdup ("select videos_videos.bitrate + videos_audios.bitrate, width, height, c" \
"hannels, sampling_rate " "from videos, videos_audios, videos_videos where videos.id = ? " "and videos.id = videos_audios.video_id and videos.id = videos_videos.v" \
"ideo_id;");
	video_data = _tmp50_;
	{
		sqlite3_stmt* stmt = NULL;
		RygelLMSDatabase* _tmp51_ = NULL;
		RygelLMSDatabase* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		sqlite3_stmt* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gchar* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		sqlite3_stmt* _tmp58_ = NULL;
		RygelVideoItem* _tmp59_ = NULL;
		sqlite3_stmt* _tmp60_ = NULL;
		gint _tmp61_ = 0;
		RygelVideoItem* _tmp62_ = NULL;
		sqlite3_stmt* _tmp63_ = NULL;
		gint _tmp64_ = 0;
		RygelVideoItem* _tmp65_ = NULL;
		sqlite3_stmt* _tmp66_ = NULL;
		gint _tmp67_ = 0;
		RygelVideoItem* _tmp68_ = NULL;
		sqlite3_stmt* _tmp69_ = NULL;
		gint _tmp70_ = 0;
		RygelVideoItem* _tmp71_ = NULL;
		sqlite3_stmt* _tmp72_ = NULL;
		gint _tmp73_ = 0;
		_tmp51_ = rygel_lms_category_container_get_lms_db ((RygelLMSCategoryContainer*) self);
		_tmp52_ = _tmp51_;
		_tmp53_ = video_data;
		_tmp54_ = rygel_lms_database_prepare (_tmp52_, _tmp53_, &_inner_error_);
		stmt = _tmp54_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch10_rygel_lms_database_error;
			}
			_g_free0 (video_data);
			_g_object_unref0 (video);
			_g_free0 (title);
			_g_object_unref0 (file);
			_g_free0 (path);
			_g_free0 (mime_type);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp55_ = id;
		_tmp56_ = g_strdup_printf ("%d", _tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = stmt;
		rygel_lms_database_find_object (_tmp57_, _tmp58_, &_inner_error_);
		_g_free0 (_tmp57_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_sqlite3_finalize0 (stmt);
			if (_inner_error_->domain == RYGEL_LMS_DATABASE_ERROR) {
				goto __catch10_rygel_lms_database_error;
			}
			_sqlite3_finalize0 (stmt);
			_g_free0 (video_data);
			_g_object_unref0 (video);
			_g_free0 (title);
			_g_object_unref0 (file);
			_g_free0 (path);
			_g_free0 (mime_type);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp59_ = video;
		_tmp60_ = stmt;
		_tmp61_ = sqlite3_column_int (_tmp60_, 0);
		rygel_audio_item_set_bitrate ((RygelAudioItem*) _tmp59_, _tmp61_ / 8);
		_tmp62_ = video;
		_tmp63_ = stmt;
		_tmp64_ = sqlite3_column_int (_tmp63_, 1);
		rygel_visual_item_set_width ((RygelVisualItem*) _tmp62_, _tmp64_);
		_tmp65_ = video;
		_tmp66_ = stmt;
		_tmp67_ = sqlite3_column_int (_tmp66_, 2);
		rygel_visual_item_set_height ((RygelVisualItem*) _tmp65_, _tmp67_);
		_tmp68_ = video;
		_tmp69_ = stmt;
		_tmp70_ = sqlite3_column_int (_tmp69_, 3);
		rygel_audio_item_set_channels ((RygelAudioItem*) _tmp68_, _tmp70_);
		_tmp71_ = video;
		_tmp72_ = stmt;
		_tmp73_ = sqlite3_column_int (_tmp72_, 4);
		rygel_audio_item_set_sample_freq ((RygelAudioItem*) _tmp71_, _tmp73_);
		_sqlite3_finalize0 (stmt);
	}
	goto __finally10;
	__catch10_rygel_lms_database_error:
	{
		GError* e = NULL;
		GError* _tmp74_ = NULL;
		const gchar* _tmp75_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp74_ = e;
		_tmp75_ = _tmp74_->message;
		g_warning ("rygel-lms-all-videos.vala:106: Query failed: %s", _tmp75_);
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (video_data);
		_g_object_unref0 (video);
		_g_free0 (title);
		_g_object_unref0 (file);
		_g_free0 (path);
		_g_free0 (mime_type);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = (RygelMediaObject*) video;
	_g_free0 (video_data);
	_g_free0 (title);
	_g_object_unref0 (file);
	_g_free0 (path);
	_g_free0 (mime_type);
	return result;
}


RygelLMSAllVideos* rygel_lms_all_videos_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db) {
	RygelLMSAllVideos * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelLMSDatabase* _tmp3_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	_tmp3_ = lms_db;
	self = (RygelLMSAllVideos*) rygel_lms_category_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, RYGEL_LMS_ALL_VIDEOS_SQL_ALL, RYGEL_LMS_ALL_VIDEOS_SQL_FIND_OBJECT, RYGEL_LMS_ALL_VIDEOS_SQL_COUNT, RYGEL_LMS_ALL_VIDEOS_SQL_ADDED, RYGEL_LMS_ALL_VIDEOS_SQL_REMOVED);
	return self;
}


RygelLMSAllVideos* rygel_lms_all_videos_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelLMSDatabase* lms_db) {
	return rygel_lms_all_videos_construct (RYGEL_LMS_TYPE_ALL_VIDEOS, id, parent, title, lms_db);
}


static void rygel_lms_all_videos_class_init (RygelLMSAllVideosClass * klass) {
	rygel_lms_all_videos_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = rygel_lms_all_videos_real_object_from_statement;
}


static void rygel_lms_all_videos_instance_init (RygelLMSAllVideos * self) {
}


GType rygel_lms_all_videos_get_type (void) {
	static volatile gsize rygel_lms_all_videos_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_lms_all_videos_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLMSAllVideosClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_all_videos_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSAllVideos), 0, (GInstanceInitFunc) rygel_lms_all_videos_instance_init, NULL };
		GType rygel_lms_all_videos_type_id;
		rygel_lms_all_videos_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSAllVideos", &g_define_type_info, 0);
		g_once_init_leave (&rygel_lms_all_videos_type_id__volatile, rygel_lms_all_videos_type_id);
	}
	return rygel_lms_all_videos_type_id__volatile;
}



