/* rygel-transcode-manager.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-transcode-manager.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_AUDIO_TRANSCODER (rygel_audio_transcoder_get_type ())
#define RYGEL_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder))
#define RYGEL_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))
#define RYGEL_IS_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_IS_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_AUDIO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))

typedef struct _RygelAudioTranscoder RygelAudioTranscoder;
typedef struct _RygelAudioTranscoderClass RygelAudioTranscoderClass;

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;

#define RYGEL_TYPE_MP3_TRANSCODER (rygel_mp3_transcoder_get_type ())
#define RYGEL_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3Transcoder))
#define RYGEL_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))
#define RYGEL_IS_MP3_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_IS_MP3_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP3_TRANSCODER))
#define RYGEL_MP3_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP3_TRANSCODER, RygelMP3TranscoderClass))

typedef struct _RygelMP3Transcoder RygelMP3Transcoder;
typedef struct _RygelMP3TranscoderClass RygelMP3TranscoderClass;

#define RYGEL_TYPE_MP2_TS_PROFILE (rygel_mp2_ts_profile_get_type ())

#define RYGEL_TYPE_VIDEO_TRANSCODER (rygel_video_transcoder_get_type ())
#define RYGEL_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoder))
#define RYGEL_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))
#define RYGEL_IS_VIDEO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_IS_VIDEO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_TRANSCODER))
#define RYGEL_VIDEO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_TRANSCODER, RygelVideoTranscoderClass))

typedef struct _RygelVideoTranscoder RygelVideoTranscoder;
typedef struct _RygelVideoTranscoderClass RygelVideoTranscoderClass;

#define RYGEL_TYPE_MP2_TS_TRANSCODER (rygel_mp2_ts_transcoder_get_type ())
#define RYGEL_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder))
#define RYGEL_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))
#define RYGEL_IS_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_IS_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_MP2_TS_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))

typedef struct _RygelMP2TSTranscoder RygelMP2TSTranscoder;
typedef struct _RygelMP2TSTranscoderClass RygelMP2TSTranscoderClass;

#define RYGEL_TYPE_WMV_TRANSCODER (rygel_wmv_transcoder_get_type ())
#define RYGEL_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoder))
#define RYGEL_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))
#define RYGEL_IS_WMV_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_IS_WMV_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMV_TRANSCODER))
#define RYGEL_WMV_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMV_TRANSCODER, RygelWMVTranscoderClass))

typedef struct _RygelWMVTranscoder RygelWMVTranscoder;
typedef struct _RygelWMVTranscoderClass RygelWMVTranscoderClass;

#define RYGEL_TYPE_AAC_TRANSCODER (rygel_aac_transcoder_get_type ())
#define RYGEL_AAC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoder))
#define RYGEL_AAC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoderClass))
#define RYGEL_IS_AAC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AAC_TRANSCODER))
#define RYGEL_IS_AAC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AAC_TRANSCODER))
#define RYGEL_AAC_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AAC_TRANSCODER, RygelAACTranscoderClass))

typedef struct _RygelAACTranscoder RygelAACTranscoder;
typedef struct _RygelAACTranscoderClass RygelAACTranscoderClass;

#define RYGEL_TYPE_AVC_TRANSCODER (rygel_avc_transcoder_get_type ())
#define RYGEL_AVC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoder))
#define RYGEL_AVC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoderClass))
#define RYGEL_IS_AVC_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AVC_TRANSCODER))
#define RYGEL_IS_AVC_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AVC_TRANSCODER))
#define RYGEL_AVC_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AVC_TRANSCODER, RygelAVCTranscoderClass))

typedef struct _RygelAVCTranscoder RygelAVCTranscoder;
typedef struct _RygelAVCTranscoderClass RygelAVCTranscoderClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelTranscodeManagerPrivate {
	GeeArrayList* transcoders;
};

typedef enum  {
	RYGEL_MP2_TS_PROFILE_SD = 0,
	RYGEL_MP2_TS_PROFILE_HD
} RygelMP2TSProfile;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()

static gpointer rygel_transcode_manager_parent_class = NULL;

GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_TRANSCODE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerPrivate))
enum  {
	RYGEL_TRANSCODE_MANAGER_DUMMY_PROPERTY
};
static gboolean rygel_transcode_manager_protocol_equal_func (void* a, void* b);
RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type);
RygelL16Transcoder* rygel_l16_transcoder_new (void);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type);
GType rygel_audio_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
RygelMP3Transcoder* rygel_mp3_transcoder_new (void);
RygelMP3Transcoder* rygel_mp3_transcoder_construct (GType object_type);
GType rygel_mp3_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_profile_get_type (void) G_GNUC_CONST;
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile);
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile);
GType rygel_video_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_transcoder_get_type (void) G_GNUC_CONST;
RygelWMVTranscoder* rygel_wmv_transcoder_new (void);
RygelWMVTranscoder* rygel_wmv_transcoder_construct (GType object_type);
GType rygel_wmv_transcoder_get_type (void) G_GNUC_CONST;
RygelAACTranscoder* rygel_aac_transcoder_new (void);
RygelAACTranscoder* rygel_aac_transcoder_construct (GType object_type);
GType rygel_aac_transcoder_get_type (void) G_GNUC_CONST;
RygelAVCTranscoder* rygel_avc_transcoder_new (void);
RygelAVCTranscoder* rygel_avc_transcoder_construct (GType object_type);
GType rygel_avc_transcoder_get_type (void) G_GNUC_CONST;
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
static gchar* rygel_transcode_manager_real_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2);
static gint _rygel_media_item_compare_transcoders_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error);
gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target);
GQuark rygel_http_request_error_quark (void);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
static gchar* rygel_transcode_manager_real_get_protocol (RygelTranscodeManager* self);
GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self);
static GeeArrayList* rygel_transcode_manager_real_get_protocol_info (RygelTranscodeManager* self);
static gboolean _rygel_transcode_manager_protocol_equal_func_gequal_func (gconstpointer a, gconstpointer b);
const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self);
const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self);
static void rygel_transcode_manager_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean rygel_transcode_manager_protocol_equal_func (void* a, void* b) {
	gboolean result = FALSE;
	void* _tmp0_;
	GUPnPProtocolInfo* _tmp1_;
	GUPnPProtocolInfo* protocol_a;
	void* _tmp2_;
	GUPnPProtocolInfo* _tmp3_;
	GUPnPProtocolInfo* protocol_b;
	gboolean _tmp4_ = FALSE;
	GUPnPProtocolInfo* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GUPnPProtocolInfo* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp17_;
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GUPNP_TYPE_PROTOCOL_INFO) ? ((GUPnPProtocolInfo*) _tmp0_) : NULL);
	protocol_a = _tmp1_;
	_tmp2_ = b;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GUPNP_TYPE_PROTOCOL_INFO) ? ((GUPnPProtocolInfo*) _tmp2_) : NULL);
	protocol_b = _tmp3_;
	_tmp5_ = protocol_a;
	_tmp6_ = gupnp_protocol_info_get_dlna_profile (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = protocol_b;
	_tmp9_ = gupnp_protocol_info_get_dlna_profile (_tmp8_);
	_tmp10_ = _tmp9_;
	if (g_strcmp0 (_tmp7_, _tmp10_) == 0) {
		GUPnPProtocolInfo* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GUPnPProtocolInfo* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp11_ = protocol_a;
		_tmp12_ = gupnp_protocol_info_get_mime_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = protocol_b;
		_tmp15_ = gupnp_protocol_info_get_mime_type (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp4_ = g_strcmp0 (_tmp13_, _tmp16_) == 0;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp17_ = _tmp4_;
	result = _tmp17_;
	_g_object_unref0 (protocol_b);
	_g_object_unref0 (protocol_a);
	return result;
}


RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type) {
	RygelTranscodeManager * self = NULL;
	GeeArrayList* _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelMetaConfig* config;
	gboolean transcoding;
	gboolean lpcm_transcoder;
	gboolean mp3_transcoder;
	gboolean mp2ts_transcoder;
	gboolean wmv_transcoder;
	gboolean aac_transcoder;
	gboolean avc_transcoder;
	gboolean _tmp24_;
	GError * _inner_error_ = NULL;
	self = (RygelTranscodeManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_TRANSCODER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->priv->transcoders);
	self->priv->transcoders = _tmp0_;
	_tmp1_ = rygel_meta_config_get_default ();
	config = _tmp1_;
	transcoding = TRUE;
	lpcm_transcoder = TRUE;
	mp3_transcoder = TRUE;
	mp2ts_transcoder = TRUE;
	wmv_transcoder = TRUE;
	aac_transcoder = TRUE;
	avc_transcoder = TRUE;
	{
		RygelMetaConfig* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = config;
		_tmp3_ = rygel_configuration_get_transcoding ((RygelConfiguration*) _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
		}
		transcoding = _tmp4_;
		_tmp5_ = transcoding;
		if (_tmp5_) {
			RygelMetaConfig* _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
			RygelMetaConfig* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			RygelMetaConfig* _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			RygelMetaConfig* _tmp15_;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_;
			RygelMetaConfig* _tmp18_;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_;
			RygelMetaConfig* _tmp21_;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_;
			_tmp6_ = config;
			_tmp7_ = rygel_configuration_get_lpcm_transcoder ((RygelConfiguration*) _tmp6_, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				goto __catch50_g_error;
			}
			lpcm_transcoder = _tmp8_;
			_tmp9_ = config;
			_tmp10_ = rygel_configuration_get_mp3_transcoder ((RygelConfiguration*) _tmp9_, &_inner_error_);
			_tmp11_ = _tmp10_;
			if (_inner_error_ != NULL) {
				goto __catch50_g_error;
			}
			mp3_transcoder = _tmp11_;
			_tmp12_ = config;
			_tmp13_ = rygel_configuration_get_mp2ts_transcoder ((RygelConfiguration*) _tmp12_, &_inner_error_);
			_tmp14_ = _tmp13_;
			if (_inner_error_ != NULL) {
				goto __catch50_g_error;
			}
			mp2ts_transcoder = _tmp14_;
			_tmp15_ = config;
			_tmp16_ = rygel_configuration_get_wmv_transcoder ((RygelConfiguration*) _tmp15_, &_inner_error_);
			_tmp17_ = _tmp16_;
			if (_inner_error_ != NULL) {
				goto __catch50_g_error;
			}
			wmv_transcoder = _tmp17_;
			_tmp18_ = config;
			_tmp19_ = rygel_configuration_get_aac_transcoder ((RygelConfiguration*) _tmp18_, &_inner_error_);
			_tmp20_ = _tmp19_;
			if (_inner_error_ != NULL) {
				goto __catch50_g_error;
			}
			aac_transcoder = _tmp20_;
			_tmp21_ = config;
			_tmp22_ = rygel_configuration_get_avc_transcoder ((RygelConfiguration*) _tmp21_, &_inner_error_);
			_tmp23_ = _tmp22_;
			if (_inner_error_ != NULL) {
				goto __catch50_g_error;
			}
			avc_transcoder = _tmp23_;
		}
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally50:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp24_ = transcoding;
	if (_tmp24_) {
		gboolean _tmp25_;
		gboolean _tmp29_;
		gboolean _tmp33_;
		gboolean _tmp40_;
		gboolean _tmp44_;
		gboolean _tmp48_;
		_tmp25_ = lpcm_transcoder;
		if (_tmp25_) {
			GeeArrayList* _tmp26_;
			RygelL16Transcoder* _tmp27_;
			RygelL16Transcoder* _tmp28_;
			_tmp26_ = self->priv->transcoders;
			_tmp27_ = rygel_l16_transcoder_new ();
			_tmp28_ = _tmp27_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, (RygelTranscoder*) _tmp28_);
			_g_object_unref0 (_tmp28_);
		}
		_tmp29_ = mp3_transcoder;
		if (_tmp29_) {
			GeeArrayList* _tmp30_;
			RygelMP3Transcoder* _tmp31_;
			RygelMP3Transcoder* _tmp32_;
			_tmp30_ = self->priv->transcoders;
			_tmp31_ = rygel_mp3_transcoder_new ();
			_tmp32_ = _tmp31_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, (RygelTranscoder*) _tmp32_);
			_g_object_unref0 (_tmp32_);
		}
		_tmp33_ = mp2ts_transcoder;
		if (_tmp33_) {
			GeeArrayList* _tmp34_;
			RygelMP2TSTranscoder* _tmp35_;
			RygelMP2TSTranscoder* _tmp36_;
			GeeArrayList* _tmp37_;
			RygelMP2TSTranscoder* _tmp38_;
			RygelMP2TSTranscoder* _tmp39_;
			_tmp34_ = self->priv->transcoders;
			_tmp35_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_SD);
			_tmp36_ = _tmp35_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, (RygelTranscoder*) _tmp36_);
			_g_object_unref0 (_tmp36_);
			_tmp37_ = self->priv->transcoders;
			_tmp38_ = rygel_mp2_ts_transcoder_new (RYGEL_MP2_TS_PROFILE_HD);
			_tmp39_ = _tmp38_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, (RygelTranscoder*) _tmp39_);
			_g_object_unref0 (_tmp39_);
		}
		_tmp40_ = wmv_transcoder;
		if (_tmp40_) {
			GeeArrayList* _tmp41_;
			RygelWMVTranscoder* _tmp42_;
			RygelWMVTranscoder* _tmp43_;
			_tmp41_ = self->priv->transcoders;
			_tmp42_ = rygel_wmv_transcoder_new ();
			_tmp43_ = _tmp42_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, (RygelTranscoder*) _tmp43_);
			_g_object_unref0 (_tmp43_);
		}
		_tmp44_ = aac_transcoder;
		if (_tmp44_) {
			GeeArrayList* _tmp45_;
			RygelAACTranscoder* _tmp46_;
			RygelAACTranscoder* _tmp47_;
			_tmp45_ = self->priv->transcoders;
			_tmp46_ = rygel_aac_transcoder_new ();
			_tmp47_ = _tmp46_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, (RygelTranscoder*) _tmp47_);
			_g_object_unref0 (_tmp47_);
		}
		_tmp48_ = avc_transcoder;
		if (_tmp48_) {
			GeeArrayList* _tmp49_;
			RygelAVCTranscoder* _tmp50_;
			RygelAVCTranscoder* _tmp51_;
			_tmp49_ = self->priv->transcoders;
			_tmp50_ = rygel_avc_transcoder_new ();
			_tmp51_ = _tmp50_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, (RygelTranscoder*) _tmp51_);
			_g_object_unref0 (_tmp51_);
		}
	}
	_g_object_unref0 (config);
	return self;
}


static gchar* rygel_transcode_manager_real_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	g_critical ("Type `%s' does not implement abstract method `rygel_transcode_manager_create_uri_for_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->create_uri_for_item (self, item, thumbnail_index, subtitle_index, transcode_target);
}


static gint _rygel_media_item_compare_transcoders_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = rygel_media_item_compare_transcoders (self, a, b);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error) {
	GList* list;
	RygelMediaItem* _tmp17_;
	GList* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_item != NULL);
	g_return_if_fail (item != NULL);
	list = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _transcoder_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _transcoder_size;
		gint _transcoder_index;
		_tmp0_ = self->priv->transcoders;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_transcoder_list = _tmp1_;
		_tmp2_ = _transcoder_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_transcoder_size = _tmp4_;
		_transcoder_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelTranscoder* transcoder;
			RygelTranscoder* _tmp11_;
			RygelMediaItem* _tmp12_;
			guint _tmp13_ = 0U;
			guint _tmp14_;
			_tmp5_ = _transcoder_index;
			_transcoder_index = _tmp5_ + 1;
			_tmp6_ = _transcoder_index;
			_tmp7_ = _transcoder_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _transcoder_list;
			_tmp9_ = _transcoder_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			transcoder = (RygelTranscoder*) _tmp10_;
			_tmp11_ = transcoder;
			_tmp12_ = item;
			_tmp13_ = rygel_transcoder_get_distance (_tmp11_, _tmp12_);
			_tmp14_ = G_MAXUINT;
			if (_tmp13_ != _tmp14_) {
				RygelTranscoder* _tmp15_;
				RygelTranscoder* _tmp16_;
				_tmp15_ = transcoder;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				list = g_list_append (list, _tmp16_);
			}
			_g_object_unref0 (transcoder);
		}
		_g_object_unref0 (_transcoder_list);
	}
	_tmp17_ = item;
	list = g_list_sort_with_data (list, _rygel_media_item_compare_transcoders_gcompare_data_func, _tmp17_);
	_tmp18_ = list;
	{
		GList* transcoder_collection = NULL;
		GList* transcoder_it = NULL;
		transcoder_collection = _tmp18_;
		for (transcoder_it = transcoder_collection; transcoder_it != NULL; transcoder_it = transcoder_it->next) {
			RygelTranscoder* _tmp19_;
			RygelTranscoder* transcoder = NULL;
			_tmp19_ = _g_object_ref0 ((RygelTranscoder*) transcoder_it->data);
			transcoder = _tmp19_;
			{
				RygelTranscoder* _tmp20_;
				GUPnPDIDLLiteItem* _tmp21_;
				RygelMediaItem* _tmp22_;
				GUPnPDIDLLiteResource* _tmp23_ = NULL;
				GUPnPDIDLLiteResource* _tmp24_;
				_tmp20_ = transcoder;
				_tmp21_ = didl_item;
				_tmp22_ = item;
				_tmp23_ = rygel_transcoder_add_resource (_tmp20_, _tmp21_, _tmp22_, self, &_inner_error_);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp24_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (transcoder);
					__g_list_free__g_object_unref0_0 (list);
					return;
				}
				_g_object_unref0 (transcoder);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (list);
}


RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	RygelTranscoder* transcoder;
	RygelTranscoder* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	transcoder = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _iter_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _iter_size;
		gint _iter_index;
		_tmp0_ = self->priv->transcoders;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_iter_list = _tmp1_;
		_tmp2_ = _iter_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_iter_size = _tmp4_;
		_iter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelTranscoder* iter;
			RygelTranscoder* _tmp11_;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp5_ = _iter_index;
			_iter_index = _tmp5_ + 1;
			_tmp6_ = _iter_index;
			_tmp7_ = _iter_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _iter_list;
			_tmp9_ = _iter_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			iter = (RygelTranscoder*) _tmp10_;
			_tmp11_ = iter;
			_tmp12_ = target;
			_tmp13_ = rygel_transcoder_can_handle (_tmp11_, _tmp12_);
			if (_tmp13_) {
				RygelTranscoder* _tmp14_;
				RygelTranscoder* _tmp15_;
				_tmp14_ = iter;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				_g_object_unref0 (transcoder);
				transcoder = _tmp15_;
			}
			_g_object_unref0 (iter);
		}
		_g_object_unref0 (_iter_list);
	}
	_tmp16_ = transcoder;
	if (_tmp16_ == NULL) {
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_;
		GError* _tmp19_;
		_tmp17_ = _ ("No transcoder available for target format '%s'");
		_tmp18_ = target;
		_tmp19_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp17_, _tmp18_);
		_inner_error_ = _tmp19_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (transcoder);
		return NULL;
	}
	result = transcoder;
	return result;
}


static gchar* rygel_transcode_manager_real_get_protocol (RygelTranscodeManager* self) {
	g_critical ("Type `%s' does not implement abstract method `rygel_transcode_manager_get_protocol'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->get_protocol (self);
}


static gboolean _rygel_transcode_manager_protocol_equal_func_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = rygel_transcode_manager_protocol_equal_func (a, b);
	return result;
}


static GeeArrayList* rygel_transcode_manager_real_get_protocol_info (RygelTranscodeManager* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* protocol_infos;
	_tmp0_ = gee_array_list_new (GUPNP_TYPE_PROTOCOL_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, _rygel_transcode_manager_protocol_equal_func_gequal_func);
	protocol_infos = _tmp0_;
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _transcoder_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _transcoder_size;
		gint _transcoder_index;
		_tmp1_ = self->priv->transcoders;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_transcoder_list = _tmp2_;
		_tmp3_ = _transcoder_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_transcoder_size = _tmp5_;
		_transcoder_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			RygelTranscoder* transcoder;
			GUPnPProtocolInfo* _tmp12_;
			GUPnPProtocolInfo* protocol_info;
			GUPnPProtocolInfo* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			GUPnPProtocolInfo* _tmp16_;
			RygelTranscoder* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			GUPnPProtocolInfo* _tmp20_;
			RygelTranscoder* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			GeeArrayList* _tmp24_;
			GUPnPProtocolInfo* _tmp25_;
			_tmp6_ = _transcoder_index;
			_transcoder_index = _tmp6_ + 1;
			_tmp7_ = _transcoder_index;
			_tmp8_ = _transcoder_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _transcoder_list;
			_tmp10_ = _transcoder_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			transcoder = (RygelTranscoder*) _tmp11_;
			_tmp12_ = gupnp_protocol_info_new ();
			protocol_info = _tmp12_;
			_tmp13_ = protocol_info;
			_tmp14_ = rygel_transcode_manager_get_protocol (self);
			_tmp15_ = _tmp14_;
			gupnp_protocol_info_set_protocol (_tmp13_, _tmp15_);
			_g_free0 (_tmp15_);
			_tmp16_ = protocol_info;
			_tmp17_ = transcoder;
			_tmp18_ = rygel_transcoder_get_mime_type (_tmp17_);
			_tmp19_ = _tmp18_;
			gupnp_protocol_info_set_mime_type (_tmp16_, _tmp19_);
			_tmp20_ = protocol_info;
			_tmp21_ = transcoder;
			_tmp22_ = rygel_transcoder_get_dlna_profile (_tmp21_);
			_tmp23_ = _tmp22_;
			gupnp_protocol_info_set_dlna_profile (_tmp20_, _tmp23_);
			_tmp24_ = protocol_infos;
			_tmp25_ = protocol_info;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
			_g_object_unref0 (protocol_info);
			_g_object_unref0 (transcoder);
		}
		_g_object_unref0 (_transcoder_list);
	}
	result = protocol_infos;
	return result;
}


GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->get_protocol_info (self);
}


static void rygel_transcode_manager_class_init (RygelTranscodeManagerClass * klass) {
	rygel_transcode_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTranscodeManagerPrivate));
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->create_uri_for_item = rygel_transcode_manager_real_create_uri_for_item;
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol = rygel_transcode_manager_real_get_protocol;
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol_info = rygel_transcode_manager_real_get_protocol_info;
	G_OBJECT_CLASS (klass)->finalize = rygel_transcode_manager_finalize;
}


static void rygel_transcode_manager_instance_init (RygelTranscodeManager * self) {
	self->priv = RYGEL_TRANSCODE_MANAGER_GET_PRIVATE (self);
}


static void rygel_transcode_manager_finalize (GObject* obj) {
	RygelTranscodeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager);
	_g_object_unref0 (self->priv->transcoders);
	G_OBJECT_CLASS (rygel_transcode_manager_parent_class)->finalize (obj);
}


/**
 * Responsible for management of all transcoders:
 *    - gets the appropriate transcoder given a transcoding target.
 *    - provide all possible transcoding resources for items.
 */
GType rygel_transcode_manager_get_type (void) {
	static volatile gsize rygel_transcode_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcode_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscodeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcode_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscodeManager), 0, (GInstanceInitFunc) rygel_transcode_manager_instance_init, NULL };
		GType rygel_transcode_manager_type_id;
		rygel_transcode_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscodeManager", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_transcode_manager_type_id__volatile, rygel_transcode_manager_type_id);
	}
	return rygel_transcode_manager_type_id__volatile;
}



