/* rygel-core.h generated by valac 0.17.4.16-52707, the Vala compiler, do not modify */


#ifndef __RYGEL_CORE_H__
#define __RYGEL_CORE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <libxml/tree.h>

G_BEGIN_DECLS


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_CMDLINE_CONFIG (rygel_cmdline_config_get_type ())
#define RYGEL_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig))
#define RYGEL_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))
#define RYGEL_IS_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_IS_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_CMDLINE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))

typedef struct _RygelCmdlineConfig RygelCmdlineConfig;
typedef struct _RygelCmdlineConfigClass RygelCmdlineConfigClass;
typedef struct _RygelCmdlineConfigPrivate RygelCmdlineConfigPrivate;

#define RYGEL_TYPE_CONNECTION_MANAGER (rygel_connection_manager_get_type ())
#define RYGEL_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONNECTION_MANAGER, RygelConnectionManager))
#define RYGEL_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONNECTION_MANAGER, RygelConnectionManagerClass))
#define RYGEL_IS_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONNECTION_MANAGER))
#define RYGEL_IS_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONNECTION_MANAGER))
#define RYGEL_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONNECTION_MANAGER, RygelConnectionManagerClass))

typedef struct _RygelConnectionManager RygelConnectionManager;
typedef struct _RygelConnectionManagerClass RygelConnectionManagerClass;
typedef struct _RygelConnectionManagerPrivate RygelConnectionManagerPrivate;

#define TYPE_DESCRIPTION_FILE (description_file_get_type ())
#define DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESCRIPTION_FILE, DescriptionFile))
#define DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESCRIPTION_FILE, DescriptionFileClass))
#define IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESCRIPTION_FILE))
#define IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESCRIPTION_FILE))
#define DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESCRIPTION_FILE, DescriptionFileClass))

typedef struct _DescriptionFile DescriptionFile;
typedef struct _DescriptionFileClass DescriptionFileClass;
typedef struct _DescriptionFilePrivate DescriptionFilePrivate;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
typedef struct _RygelRootDevicePrivate RygelRootDevicePrivate;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;

#define RYGEL_TYPE_DBUS_INTERFACE (rygel_dbus_interface_get_type ())
#define RYGEL_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_INTERFACE, RygelDBusInterface))
#define RYGEL_IS_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_INTERFACE))
#define RYGEL_DBUS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DBUS_INTERFACE, RygelDBusInterfaceIface))

typedef struct _RygelDBusInterface RygelDBusInterface;
typedef struct _RygelDBusInterfaceIface RygelDBusInterfaceIface;

#define RYGEL_TYPE_DBUS_INTERFACE_PROXY (rygel_dbus_interface_proxy_get_type ())

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_LOG_HANDLER (rygel_log_handler_get_type ())
#define RYGEL_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandler))
#define RYGEL_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))
#define RYGEL_IS_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_IS_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_LOG_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))

typedef struct _RygelLogHandler RygelLogHandler;
typedef struct _RygelLogHandlerClass RygelLogHandlerClass;
typedef struct _RygelLogHandlerPrivate RygelLogHandlerPrivate;

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;
typedef struct _RygelMetaConfigPrivate RygelMetaConfigPrivate;

#define RYGEL_TYPE_PLUGIN_LOADER (rygel_plugin_loader_get_type ())
#define RYGEL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader))
#define RYGEL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))
#define RYGEL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))

typedef struct _RygelPluginLoader RygelPluginLoader;
typedef struct _RygelPluginLoaderClass RygelPluginLoaderClass;
typedef struct _RygelPluginLoaderPrivate RygelPluginLoaderPrivate;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
typedef struct _RygelUserConfigPrivate RygelUserConfigPrivate;

#define RYGEL_TYPE_MEDIA_DEVICE (rygel_media_device_get_type ())
#define RYGEL_MEDIA_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice))
#define RYGEL_MEDIA_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDeviceClass))
#define RYGEL_IS_MEDIA_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DEVICE))
#define RYGEL_IS_MEDIA_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DEVICE))
#define RYGEL_MEDIA_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDeviceClass))

typedef struct _RygelMediaDevice RygelMediaDevice;
typedef struct _RygelMediaDeviceClass RygelMediaDeviceClass;
typedef struct _RygelMediaDevicePrivate RygelMediaDevicePrivate;

#define FREE_DESKTOP_TYPE_DBUS_REQUEST_NAME_REPLY (free_desktop_dbus_request_name_reply_get_type ())

#define FREE_DESKTOP_TYPE_DBUS_OBJECT (free_desktop_dbus_object_get_type ())
#define FREE_DESKTOP_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT, FreeDesktopDBusObject))
#define FREE_DESKTOP_IS_DBUS_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT))
#define FREE_DESKTOP_DBUS_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_DBUS_OBJECT, FreeDesktopDBusObjectIface))

typedef struct _FreeDesktopDBusObject FreeDesktopDBusObject;
typedef struct _FreeDesktopDBusObjectIface FreeDesktopDBusObjectIface;

#define FREE_DESKTOP_TYPE_DBUS_OBJECT_PROXY (free_desktop_dbus_object_proxy_get_type ())

#define FREE_DESKTOP_TYPE_PROPERTIES (free_desktop_properties_get_type ())
#define FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopProperties))
#define FREE_DESKTOP_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_PROPERTIES))
#define FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopPropertiesIface))

typedef struct _FreeDesktopProperties FreeDesktopProperties;
typedef struct _FreeDesktopPropertiesIface FreeDesktopPropertiesIface;

#define FREE_DESKTOP_TYPE_PROPERTIES_PROXY (free_desktop_properties_proxy_get_type ())

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;

#define RYGEL_TYPE_XML_UTILS (rygel_xml_utils_get_type ())
#define RYGEL_XML_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XML_UTILS, RygelXMLUtils))
#define RYGEL_XML_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XML_UTILS, RygelXMLUtilsClass))
#define RYGEL_IS_XML_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XML_UTILS))
#define RYGEL_IS_XML_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XML_UTILS))
#define RYGEL_XML_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XML_UTILS, RygelXMLUtilsClass))

typedef struct _RygelXMLUtils RygelXMLUtils;
typedef struct _RygelXMLUtilsClass RygelXMLUtilsClass;
typedef struct _RygelXMLUtilsPrivate RygelXMLUtilsPrivate;

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()
struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_aac_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_avc_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelCmdlineConfig {
	GObject parent_instance;
	RygelCmdlineConfigPrivate * priv;
};

struct _RygelCmdlineConfigClass {
	GObjectClass parent_class;
};

struct _RygelConnectionManager {
	GUPnPService parent_instance;
	RygelConnectionManagerPrivate * priv;
	gchar* sink_protocol_info;
	gchar* connection_ids;
	gchar* source_protocol_info;
	gint rcs_id;
	gint av_transport_id;
	gchar* direction;
};

struct _RygelConnectionManagerClass {
	GUPnPServiceClass parent_class;
};

struct _DescriptionFile {
	GObject parent_instance;
	DescriptionFilePrivate * priv;
};

struct _DescriptionFileClass {
	GObjectClass parent_class;
};

struct _RygelRootDevice {
	GUPnPRootDevice parent_instance;
	RygelRootDevicePrivate * priv;
};

struct _RygelRootDeviceClass {
	GUPnPRootDeviceClass parent_class;
};

typedef enum  {
	ROOT_DEVICE_FACTORY_ERROR_XML_PARSE
} RootDeviceFactoryError;
#define ROOT_DEVICE_FACTORY_ERROR root_device_factory_error_quark ()
struct _RygelRootDeviceFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelRootDeviceFactoryPrivate * priv;
	GUPnPContext* context;
};

struct _RygelRootDeviceFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelRootDeviceFactory *self);
};

struct _RygelDBusInterfaceIface {
	GTypeInterface parent_iface;
	void (*shutdown) (RygelDBusInterface* self, GError** error);
};

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelLogHandler {
	GObject parent_instance;
	RygelLogHandlerPrivate * priv;
};

struct _RygelLogHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMetaConfig {
	GObject parent_instance;
	RygelMetaConfigPrivate * priv;
};

struct _RygelMetaConfigClass {
	GObjectClass parent_class;
};

struct _RygelPluginLoader {
	GObject parent_instance;
	RygelPluginLoaderPrivate * priv;
};

struct _RygelPluginLoaderClass {
	GObjectClass parent_class;
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
	void (*apply_hacks) (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelUserConfig {
	GObject parent_instance;
	RygelUserConfigPrivate * priv;
	GKeyFile* key_file;
	GKeyFile* sys_key_file;
};

struct _RygelUserConfigClass {
	GObjectClass parent_class;
};

struct _RygelMediaDevice {
	GObject parent_instance;
	RygelMediaDevicePrivate * priv;
};

struct _RygelMediaDeviceClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()
typedef enum  {
	FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER = 1,
	FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_IN_QUEUE,
	FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_EXISTS,
	FREE_DESKTOP_DBUS_REQUEST_NAME_REPLY_ALREADY_OWNER
} FreeDesktopDBusRequestNameReply;

struct _FreeDesktopDBusObjectIface {
	GTypeInterface parent_iface;
	guint32 (*request_name) (FreeDesktopDBusObject* self, const gchar* name, guint32 flags, GError** error);
	guint32 (*start_service_by_name) (FreeDesktopDBusObject* self, const gchar* name, guint32 flags, GError** error);
	void (*list_names) (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_activatable_names) (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_activatable_names_finish) (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _FreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
	void (*get_all) (FreeDesktopProperties* self, const gchar* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*get_all_finish) (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelXMLUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelXMLUtilsPrivate * priv;
};

struct _RygelXMLUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (RygelXMLUtils *self);
};


GQuark rygel_cmdline_config_error_quark (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_cmdline_config_get_type (void) G_GNUC_CONST;
RygelCmdlineConfig* rygel_cmdline_config_get_default (void);
void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error);
gchar* rygel_cmdline_config_get_config_file (RygelCmdlineConfig* self, GError** error);
RygelCmdlineConfig* rygel_cmdline_config_new (void);
RygelCmdlineConfig* rygel_cmdline_config_construct (GType object_type);
GType rygel_connection_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_CONNECTION_MANAGER_UPNP_ID "urn:upnp-org:serviceId:ConnectionManager"
#define RYGEL_CONNECTION_MANAGER_UPNP_TYPE "urn:schemas-upnp-org:service:ConnectionManager:2"
#define RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH "xml/ConnectionManager.xml"
RygelConnectionManager* rygel_connection_manager_new (void);
RygelConnectionManager* rygel_connection_manager_construct (GType object_type);
GType description_file_get_type (void) G_GNUC_CONST;
DescriptionFile* description_file_new (const gchar* template, GError** error);
DescriptionFile* description_file_construct (GType object_type, const gchar* template, GError** error);
DescriptionFile* description_file_new_from_xml_document (GUPnPXMLDoc* doc);
DescriptionFile* description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
void description_file_set_device_type (DescriptionFile* self, const gchar* device_type);
void description_file_set_model_name (DescriptionFile* self, const gchar* model_name);
void description_file_set_model_number (DescriptionFile* self, const gchar* model_number);
void description_file_set_friendly_name (DescriptionFile* self, const gchar* friendly_name);
gchar* description_file_get_friendly_name (DescriptionFile* self);
void description_file_modify_service_type (DescriptionFile* self, const gchar* old_type, const gchar* new_type);
void description_file_save (DescriptionFile* self, const gchar* path, GError** error);
GType rygel_root_device_get_type (void) G_GNUC_CONST;
GType rygel_plugin_get_type (void) G_GNUC_CONST;
RygelRootDevice* rygel_root_device_new (GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
RygelRootDevice* rygel_root_device_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
GeeArrayList* rygel_root_device_get_services (RygelRootDevice* self);
GQuark root_device_factory_error_quark (void);
gpointer rygel_root_device_factory_ref (gpointer instance);
void rygel_root_device_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_root_device_factory (GValue* value, gpointer v_object);
void rygel_value_take_root_device_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_root_device_factory (const GValue* value);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
GType rygel_dbus_interface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_dbus_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_dbus_interface_get_type (void) G_GNUC_CONST;
void rygel_dbus_interface_shutdown (RygelDBusInterface* self, GError** error);
#define RYGEL_DBUS_INTERFACE_SERVICE_NAME "org.gnome.Rygel1"
#define RYGEL_DBUS_INTERFACE_OBJECT_PATH "/org/gnome/Rygel1"
GType rygel_log_level_get_type (void) G_GNUC_CONST;
GType rygel_log_handler_get_type (void) G_GNUC_CONST;
RygelLogHandler* rygel_log_handler_get_default (void);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
void rygel_meta_config_register_configuration (RygelConfiguration* config);
void rygel_meta_config_register_default_configurations (void);
RygelMetaConfig* rygel_meta_config_new (void);
RygelMetaConfig* rygel_meta_config_construct (GType object_type);
GType rygel_plugin_loader_get_type (void) G_GNUC_CONST;
RygelPluginLoader* rygel_plugin_loader_new (void);
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type);
void rygel_plugin_loader_load_plugins (RygelPluginLoader* self);
gboolean rygel_plugin_loader_plugin_disabled (RygelPluginLoader* self, const gchar* name);
void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin);
RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const gchar* name);
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
RygelPlugin* rygel_plugin_new (const gchar* desc_path, const gchar* name, const gchar* title, const gchar* description);
RygelPlugin* rygel_plugin_construct (GType object_type, const gchar* desc_path, const gchar* name, const gchar* title, const gchar* description);
void rygel_plugin_add_resource (RygelPlugin* self, RygelResourceInfo* resource_info);
void rygel_plugin_add_icon (RygelPlugin* self, RygelIconInfo* icon_info);
void rygel_plugin_apply_hacks (RygelPlugin* self, RygelRootDevice* device, const gchar* description_path, GError** error);
gboolean rygel_plugin_get_active (RygelPlugin* self);
void rygel_plugin_set_active (RygelPlugin* self, gboolean value);
RygelResourceInfo* rygel_resource_info_new (const gchar* upnp_id, const gchar* upnp_type, const gchar* description_path, GType type);
RygelResourceInfo* rygel_resource_info_construct (GType object_type, const gchar* upnp_id, const gchar* upnp_type, const gchar* description_path, GType type);
GType rygel_user_config_get_type (void) G_GNUC_CONST;
#define RYGEL_USER_CONFIG_CONFIG_FILE "rygel.conf"
#define RYGEL_USER_CONFIG_IFACE_KEY "interface"
#define RYGEL_USER_CONFIG_PORT_KEY "port"
#define RYGEL_USER_CONFIG_ENABLED_KEY "enabled"
#define RYGEL_USER_CONFIG_UPNP_ENABLED_KEY "upnp-" RYGEL_USER_CONFIG_ENABLED_KEY
#define RYGEL_USER_CONFIG_TITLE_KEY "title"
#define RYGEL_USER_CONFIG_TRANSCODING_KEY "enable-transcoding"
#define RYGEL_USER_CONFIG_MP3_TRANSCODER_KEY "enable-mp3-transcoder"
#define RYGEL_USER_CONFIG_MP2TS_TRANSCODER_KEY "enable-mp2ts-transcoder"
#define RYGEL_USER_CONFIG_LPCM_TRANSCODER_KEY "enable-lpcm-transcoder"
#define RYGEL_USER_CONFIG_WMV_TRANSCODER_KEY "enable-wmv-transcoder"
#define RYGEL_USER_CONFIG_AAC_TRANSCODER_KEY "enable-aac-transcoder"
#define RYGEL_USER_CONFIG_AVC_TRANSCODER_KEY "enable-avc-transcoder"
#define RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY "allow-upload"
#define RYGEL_USER_CONFIG_ALLOW_DELETION_KEY "allow-deletion"
#define RYGEL_USER_CONFIG_LOG_LEVELS_KEY "log-level"
#define RYGEL_USER_CONFIG_PLUGIN_PATH_KEY "plugin-path"
#define RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY "upload-folder"
#define RYGEL_USER_CONFIG_VIDEO_UPLOAD_DIR_PATH_KEY "video-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
#define RYGEL_USER_CONFIG_MUSIC_UPLOAD_DIR_PATH_KEY "music-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
#define RYGEL_USER_CONFIG_PICTURE_UPLOAD_DIR_PATH_KEY "picture-" RYGEL_USER_CONFIG_UPLOAD_FOLDER_KEY
RygelUserConfig* rygel_user_config_get_default (GError** error);
RygelUserConfig* rygel_user_config_new (const gchar* file, GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type, const gchar* file, GError** error);
GType rygel_media_device_get_type (void) G_GNUC_CONST;
RygelMediaDevice* rygel_media_device_construct (GType object_type);
void rygel_media_device_add_interface (RygelMediaDevice* self, const gchar* iface);
void rygel_media_device_remove_interface (RygelMediaDevice* self, const gchar* iface);
GList* rygel_media_device_get_interfaces (RygelMediaDevice* self);
RygelPlugin* rygel_media_device_get_plugin (RygelMediaDevice* self);
void rygel_media_device_set_plugin (RygelMediaDevice* self, RygelPlugin* value);
GQuark rygel_configuration_error_quark (void);
gboolean rygel_configuration_get_upnp_enabled (RygelConfiguration* self, GError** error);
gchar* rygel_configuration_get_interface (RygelConfiguration* self, GError** error);
gint rygel_configuration_get_port (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_transcoding (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_mp3_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_mp2ts_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_lpcm_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_wmv_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_aac_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_avc_transcoder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_allow_upload (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_allow_deletion (RygelConfiguration* self, GError** error);
gchar* rygel_configuration_get_log_levels (RygelConfiguration* self, GError** error);
gchar* rygel_configuration_get_plugin_path (RygelConfiguration* self, GError** error);
gchar* rygel_configuration_get_video_upload_folder (RygelConfiguration* self, GError** error);
gchar* rygel_configuration_get_music_upload_folder (RygelConfiguration* self, GError** error);
gchar* rygel_configuration_get_picture_upload_folder (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_enabled (RygelConfiguration* self, const gchar* section, GError** error);
gchar* rygel_configuration_get_title (RygelConfiguration* self, const gchar* section, GError** error);
gchar* rygel_configuration_get_string (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
GeeArrayList* rygel_configuration_get_string_list (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
gint rygel_configuration_get_int (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
GeeArrayList* rygel_configuration_get_int_list (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
#define FREE_DESKTOP_DBUS_SERVICE "org.freedesktop.DBus"
#define FREE_DESKTOP_DBUS_OBJECT_PATH "/org/freedesktop/DBus"
GType free_desktop_dbus_request_name_reply_get_type (void) G_GNUC_CONST;
GType free_desktop_dbus_object_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_dbus_object_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_dbus_object_get_type (void) G_GNUC_CONST;
guint32 free_desktop_dbus_object_request_name (FreeDesktopDBusObject* self, const gchar* name, guint32 flags, GError** error);
guint32 free_desktop_dbus_object_start_service_by_name (FreeDesktopDBusObject* self, const gchar* name, guint32 flags, GError** error);
void free_desktop_dbus_object_list_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** free_desktop_dbus_object_list_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
void free_desktop_dbus_object_list_activatable_names (FreeDesktopDBusObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** free_desktop_dbus_object_list_activatable_names_finish (FreeDesktopDBusObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
GType free_desktop_properties_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_properties_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_properties_get_type (void) G_GNUC_CONST;
void free_desktop_properties_get_all (FreeDesktopProperties* self, const gchar* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* free_desktop_properties_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
RygelIconInfo* rygel_icon_info_new (const gchar* mime_type, const gchar* file_extension);
RygelIconInfo* rygel_icon_info_construct (GType object_type, const gchar* mime_type, const gchar* file_extension);
gpointer rygel_xml_utils_ref (gpointer instance);
void rygel_xml_utils_unref (gpointer instance);
GParamSpec* rygel_param_spec_xml_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_xml_utils (GValue* value, gpointer v_object);
void rygel_value_take_xml_utils (GValue* value, gpointer v_object);
gpointer rygel_value_get_xml_utils (const GValue* value);
GType rygel_xml_utils_get_type (void) G_GNUC_CONST;
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
RygelXMLUtils* rygel_xml_utils_new (void);
RygelXMLUtils* rygel_xml_utils_construct (GType object_type);


G_END_DECLS

#endif
