/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __UTIL_H__
#define __UTIL_H__

#include <glib.h>
#include <time.h> /* for time_t */

/*---------------------------------------------------------------------------
**
**  UI LOCKING FOR THREADS
*/

/**
 * Used to lock the UI thread.
 *
 * @see pan_unlock
 * @see pan_lock_unconditional
 */
#define pan_lock() pan_lock_from(__FILE__, __LINE__)
void pan_lock_from (const gchar * file, int line);

/**
 * Used to lock the UI thread unconditionally.
 * The difference between this and pan_lock is that this will attempt
 * to lock the gui even if we're in the main thread.  This is important
 * for locking down gui calls being made from timeouts in the main thread.
 *
 * @see pan_lock
 * @see pan_unlock_unconditional
 */
#define pan_lock_unconditional() pan_lock_unconditional_from(__FILE__,__LINE__)
void pan_lock_unconditional_from (const gchar * file, int line);

/**
 * Used to unlock the UI thread after pan_lock() has been called.
 *
 * @see pan_lock
 * @see pan_unlock_unconditional
 */
#define pan_unlock() pan_unlock_from(__FILE__, __LINE__)
void pan_unlock_from (const gchar * file, int line);

/**
 * Used to unlock the UI thread after pan_lock_unconditional() has been called.
 *
 * The difference between this and pan_unlock is that this will attempt
 * to unlock the gui even if we're in the main thread.  This is important
 * for unlocking gui calls being made from timeouts in the main thread.
 *
 * @see pan_lock_unconditional
 * @see pan_unlock
 */
#define pan_unlock_unconditional() pan_unlock_unconditional_from(__FILE__,__LINE__)
void pan_unlock_unconditional_from (const gchar * file, int line);



gchar* get_default_author_address (void);

gchar* get_default_author_from (void);

void pan_info_dialog (const char * fmt, ...);

void pan_error_dialog (const char * fmt, ...);

void pan_error_dialog_parented (gpointer gtkwindow, const char * fmt, ...);


char* get_fqdn (const char * host);

char* get_host_name (void);

void open_outside_file (const gchar * filename);

gchar* linkify_text (const gchar * text);

void replace_gstr (char ** target_free_old, char * assign_from_me);

void check_and_warn_if_version_change (void);

gchar* get_date_display_string (time_t date, const gchar * strftime_fmt);

void pan_url_show (const gchar * url);

#define is_nonempty_string(A) ((A) && *(A)!='\0')





#endif /* __UTIL_H__ */
