/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __MESSAGE_WINDOW_H__
#define __MESSAGE_WINDOW_H__

#include <glib.h>
#include <pan/base/article.h>

typedef enum
{
	NNTP_READ,
	NNTP_POST,
	NNTP_REPLY,
	EMAIL_REPLY,
	EMAIL_AND_POST_REPLY,
	EMAIL_FORWARD,
	EDIT_ORIGINAL
}
MessageWindowType;

extern gboolean use_message_window_always;

extern void message_followup_reply_window  (void);

extern void message_followup_window        (void);

extern void message_reply_window           (void);

extern void message_forward_window         (void);

extern void message_edit_window            (Article     * article);

extern void message_read_window            (Article     * article);

extern void message_post_window            (void);

extern void message_window_new             (Article           * article,
                                            MessageWindowType   type);

#endif
