#!/usr/bin/env python

# Copyright (C) 2009,2010 Junta de Andalucia
# 
# Authors:
#   Roberto Majadas <roberto.majadas at openshine.com>
#   Cesar Garcia Tapia <cesar.garcia.tapia at openshine.com>
#   Luis de Bethencourt <luibg at openshine.com>
#   Pablo Vieytes <pvieytes at openshine.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
# USA

import os
import sys
import gettext
import __builtin__

__builtin__._ = gettext.gettext

GETTEXT_DOMAIN = 'nanny'
if os.name == "posix":
    locale_dir = os.path.join("/usr", "share/" ,"locale/")
elif os.name == "nt":
    if not hasattr(sys, "frozen") :
        file_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
        for x in range(7):
            file_dir = os.path.dirname(file_dir)

        root_path = file_dir
        locale_dir = os.path.join(root_path, "share" ,"locale")
        print "LOCALE PATH = %s" % locale_dir
    else:
        root_path = os.path.dirname(os.path.dirname(unicode(sys.executable, sys.getfilesystemencoding( ))))
        locale_dir = os.path.join(root_path, "share" ,"locale")
        print "LOCALE PATH = %s" % locale_dir

if os.name == "posix" :
    gettext.bindtextdomain(GETTEXT_DOMAIN, locale_dir)
    gettext.textdomain(GETTEXT_DOMAIN)
else:
    locale.setlocale(locale.LC_ALL, '')
    if os.name == 'nt':
        # windows hack for locale setting 
        lang = os.getenv('LANG')
        if lang is None:
            defaultLang, defaultEnc = locale.getdefaultlocale()
            if defaultLang:
                lang = defaultLang
        if lang:
            os.environ['LANG'] = lang

    gettext.bindtextdomain(GETTEXT_DOMAIN, locale_dir)
    gettext.textdomain(GETTEXT_DOMAIN)
