
#include <src/SerialStreamRecorder.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "src/MoUtils.h"
#include <gobject/gvaluecollector.h>




struct _moserialSerialStreamRecorderPrivate {
	GFile* file;
	char* uri;
	gboolean isOpen;
	GFileOutputStream* fos;
	moserialSerialStreamRecorderDirection direction;
};

#define MOSERIAL_SERIAL_STREAM_RECORDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderPrivate))
enum  {
	MOSERIAL_SERIAL_STREAM_RECORDER_DUMMY_PROPERTY
};
static void moserial_serial_stream_recorder_write (moserialSerialStreamRecorder* self, guchar data);
static gpointer moserial_serial_stream_recorder_parent_class = NULL;
static void moserial_serial_stream_recorder_finalize (moserialSerialStreamRecorder* obj);




GType moserial_serial_stream_recorder_direction_get_type (void) {
	static GType moserial_serial_stream_recorder_direction_type_id = 0;
	if (G_UNLIKELY (moserial_serial_stream_recorder_direction_type_id == 0)) {
		static const GEnumValue values[] = {{MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING", "incoming"}, {MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING", "outgoing"}, {MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH", "both"}, {MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_NULL, "MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_NULL", "null"}, {0, NULL, NULL}};
		moserial_serial_stream_recorder_direction_type_id = g_enum_register_static ("moserialSerialStreamRecorderDirection", values);
	}
	return moserial_serial_stream_recorder_direction_type_id;
}


void moserial_serial_stream_recorder_open (moserialSerialStreamRecorder* self, const char* filename, moserialSerialStreamRecorderDirection direction, GError** error) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	inner_error = NULL;
	{
		GFile* _tmp0;
		GFileOutputStream* _tmp1;
		GFileOutputStream* _tmp2;
		char* _tmp3;
		_tmp0 = NULL;
		self->priv->file = (_tmp0 = g_file_new_for_path (filename), (self->priv->file == NULL) ? NULL : (self->priv->file = (g_object_unref (self->priv->file), NULL)), _tmp0);
		_tmp1 = g_file_replace (self->priv->file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch7_g_error;
			goto __finally7;
		}
		_tmp2 = NULL;
		self->priv->fos = (_tmp2 = _tmp1, (self->priv->fos == NULL) ? NULL : (self->priv->fos = (g_object_unref (self->priv->fos), NULL)), _tmp2);
		self->priv->isOpen = TRUE;
		_tmp3 = NULL;
		self->priv->uri = (_tmp3 = g_file_get_uri (self->priv->file), self->priv->uri = (g_free (self->priv->uri), NULL), _tmp3);
		self->priv->direction = direction;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			GFile* _tmp4;
			GFileOutputStream* _tmp5;
			GError* _tmp6;
			self->priv->isOpen = FALSE;
			_tmp4 = NULL;
			self->priv->file = (_tmp4 = NULL, (self->priv->file == NULL) ? NULL : (self->priv->file = (g_object_unref (self->priv->file), NULL)), _tmp4);
			_tmp5 = NULL;
			self->priv->fos = (_tmp5 = NULL, (self->priv->fos == NULL) ? NULL : (self->priv->fos = (g_object_unref (self->priv->fos), NULL)), _tmp5);
			_tmp6 = NULL;
			inner_error = (_tmp6 = e, (_tmp6 == NULL) ? ((gpointer) _tmp6) : g_error_copy (_tmp6));
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				return;
			}
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally7:
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
}


static void moserial_serial_stream_recorder_write (moserialSerialStreamRecorder* self, guchar data) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	if (self->priv->isOpen) {
		guchar* _tmp0;
		gint o_size;
		gint o_length1;
		guchar* o;
		_tmp0 = NULL;
		o = (_tmp0 = g_new0 (guchar, 1), o_length1 = 1, o_size = o_length1, _tmp0);
		o[0] = data;
		{
			g_output_stream_write ((GOutputStream*) self->priv->fos, o, (gsize) 1, NULL, &inner_error);
			if (inner_error != NULL) {
				goto __catch8_g_error;
				goto __finally8;
			}
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				fprintf (stdout, _ ("error: %s\n"), e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally8:
		if (inner_error != NULL) {
			o = (g_free (o), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		o = (g_free (o), NULL);
	}
}


/* What should be done here?*/
void moserial_serial_stream_recorder_writeOutgoing (moserialSerialStreamRecorder* self, guchar data) {
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	_tmp0 = FALSE;
	if (self->priv->isOpen) {
		gboolean _tmp1;
		_tmp1 = FALSE;
		if (self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH;
		}
		_tmp0 = _tmp1;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		moserial_serial_stream_recorder_write (self, data);
	}
}


void moserial_serial_stream_recorder_writeIncoming (moserialSerialStreamRecorder* self, guchar data) {
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	_tmp0 = FALSE;
	if (self->priv->isOpen) {
		gboolean _tmp1;
		_tmp1 = FALSE;
		if (self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = self->priv->direction == MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH;
		}
		_tmp0 = _tmp1;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		moserial_serial_stream_recorder_write (self, data);
	}
}


void moserial_serial_stream_recorder_close (moserialSerialStreamRecorder* self, gboolean launch) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	if (self->priv->isOpen) {
		gboolean _tmp0;
		GFileOutputStream* _tmp1;
		GFile* _tmp2;
		{
			g_output_stream_flush ((GOutputStream*) self->priv->fos, NULL, &inner_error);
			if (inner_error != NULL) {
				goto __catch9_g_error;
				goto __finally9;
			}
			g_output_stream_close ((GOutputStream*) self->priv->fos, NULL, &inner_error);
			if (inner_error != NULL) {
				goto __catch9_g_error;
				goto __finally9;
			}
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				fprintf (stdout, _ ("error: %s\n"), e->message);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally9:
		if (inner_error != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
		_tmp0 = FALSE;
		if (launch) {
			_tmp0 = mo_utils_fileSize (self->priv->uri) > 0;
		} else {
			_tmp0 = FALSE;
		}
		/* Error closing the file?
		 TODO: allow this feature to be enabled / disabled */
		if (_tmp0) {
			{
				gtk_show_uri (NULL, self->priv->uri, (guint32) GDK_CURRENT_TIME, &inner_error);
				if (inner_error != NULL) {
					goto __catch10_g_error;
					goto __finally10;
				}
			}
			goto __finally10;
			__catch10_g_error:
			{
				GError * e;
				e = inner_error;
				inner_error = NULL;
				{
					g_warning (_ ("Unable to launch %s: %s"), self->priv->uri, e->message);
					(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				}
			}
			__finally10:
			if (inner_error != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
				g_clear_error (&inner_error);
				return;
			}
		}
		_tmp1 = NULL;
		self->priv->fos = (_tmp1 = NULL, (self->priv->fos == NULL) ? NULL : (self->priv->fos = (g_object_unref (self->priv->fos), NULL)), _tmp1);
		_tmp2 = NULL;
		self->priv->file = (_tmp2 = NULL, (self->priv->file == NULL) ? NULL : (self->priv->file = (g_object_unref (self->priv->file), NULL)), _tmp2);
		self->priv->isOpen = FALSE;
	}
}


moserialSerialStreamRecorder* moserial_serial_stream_recorder_construct (GType object_type) {
	moserialSerialStreamRecorder* self;
	self = (moserialSerialStreamRecorder*) g_type_create_instance (object_type);
	return self;
}


moserialSerialStreamRecorder* moserial_serial_stream_recorder_new (void) {
	return moserial_serial_stream_recorder_construct (MOSERIAL_TYPE_SERIAL_STREAM_RECORDER);
}


static void moserial_value_serial_stream_recorder_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void moserial_value_serial_stream_recorder_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		moserial_serial_stream_recorder_unref (value->data[0].v_pointer);
	}
}


static void moserial_value_serial_stream_recorder_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = moserial_serial_stream_recorder_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer moserial_value_serial_stream_recorder_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* moserial_value_serial_stream_recorder_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		moserialSerialStreamRecorder* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = moserial_serial_stream_recorder_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* moserial_value_serial_stream_recorder_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	moserialSerialStreamRecorder** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = moserial_serial_stream_recorder_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* moserial_param_spec_serial_stream_recorder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	moserialParamSpecSerialStreamRecorder* spec;
	g_return_val_if_fail (g_type_is_a (object_type, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer moserial_value_get_serial_stream_recorder (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER), NULL);
	return value->data[0].v_pointer;
}


void moserial_value_set_serial_stream_recorder (GValue* value, gpointer v_object) {
	moserialSerialStreamRecorder* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, MOSERIAL_TYPE_SERIAL_STREAM_RECORDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		moserial_serial_stream_recorder_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		moserial_serial_stream_recorder_unref (old);
	}
}


static void moserial_serial_stream_recorder_class_init (moserialSerialStreamRecorderClass * klass) {
	moserial_serial_stream_recorder_parent_class = g_type_class_peek_parent (klass);
	MOSERIAL_SERIAL_STREAM_RECORDER_CLASS (klass)->finalize = moserial_serial_stream_recorder_finalize;
	g_type_class_add_private (klass, sizeof (moserialSerialStreamRecorderPrivate));
}


static void moserial_serial_stream_recorder_instance_init (moserialSerialStreamRecorder * self) {
	self->priv = MOSERIAL_SERIAL_STREAM_RECORDER_GET_PRIVATE (self);
	self->priv->isOpen = FALSE;
	self->ref_count = 1;
}


static void moserial_serial_stream_recorder_finalize (moserialSerialStreamRecorder* obj) {
	moserialSerialStreamRecorder * self;
	self = MOSERIAL_SERIAL_STREAM_RECORDER (obj);
	(self->priv->file == NULL) ? NULL : (self->priv->file = (g_object_unref (self->priv->file), NULL));
	self->priv->uri = (g_free (self->priv->uri), NULL);
	(self->priv->fos == NULL) ? NULL : (self->priv->fos = (g_object_unref (self->priv->fos), NULL));
}


GType moserial_serial_stream_recorder_get_type (void) {
	static GType moserial_serial_stream_recorder_type_id = 0;
	if (moserial_serial_stream_recorder_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { moserial_value_serial_stream_recorder_init, moserial_value_serial_stream_recorder_free_value, moserial_value_serial_stream_recorder_copy_value, moserial_value_serial_stream_recorder_peek_pointer, "p", moserial_value_serial_stream_recorder_collect_value, "p", moserial_value_serial_stream_recorder_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (moserialSerialStreamRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_serial_stream_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSerialStreamRecorder), 0, (GInstanceInitFunc) moserial_serial_stream_recorder_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		moserial_serial_stream_recorder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "moserialSerialStreamRecorder", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return moserial_serial_stream_recorder_type_id;
}


gpointer moserial_serial_stream_recorder_ref (gpointer instance) {
	moserialSerialStreamRecorder* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void moserial_serial_stream_recorder_unref (gpointer instance) {
	moserialSerialStreamRecorder* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MOSERIAL_SERIAL_STREAM_RECORDER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




