/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.gdk.EventKey;

/**
 * Interface that can be used to intercept all key events before they are
 * delivered normally. It can be used to implement custom key event handling.
 * 
 * @see org.gnu.gtk.Gtk#setKeySnoopMethod
 */
public interface KeySnoopMethod {

    /**
     * Method invoked when a key event occurs. This method is called before
     * normal event delivery and can be used to implement custom key event
     * handling.
     * 
     * @param widget
     *            The widget to which the event will be delivered.
     * @param event
     *            The key event.
     * @return TRUE to stop further processing of event, FALSE to continue.
     */
    public boolean keyEvent(Widget widget, EventKey event);

}
