/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.javagnome.Handle;

/**
 * The HSeparator widget is a horizontal separator, used to group the widgets 
 * within a window. It displays a horizontal line with a shadow to make it 
 * appear sunken into the interface.
 * <p>
 * Note: The HSeparator widget is not used as a separator within menus. To 
 * create a separator in a menu create a {@link SeparatorMenuItem} widget and 
 * add it to the menu.
 */
public class HSeparator extends Separator 
{
	/**
	 * Creates a new HSeparator widget.
	 */
	public HSeparator(){
		super(gtk_hseparator_new ());
	}
	
	/**
	 * Construct a HSeparator from a handle to a native resource.
	 */
	public HSeparator(Handle handle) {
	    super(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_hseparator_get_type());
	}


    native static final protected int gtk_hseparator_get_type ();
    native static final protected Handle gtk_hseparator_new ();

}

