/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.javagnome.Handle;

/**
 * The AccelLabel widget is a subclass of Label that also displays an accelerator
 * key on the right side of the label text, e.g. 'Ctrl+S'.  It is commonly used 
 * in menus to show the keyboard shortcut for the command.
 * <p>
 * The accelerator key to display is not set explicitly.  Instead, the AccelLabel
 * displays the accelerator which have been added to a particular widget.  This
 * widget is set by calling setAccelWidget().
 */
public class AccelLabel extends Label 
{
	/**
	 * Create an AccelLabel.
	 */
	public AccelLabel(String str) {
		super(gtk_accel_label_new(str));
	}
	
	/**
	 * Construct a AccelLabel using a handle to a native resource.
	 */
	public AccelLabel(Handle handle) {
	    super(handle);
	}

	/**
	 * Set the widget for this AccelLabel
	 */
	public void setAccelWidget(Widget accelWidget) {
		gtk_accel_label_set_accel_widget(getHandle(), accelWidget.getHandle());
	}
	
	/**
	 * Retrieve the widget for this AccelLabel
	 */
	public Widget getAccelWidget() {
	    Handle hndl = gtk_accel_label_get_accel_widget(getHandle());
		return Widget.getWidget(hndl);
	}
	
	/**
	 * Returns the width needed to display the accelerator key(s).   This is
	 * used by menus to align all of the MenuItem widgets and shouldn't be
	 * needed by applications.
	 * 
	 * @return The width needed to display the accelerator keys.
	 */
	public int getAccelWidth() {
		return gtk_accel_label_get_accel_width(getHandle());
	}
	

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_accel_label_get_type());
	}
	
	/****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_accel_label_get_type ();
    native static final protected Handle gtk_accel_label_new (String str);
    native static final protected Handle gtk_accel_label_get_accel_widget (Handle accel_label);
    native static final protected void gtk_accel_label_set_accel_widget (Handle accel_label, Handle accelWidget);
    native static final protected int gtk_accel_label_get_accel_width (Handle accel_label);
    native static final protected boolean gtk_accel_label_refetch (Handle accel_label);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

