/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.javagnome.Handle;

/**
 *
 */
public class EventButton extends Event
{
    /**
     * Promotion constructor. Construct the specific event object by
     * promoting (sharing the <tt>Handle</tt> object of) the base
     * <tt>Event</tt>.
     */
    public EventButton( Event evt ) {
        // We share the handle with both instances.  This avoids
        // copying the event (via the constructor ( super( evt ) ).
        // It is more of a "promotion" constructor.
        super( evt.getHandle() );
    }

    public EventButton(Handle handle) {
        super(handle);
    }
	
    public int getButton() {
        return EventButton.getButton(getHandle());
    }
	
    public double getX() {
        return EventButton.getX(getHandle());
    }
	
    public double getY() {
        return EventButton.getY(getHandle());
    }
	
    public int getType() {
        return Event.getType(getHandle());
    }
	
    public Window getWindow() {
        return Window.getWindowFromHandle(getWindow(getHandle()));
    }

    public Device getDevice() {
        return Device.getDeviceFromHandle(getDevice(getHandle()));
    }

    native static final protected Handle getWindow (Handle obj);
    native static final protected boolean getSendEvent (Handle obj);
    native static final protected int getTime (Handle obj);
    native static final protected double getX (Handle obj);
    native static final protected double getY (Handle obj);
    native static final protected int getState (Handle obj);
    native static final protected int getButton (Handle obj);
    native static final protected Handle getDevice (Handle obj);
    native static final protected double getXRoot (Handle obj);
    native static final protected double getYRoot (Handle obj);
}

