/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

 /*
  * TODO:
  * - Documentation.
  * - Complete the methods.
  */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

/**
 *
 */
 
public class Region extends Boxed 
{
	
	public Region(Handle handle){
		super(handle);
	}
	
	public Region(){
		super(gdk_region_new());
	}	
	
	public Region getPolygon(Point points[], FillRule rule){
	    Handle pointsh[]=new Handle[points.length];
		for(int i=0;i<points.length;i++)
			pointsh[i]=points[i].getHandle();
		return new Region(gdk_region_polygon(pointsh, rule.getValue()));
	}
	
    native static final protected Handle gdk_region_new ();
    native static final protected Handle gdk_region_polygon (Handle [] points, int fillRule);
    native static final protected Handle gdk_region_rectangle (Handle rectangle);
    native static final protected void gdk_region_destroy (Handle region);
    native static final protected void gdk_region_get_clipbox (Handle region, Handle rectangle);
    native static final protected void gdk_region_get_rectangles (Handle region, Handle [] rectangles);
    native static final protected boolean gdk_region_empty (Handle region);
    native static final protected boolean gdk_region_equal (Handle region1, Handle region2);
    native static final protected boolean gdk_region_point_in (Handle region, int x, int y);
    native static final protected int gdk_region_rect_in (Handle region, Handle rect);
    native static final protected void gdk_region_offset (Handle retion, int dx, int dy);
    native static final protected void gdk_region_shrink (Handle region, int dx, int dy);
    native static final protected void gdk_region_union_with_rect (Handle region, Handle rect);
    native static final protected void gdk_region_intersect (Handle source1, Handle source2);
    native static final protected void gdk_region_union (Handle source1, Handle source2);
    native static final protected void gdk_region_subtract (Handle source1, Handle source2);
    native static final protected void gdk_region_xor (Handle source1, Handle source2);
}

