/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gtk/gtk.h>
#include "jg_jnu.h"

#ifndef _Included_org_gnu_gtk_BindingSet
#define _Included_org_gnu_gtk_BindingSet
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_binding_set_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_BindingSet_gtk_1binding_1set_1new
  (JNIEnv *env , jclass cls, jstring name)
{
	const gchar* setName = (*env)->GetStringUTFChars(env, name, NULL);
	jobject retval = getHandleFromPointer(env, gtk_binding_set_new(setName));
	(*env)->ReleaseStringUTFChars(env, name, setName);
	return retval;
}

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_binding_set_find
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gtk_BindingSet_gtk_1binding_1set_1find
  (JNIEnv *env, jclass cls, jstring name)
{
	const gchar* setName = (*env)->GetStringUTFChars(env, name, NULL);
	jobject retval = getHandleFromPointer(env, gtk_binding_set_find(setName));
	(*env)->ReleaseStringUTFChars(env, name, setName);
	return retval;
}

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_bindings_activate
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_BindingSet_gtk_1bindings_1activate
  (JNIEnv *env, jclass cls, jobject object, jint keyval, jint modifier)
{
	GtkObject* obj = getPointerFromHandle(env, object);
	return (jboolean)gtk_bindings_activate(obj, (guint)keyval, (GdkModifierType)modifier);
}

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_binding_set_activate
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_BindingSet_gtk_1binding_1set_1activate
  (JNIEnv *env, jclass cls, jobject binding, jint keyval, jint modifier, jobject object)
{
	GtkBindingSet* bs = getPointerFromHandle(env, binding);
	GtkObject* obj = getPointerFromHandle(env, object);
	return (jboolean)gtk_binding_set_activate(bs, (guint)keyval, (GdkModifierType)modifier, obj);
}

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_binding_entry_clear
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_BindingSet_gtk_1binding_1entry_1clear
  (JNIEnv *env, jclass cls, jobject binding, jint keyval, jint modifier)
{
	GtkBindingSet* bs = getPointerFromHandle(env, binding);
	gtk_binding_entry_clear(bs, (guint)keyval, (GdkModifierType)modifier);
}

/*
 * Class:     org_gnu_gtk_BindingSet
 * Method:    gtk_binding_set_add_path
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_BindingSet_gtk_1binding_1set_1add_1path
  (JNIEnv *env, jclass cls, jobject binding, jint pathType, jstring pathPattern, jint priority)
{
	GtkBindingSet* bs = getPointerFromHandle(env, binding);
	const gchar* pattern = (*env)->GetStringUTFChars(env, pathPattern, NULL);
	gtk_binding_set_add_path(bs, (GtkPathType)pathType, pattern, (GtkPathPriorityType)priority);
}

#ifdef __cplusplus
}
#endif
#endif
