/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

 /*
  * TODO:
  * Documentation.
  * add functionallity like in awt?
  */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

public class Point extends Boxed 
{
	public Point(int x, int y) {
		handle = gdk_point_new();
		setX(x);
		setY(y);
	}
	
	public Point(Handle handle){
		this.handle=handle;
	}
	
	public int getX(){
		return Point.getX(handle);
	}
	
	public void setX(int x){
		setX(handle,x);
	}
	
	public int getY(){
		return Point.getY(handle);
	}
	
	public void setY(int y){
		setY(handle,y);
	}
	
	protected void finalize() throws Throwable {
		gdk_point_free(handle);
	}
	
	
	
    /****************************************
     * BEGINNING OF JNI CODE
     ****************************************/
    native static final protected int getX (Handle obj);
    native final protected void setX (Handle obj, int x);
    native static final protected int getY (Handle obj);
    native final protected void setY (Handle obj, int y);
	native static final protected Handle gdk_point_new();
	native static final protected void gdk_point_free(Handle handle);
    /****************************************
     * END OF JNI CODE
     ****************************************/
}

