/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * This widget is the base class for GtkHRuler and GtkVRuler. It
 * contains the configuration and calculation capability, but has no
 * ability to display the results.
 */
public class Ruler extends Widget 
{
	protected Ruler() {}
	
	/**
	 * Construct a Ruler from a handle to a native resource.
	 */
	protected Ruler(int handle) {
	    setHandle(handle);
	}
	
	protected void noopInit() {}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_ruler_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getXsrc (int cptr);
    native static final protected int getYsrc (int cptr);
    native static final protected int getSliderSize (int cptr);
    native static final protected double getLower (int cptr);
    native static final protected double getUpper (int cptr);
    native static final protected double getPosition (int cptr);
    native static final protected double getMaxSize (int cptr);
    native static final protected int gtk_ruler_get_type ();
    native static final protected void gtk_ruler_set_metric (int ruler, int metric);
    native static final protected void gtk_ruler_set_range (int ruler, double lower, double upper, 
        double position, double maxSize);
    native static final protected void gtk_ruler_draw_ticks (int ruler);
    native static final protected void gtk_ruler_draw_pos (int ruler);
    native static final protected int gtk_ruler_get_metric (int ruler);
    native static final protected void gtk_ruler_get_range (int ruler, double [] lower, double [] 
        upper, double [] position, double [] maxSize);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

