/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Type;
import org.gnu.gtk.event.MouseEvent;

/**
 * Old class replaced by {@link UIManager}. This class is provided for
 * compatibility only - it will be removed in future releases of java-gnome. Do
 * not use in new code.
 * 
 * @deprecated 2.3
 */
public class ItemFactory extends GtkObject {


	/**
	 * Create a new ItemFactory object.
	 * @param containerType The type of menu to create.  It can be
	 * a MenuBar, a Menu, or an OptionMenu.
	 * @param path The factory path of the new item factory, a string
	 * of the form "<name>".
	 * @param accelGroup A AccelGroup to which the accelerators to the
	 * menu items will be added, or null to create a new one.
	 */
	public ItemFactory(Type containerType, String path, AccelGroup accelGroup) {
		int accelHandle = 0;
		if (null != accelGroup)
			accelHandle = accelGroup.getHandle();
		setHandle(gtk_item_factory_new(containerType.getTypeHandle(), path, accelHandle));
	}
	
	/**
	 * Create a new ItemFactory from a handle to a native resource.
	 */
	protected ItemFactory(int handle) {
		this.setHandle(handle);
	}

	/**
	 * Obtain the item factory from which a widget was created.
	 * @param widget The widget to use for the search.
	 */
	public static ItemFactory fromWidget(Widget widget) {
		return new ItemFactory(gtk_item_factory_from_widget(widget.getHandle()));
	}
	
	 /**
	  * Create an item for <i>entry</i>.
	  * @param entry The IconFactoryEntry to create an item for.
	  */
	 public void createItem(ItemFactoryEntry entry) {
	 	// create the item
	 	gtk_item_factory_create_item(getHandle(), entry.getHandle(), 0, 0);
	 	// now add the listener to the item that was created.
	 	// REDTAG
	 }

	/**
	 * Create the items from the entries.
	 * @param entries An array of IconFactoryEntry objects that
	 * describe the menus to be created.
	 */
	public void createItems(ItemFactoryEntry [] entries) {
		int [] handles = new int[entries.length];
		// get the handles for all of the entries
		for (int i = 0; i < entries.length; i++) {
			handles[i] = entries[i].getHandle();
		}
		// create the items
		gtk_item_factory_create_items(getHandle(), handles.length, handles, 0);
		// Now add the listener to the item that was created.
		// REDTAG
	}
	
	/**
	 * Delete the menu item that was created for <i>path</i> by the item factory.
	 * @param path The path to the item to delete.
	 */
	public void deleteItem(String path) {
		gtk_item_factory_delete_item(getHandle(), path);
	}
	
	/**
	 * Delete the menu item that was created from <i>entry</i> by the item factory.
	 * @param entry The Entry to delete.
	 */
	public void deleteEntry(ItemFactoryEntry entry) {
		gtk_item_factory_delete_entry(getHandle(), entry.getHandle());
	}
	
	/**
	 * Delete the menu items which were created from the <i>entries</i> by the
	 * item factory.
	 * @param entries The entries to delete.
	 */
	public void deleteEntries(ItemFactoryEntry [] entries) {
		int [] handles = new int[entries.length];
		for (int i = 0; i < entries.length; i++)
			handles[i] = entries[i].getHandle();
		gtk_item_factory_delete_entries(getHandle(), handles.length, handles);
	}
	
	/**
	 * Obtain the menu item that corresponds to <i>path</i>.
	 * @param path The path to the menu item.
	 * @return The menu item for the given path or null if path doesn't exist.
	 */
	public Widget getItem(String path) {
		int hndl = gtk_item_factory_get_item(getHandle(), path);
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Widget)obj;
		return new Widget(hndl);
	}
	
	 /**
	  * Obtain the widget that corresponds to <i>path</i>.
	  * @param path The path to the widget
	  * @return The widget for the given path or null if path doesn't exist.
	  */
	 public Widget getWidget(String path) {
		int hndl = gtk_item_factory_get_widget(getHandle(), path);
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Widget)obj;
		return new Widget(hndl);
	 }
	 
	 /**
	  * Pops up the menu constructed with the item factory.
	  * @param x The x coordinate for the popup menu
	  * @param y The y coordinate for the popup menu
	  * @param mouseButton The mouse button which was pressed.  These values are
	  * defined in {@link MouseEvent}.
	  */
	 public void popup(int x, int y, int mouseButton) {
	 	if (mouseButton != MouseEvent.BUTTON1 
		 	&& mouseButton != MouseEvent.BUTTON2
		 	&& mouseButton != MouseEvent.BUTTON3)
		 	return;
		 gtk_item_factory_popup(getHandle(), x, y, mouseButton, 0);
	 }
	 
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_item_factory_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_item_factory_get_type();
	native static final protected int gtk_item_factory_new(int containerType, String path, int accelGroup);
	native static final protected void gtk_item_factory_construct(int ifactory, int containerType, String path, int accelGroup);
	native static final protected void gtk_item_factory_add_foreign(int accelWidget, String fullPath, int accelGroup, int keyval, int modifiers);
	native static final protected int gtk_item_factory_from_widget(int widget);
	native static final protected String gtk_item_factory_path_from_widget(int widget);
	native static final protected int gtk_item_factory_get_item(int ifactory, String path);
	native static final protected int gtk_item_factory_get_widget(int ifactory, String path);
	native static final protected int gtk_item_factory_get_widget_by_action(int ifactory, int action);
	native static final protected int gtk_item_factory_get_item_by_action(int ifactory, int action);
	native static final protected void gtk_item_factory_create_item(int ifactory, int entry, int callbackData, int callbackType);
	native static final protected void gtk_item_factory_create_items(int ifactory, int numEntries, int[] entries, int callbackData);
	native static final protected void gtk_item_factory_delete_item(int ifactory, String path);
	native static final protected void gtk_item_factory_delete_entry(int ifactory, int entry);
	native static final protected void gtk_item_factory_delete_entries(int ifactory, int numEnties, int[] entries);
	native static final protected void gtk_item_factory_popup(int ifactory, int x, int y, int mouseButton, int time);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
