/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.GObject;
/**
 * A DragContext holds information about a drag in process.  It is used
 * on both source and destination sides.
 */
public class DragContext extends GObject 
{
	/**
	 * Construct a DragContext.
	 */
	public DragContext() {
		setHandle(gdk_drag_context_new());
	}

	/**
	 * Construct a DragContext using native resources. Used internally by
	 * java-gnome
	 */
	public DragContext( int handle ){
		setHandle(handle);
	}
	
	/**
	 * Return the source window.
	 */
	public Window getSource() {
		int hndl = getSourceWindow(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Window)obj;
		return new Window(hndl);
	}
	
	/**
	 * Return the destination window.
	 */
	public Window getDestination() {
		int hndl = getDestWindow(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Window)obj;
		return new Window(hndl);
	}
	
	/**
	 * Return the Drag Protocol
	 */
	public DragProtocol getProtocol() {
		return DragProtocol.intern(getProtocol(getHandle()));
	}
	
	/**
	 * Returns true if the context is used on the source side.
	 */
	public boolean isSource() {
		return getIsSource(getHandle());
	}
	
	/**
	 * Return the action suggested by the source.
	 */
	public DragAction getSuggestedAction() {
		return DragAction.intern(getSuggestedAction(getHandle()));
	}
	
	/**
	 * Return the action chosen by the destination.
	 */
	public DragAction getAction() {
		return DragAction.intern(getAction(getHandle()));
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getProtocol (int obj);
    native static final protected boolean getIsSource (int obj);
    native static final protected int getSourceWindow (int obj);
    native static final protected int getDestWindow (int obj);
    native static final protected int getActions (int obj);
    native static final protected int getSuggestedAction (int obj);
    native static final protected int getAction (int obj);
    native static final protected int gdk_drag_context_get_type ();
    native static final protected int gdk_drag_context_new ();
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

