/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

/**
 */
public class ComboBoxEntry extends ComboBox {

	public ComboBoxEntry() {
		if (-1 == handle) {
			handle = gtk_combo_box_entry_new();
		}
	}
	
	public ComboBoxEntry(TreeModel model, int textColumn) {
		handle = gtk_combo_box_entry_new_with_model(model.getHandle(), textColumn);
	}
	
	public void setTextColumn(int textColumn) {
		gtk_combo_box_entry_set_text_column(handle, textColumn);
	}
	
	public int getTextColumn() {
		return gtk_combo_box_entry_get_text_column(handle);
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_combo_box_entry_get_type ();
	native static final protected int gtk_combo_box_entry_new();
	native static final protected int gtk_combo_box_entry_new_with_model(int model, int textColumn);
	native static final protected void gtk_combo_box_entry_set_text_column(int entry, int textColumn);
	native static final protected int gtk_combo_box_entry_get_text_column(int entry);
	native static final protected int gtk_combo_box_entry_new_text();
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
