/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_FileChooserHelper
#define _Included_org_gnu_gtk_FileChooserHelper
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_action
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1action
  (JNIEnv *env, jclass cls, jint chooser, jint action)
{
	gtk_file_chooser_set_action((GtkFileChooser*)chooser, (GtkFileChooserAction)action);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_action
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1action
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (jint)gtk_file_chooser_get_action((GtkFileChooser*)chooser);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_local_only
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1local_1only
  (JNIEnv *env, jclass cls, jint chooser, jboolean localOnly)
{
	gtk_file_chooser_set_local_only((GtkFileChooser*)chooser, (gboolean)localOnly);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_local_only
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1local_1only
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (jboolean)gtk_file_chooser_get_local_only((GtkFileChooser*)chooser);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_select_multiple
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1select_1multiple
  (JNIEnv *env, jclass cls, jint chooser, jboolean selectMultiple)
{
	gtk_file_chooser_set_select_multiple((GtkFileChooser*)chooser, (gboolean)selectMultiple);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_select_multiple
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1select_1multiple
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (jboolean)gtk_file_chooser_get_select_multiple((GtkFileChooser*)chooser);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_current_name
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1current_1name
  (JNIEnv *env, jclass cls, jint chooser, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_file_chooser_set_current_name((GtkFileChooser*)chooser, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_filename
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1filename
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (*env)->NewStringUTF(env, (char*)gtk_file_chooser_get_filename((GtkFileChooser*)chooser));
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_filename
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1filename
  (JNIEnv *env, jclass cls, jint chooser, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_file_chooser_set_filename((GtkFileChooser*)chooser, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_select_filename
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1select_1filename
  (JNIEnv *env, jclass cls, jint chooser, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_file_chooser_select_filename((GtkFileChooser*)chooser, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_unselect_filename
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1unselect_1filename
  (JNIEnv *env, jclass cls, jint chooser, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_file_chooser_unselect_filename((GtkFileChooser*)chooser, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_select_all
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1select_1all
  (JNIEnv *env, jclass cls, jint chooser)
{
	gtk_file_chooser_select_all((GtkFileChooser*)chooser);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_unselect_all
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1unselect_1all
  (JNIEnv *env, jclass cls, jint chooser)
{
	gtk_file_chooser_unselect_all((GtkFileChooser*)chooser);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_filenames
 * Signature: (I)[Ljava/lang/String;
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1filenames
  (JNIEnv *env, jclass cls, jint chooser)
{
	jobjectArray array;
	jclass strClass;
	jstring str;
	GSList* list;
	GSList* item;
	gchar* value;
	guint len;
	guint index;
	
	list = gtk_file_chooser_get_filenames((GtkFileChooser*)chooser);
	if (NULL == list)
		return NULL;
	len = g_slist_length(list);
	strClass = (*env)->FindClass(env, "java/lang/String");
	array = (*env)->NewObjectArray(env, len, strClass, NULL);
	for (index = 0; index < len; index++) {
		item = g_slist_nth(list, index);
		value = (gchar*)item->data;
		str = (*env)->NewStringUTF(env, value);
		(*env)->SetObjectArrayElement(env, array, index, str);
	}
	return array;
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_current_folder
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1current_1folder
  (JNIEnv *env, jclass cls, jint chooser, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_file_chooser_set_current_folder((GtkFileChooser*)chooser, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_current_folder
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1current_1folder
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (*env)->NewStringUTF(env, (char*)gtk_file_chooser_get_current_folder((GtkFileChooser*)chooser));
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_uri
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1uri
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (*env)->NewStringUTF(env, (char*)gtk_file_chooser_get_uri((GtkFileChooser*)chooser));
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_uri
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1uri
  (JNIEnv *env, jclass cls, jint chooser, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_file_chooser_set_uri((GtkFileChooser*)chooser, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_select_uri
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1select_1uri
  (JNIEnv *env, jclass cls, jint chooser, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_file_chooser_select_uri((GtkFileChooser*)chooser, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_unselect_uri
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1unselect_1uri
  (JNIEnv *env, jclass cls, jint chooser, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_file_chooser_unselect_uri((GtkFileChooser*)chooser, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_uris
 * Signature: (I)[Ljava/lang/String;
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1uris
  (JNIEnv *env, jclass cls, jint chooser)
{
	jobjectArray array;
	jclass strClass;
	jstring str;
	GSList* list;
	GSList* item;
	gchar* value;
	guint len;
	guint index;
	
	list = gtk_file_chooser_get_uris((GtkFileChooser*)chooser);
	if (NULL == list)
		return NULL;
	len = g_slist_length(list);
	strClass = (*env)->FindClass(env, "java/lang/String");
	array = (*env)->NewObjectArray(env, len, strClass, NULL);
	for (index = 0; index < len; index++) {
		item = g_slist_nth(list, index);
		value = (gchar*)item->data;
		str = (*env)->NewStringUTF(env, value);
		(*env)->SetObjectArrayElement(env, array, index, str);
	}
	return array;
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_current_folder_uri
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1current_1folder_1uri
  (JNIEnv *env, jclass cls, jint chooser, jstring name)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_file_chooser_set_current_folder_uri((GtkFileChooser*)chooser, n);
	(*env)->ReleaseStringUTFChars(env, name, n);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_current_folder_uri
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1current_1folder_1uri
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (*env)->NewStringUTF(env, (char*)gtk_file_chooser_get_current_folder_uri((GtkFileChooser*)chooser));
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_preview_widget
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1preview_1widget
  (JNIEnv *env, jclass cls, jint chooser, jint widget)
{
	gtk_file_chooser_set_preview_widget((GtkFileChooser*)chooser, (GtkWidget*)widget);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_preview_widget
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1preview_1widget
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (jint)gtk_file_chooser_get_preview_widget((GtkFileChooser*)chooser);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_preview_widget_active
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1preview_1widget_1active
  (JNIEnv *env, jclass cls, jint chooser, jboolean active)
{
	gtk_file_chooser_set_preview_widget_active((GtkFileChooser*)chooser, (gboolean)active);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_preview_widget_active
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1preview_1widget_1active
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (jboolean)gtk_file_chooser_get_preview_widget_active((GtkFileChooser*)chooser);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_preview_filename
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1preview_1filename
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (*env)->NewStringUTF(env, (char*)gtk_file_chooser_get_preview_filename((GtkFileChooser*)chooser));
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_preview_uri
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1preview_1uri
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (*env)->NewStringUTF(env, (char*)gtk_file_chooser_get_preview_uri((GtkFileChooser*)chooser));
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_extra_widget
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1extra_1widget
  (JNIEnv *env, jclass cls, jint chooser, jint widget)
{
	gtk_file_chooser_set_extra_widget((GtkFileChooser*)chooser, (GtkWidget*)widget);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_extra_widget
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1extra_1widget
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (jint)gtk_file_chooser_get_extra_widget((GtkFileChooser*)chooser);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_add_filter
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1add_1filter
  (JNIEnv *env, jclass cls, jint chooser, jint filter)
{
	gtk_file_chooser_add_filter((GtkFileChooser*)chooser, (GtkFileFilter*)filter);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_remove_filter
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1remove_1filter
  (JNIEnv *env, jclass cls, jint chooser, jint filter)
{
	gtk_file_chooser_remove_filter((GtkFileChooser*)chooser, (GtkFileFilter*)filter);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_list_filters
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1list_1filters
  (JNIEnv *env, jclass cls, jint chooser)
{
	GSList *list;
	GSList *item;
	guint len;
	jintArray array;
	int i;
	
	list = gtk_file_chooser_list_filters((GtkFileChooser*)chooser);
 	if (NULL == list)
		return NULL;
	len = g_slist_length(list);
	array = (*env)->NewIntArray(env, len);
	for (i = 0; i < len; i++) {
		item = g_slist_nth(list, i);
		(*env)->SetIntArrayRegion(env, array, i, 1, (jint*)item->data);
	}
	return array;
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_set_filter
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1set_1filter
  (JNIEnv *env, jclass cls, jint chooser, jint filter)
{
	gtk_file_chooser_set_filter((GtkFileChooser*)chooser, (GtkFileFilter*)filter);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_get_filter
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1get_1filter
  (JNIEnv *env, jclass cls, jint chooser)
{
	return (jint)gtk_file_chooser_get_filter((GtkFileChooser*)chooser);
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_add_shortcut_folder
 * Signature: (ILjava/lang/String;[I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1add_1shortcut_1folder
  (JNIEnv *env, jclass cls, jint chooser, jstring folder, jintArray error)
{
	gchar* str;
	GError* err;
	gboolean bool;
	
	str = (gchar*)(*env)->GetStringUTFChars(env, folder, NULL);
	 err = (GError*)(*env)->GetIntArrayElements(env, error, NULL);
	bool = gtk_file_chooser_add_shortcut_folder((GtkFileChooser*)chooser, str, &err);
	(*env)->ReleaseStringUTFChars(env, folder, str);
	(*env)->ReleaseIntArrayElements(env, error, (jint*)err, 0);
	return (jboolean)bool;
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_remove_shortcut_folder
 * Signature: (ILjava/lang/String;[I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1remove_1shortcut_1folder
  (JNIEnv *env, jclass cls, jint chooser, jstring folder, jintArray error)
{
	gchar* str;
	GError* err;
	gboolean bool;
	
	str = (gchar*)(*env)->GetStringUTFChars(env, folder, NULL);
	err = (GError*)(*env)->GetIntArrayElements(env, error, NULL);
	bool = gtk_file_chooser_remove_shortcut_folder((GtkFileChooser*)chooser, str, &err);
	(*env)->ReleaseStringUTFChars(env, folder, str);
	(*env)->ReleaseIntArrayElements(env, error, (jint*)err, 0);
	return (jboolean)bool;
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_list_shortcut_folders
 * Signature: (I)[Ljava/lang/String;
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1list_1shortcut_1folders
  (JNIEnv *env, jclass cls, jint chooser)
{
	jobjectArray array;
	jclass strClass;
	jstring str;
	GSList* list;
	GSList* item;
	gchar* value;
	guint len;
	guint index;
	
	list = gtk_file_chooser_list_shortcut_folders((GtkFileChooser*)chooser);
	if (NULL == list)
		return NULL;
	len = g_slist_length(list);
	strClass = (*env)->FindClass(env, "java/lang/String");
	array = (*env)->NewObjectArray(env, len, strClass, NULL);
	for (index = 0; index < len; index++) {
		item = g_slist_nth(list, index);
		value = (gchar*)item->data;
		str = (*env)->NewStringUTF(env, value);
		(*env)->SetObjectArrayElement(env, array, index, str);
	}
	return array;
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_add_shortcut_folder_uri
 * Signature: (ILjava/lang/String;[I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1add_1shortcut_1folder_1uri
  (JNIEnv *env, jclass cls, jint chooser, jstring folder, jintArray error)
{
	gchar* str;
	GError* err;
	gboolean bool;
	
	str = (gchar*)(*env)->GetStringUTFChars(env, folder, NULL);
	err = (GError*)(*env)->GetIntArrayElements(env, error, NULL);
	bool = gtk_file_chooser_add_shortcut_folder_uri((GtkFileChooser*)chooser, str, &err);
	(*env)->ReleaseStringUTFChars(env, folder, str);
	(*env)->ReleaseIntArrayElements(env, error, (jint*)err, 0);
	return (jboolean)bool;
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_remove_shortcut_folder_uri
 * Signature: (ILjava/lang/String;[I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1remove_1shortcut_1folder_1uri
  (JNIEnv *env, jclass cls, jint chooser, jstring folder, jintArray error)
{
	gchar* str;
	GError* err;
	gboolean bool;
	
	str = (gchar*)(*env)->GetStringUTFChars(env, folder, NULL);
	err = (GError*)(*env)->GetIntArrayElements(env, error, NULL);
	bool = gtk_file_chooser_remove_shortcut_folder_uri((GtkFileChooser*)chooser, str, &err);
	(*env)->ReleaseStringUTFChars(env, folder, str);
	(*env)->ReleaseIntArrayElements(env, error, (jint*)err, 0);
	return (jboolean)bool;
}

/*
 * Class:     org_gnu_gtk_FileChooserHelper
 * Method:    gtk_file_chooser_list_shortcut_folder_uris
 * Signature: (I)[Ljava/lang/String;
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_gtk_FileChooserHelper_gtk_1file_1chooser_1list_1shortcut_1folder_1uris
  (JNIEnv *env, jclass cls, jint chooser)
{
	jobjectArray array;
	jclass strClass;
	jstring str;
	GSList* list;
	GSList* item;
	gchar* value;
	guint len;
	guint index;
	
	list = gtk_file_chooser_list_shortcut_folder_uris((GtkFileChooser*)chooser);
	if (NULL == list)
		return NULL;
	len = g_slist_length(list);
	strClass = (*env)->FindClass(env, "java/lang/String");
	array = (*env)->NewObjectArray(env, len, strClass, NULL);
	for (index = 0; index < len; index++) {
		item = g_slist_nth(list, index);
		value = (gchar*)item->data;
		str = (*env)->NewStringUTF(env, value);
		(*env)->SetObjectArrayElement(env, array, index, str);
	}
	return array;
}

#ifdef __cplusplus
}
#endif
#endif
