/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 16:40:21 EDT
 */

/*
 * TODO:
 * Everything but the constructor.
 */
package org.gnu.gdk;
import org.gnu.glib.Boxed;
public class Color extends Boxed {

    private boolean handleAllocated = false; // true if created by this class.

	public static final Color RED = new Color(65535, 0, 0);
	public static final Color BLUE = new Color(0, 0, 65535);
	public static final Color GREEN = new Color(0, 65535, 0);
	public static final Color BLACK = new Color(0, 0, 0);
	public static final Color YELLOW = new Color(65535, 65535, 0);
	public static final Color WHITE = new Color(0, 0, 0);
	public static final Color ORANGE = new Color(65535, 51400, 0);

	/**
	 * Construct a Color object from a handle to a native resource.
	 */
	public Color(int handle) {
	    this.handle = handle;
	}

	/**
	*	Creates an sRGB color with the specified 
	*	red, green, and blue values in the range (0 - 65535).
	*/
	public Color(int red, int green, int blue) {
	    handle = allocHandle();
	    setRed(handle, red);
	    setBlue(handle, blue);
	    setGreen(handle, green);
	}

	/**
	*	Makes a copy of this color.
	*/
	public Object clone() {
		return new Color(Color.gdk_color_copy(handle));
	}

	protected synchronized void finalize() {
	    if (handle != 0) {
		if (handleAllocated)
		    // allocated during initialization
		    freeHandle(handle);
		else
		    // allocated by clone()
		    Color.gdk_color_free(handle);
	    }
	    handle = 0;
	}

	/**
	*	Determines whether another object is equal to this Color.
	*/
	public boolean equals(Object color) {
		if (color == null) {
			return false;
		}
		return Color.gdk_color_equal(handle, ((Color) color).handle);
	}

	public int hashCode() {
		return Color.gdk_color_hash(handle);
	}

	/**
	 *	Returns the red component in the range 0-65535 in the default sRGB space.
	 */
	public int getRed() {
		return Color.getRed(handle);
	}

	/**
	 * Sets the red component in the range of 0-65535.
	 */
	public void setRed(short value) {
		Color.setRed(handle, value);
	}

	/**
	 *	Returns the green component in the range 0-65535 in the default sRGB space.
	*/
	public int getGreen() {
		return Color.getGreen(handle);
	}

	/**
	 * Sets the green component in the range of 0-65535.
	 */
	public void setGreen(short value) {
		Color.setGreen(handle, value);
	}

   /**
	*	Returns the blue component in the range 0-65535 in the default sRGB space.
	*/
	public int getBlue() {
		return Color.getBlue(handle);
	}

	/**
	 * Sets the blue component in the range of 0-65535.
	 */
	public void setBlue(short value) {
		Color.setBlue(handle, value);
	}

	/**
	 * 
	 * Returns a string representation of this Color.
	 */
	public String toString() {
		return "Red: "
			+ getRed()
			+ "\n"
			+ "Green: "
			+ getGreen()
			+ "\n"
			+ "Blue: "
			+ getBlue()
			+ "\n";
	}

    private static native int allocHandle();
    private static native void freeHandle(int handle);

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int getPixel(int obj);
	native static final protected int getRed(int obj);
	native static final protected void setRed(int obj, int red);
	native static final protected int getGreen(int obj);
	native static final protected void setGreen(int obj, int green);
	native static final protected int getBlue(int obj);
	native static final protected void setBlue(int obj, int blue);
	native static final protected int gdk_color_get_type();
	native static final protected int gdk_color_copy(int color);
	native static final protected void gdk_color_free(int color);
	native static final protected int gdk_color_parse(String spec, int color);
	native static final protected int gdk_color_hash(int colora);
	native static final protected boolean gdk_color_equal(int colora, int colorb);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
