/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:32 EDT
 */

package org.gnu.gtk;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;
/**
 * This object manages a collection of {@link org.gnu.gtk.IconSet}; a
 * IconSet manages a set of variants of a particular icon.  Icons in an
 * IconFactory are named by a stock ID, which is a simple string identifying
 * the icon.
 */
public class IconFactory extends GObject 
{
	/**
	 * Construct a new IconFactory object.
	 */
	public IconFactory() {
		handle = gtk_icon_factory_new();
	}
	
	/**
	 * Add the given IconSet to this IconFactory.
	 * @param stockID The icon name
	 * @param iconSet The IconSet to add to this factory.
	 */
	public void addIconSet(String stockID, IconSet iconSet) {
		gtk_icon_factory_add(handle, stockID, iconSet.getHandle());
	}
	
	/**
	 * Looks up stockID from the icon factory, returning an icon set if found.
	 * @param stockID The stockID to use for the search
	 * @return The IconSet that matches the stockID or null if one is not 
	 * found.
	 */
	public IconSet lookupIconSet(String stockID) {
		int ret = gtk_icon_factory_lookup(handle, stockID);
		if (ret == 0)
			return null;
		return new IconSet(ret);
	}
	
	/**
	 * Adds this IconFactory to the list of icon factories searched by
	 * Style.lookupIconSet.  This means that objects that take stock IDs
	 * will be able to find the icons in this factory.  There will normally
	 * be an IconFactory added for each library or application that comes
	 * with icons.  The default icon factories can be overridden by themes.
	 */
	public void addDefault() {
		gtk_icon_factory_add_default(handle);
	}
	
	/**
	 * Removes this icon factory from the list of default icon factories.
	 */
	public void removeDefault() {
		gtk_icon_factory_remove_default(handle);
	}
	
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_icon_factory_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_icon_factory_get_type ();
    native static final protected int gtk_icon_factory_new ();
    native static final protected void gtk_icon_factory_add (int factory, String stockId, int 
        iconSet);
    native static final protected int gtk_icon_factory_lookup (int factory, String stockId);
    native static final protected void gtk_icon_factory_add_default (int factory);
    native static final protected void gtk_icon_factory_remove_default (int factory);
    native static final protected int gtk_icon_factory_lookup_default (String stockId);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

