/* GNOME-DB Configurator
 * Copyright (C) 2000 - 2005 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *      Vivien Malerba <malerba@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib/gi18n-lib.h>
#include <gtk/gtklabel.h>
#include <gtk/gtknotebook.h>
#include <libgda/gda-config.h>
#include <libgnomedb/gnome-db-util.h>
#include "database-capplet.h"
#include "dsn-config.h"
#include "provider-config.h"

/*
 * Public functions
 */

GtkWidget *
database_capplet_new (void)
{
	GtkWidget *capplet;
	GtkWidget *dsn;
	GtkWidget *provider;

	capplet = gnome_db_new_notebook_widget ();

	/* data source configuration page */
	dsn = dsn_config_new ();
	g_object_set_data (G_OBJECT (capplet), DSN_PAGE, dsn);
	gtk_notebook_append_page (GTK_NOTEBOOK (capplet), dsn,
				  gtk_label_new (_("Data Sources")));

	/* providers configuration page */
	provider = provider_config_new ();
	g_object_set_data (G_OBJECT (capplet), PROVIDER_PAGE, provider);
	gtk_notebook_append_page (GTK_NOTEBOOK (capplet), provider,
				  gtk_label_new (_("Providers")));

	return capplet;
}

void
database_capplet_delete (GtkWidget *capplet)
{
	GtkWidget *dsn, *provider, *current_widget;
	gint current;

	dsn = g_object_get_data (G_OBJECT (capplet), DSN_PAGE);
	provider = g_object_get_data (G_OBJECT (capplet), PROVIDER_PAGE);

	current = gtk_notebook_get_current_page (GTK_NOTEBOOK (capplet));
	if (current == -1)
		return;

	current_widget = gtk_notebook_get_nth_page (GTK_NOTEBOOK (capplet), current);
	if (current_widget == dsn)
		dsn_config_delete (dsn);
}

void
database_capplet_edit_properties (GtkWidget *capplet)
{
	GtkWidget *dsn, *provider, *current_widget;
	gint current;

	dsn = g_object_get_data (G_OBJECT (capplet), DSN_PAGE);
	provider = g_object_get_data (G_OBJECT (capplet), PROVIDER_PAGE);

	current = gtk_notebook_get_current_page (GTK_NOTEBOOK (capplet));
	if (current == -1)
		return;

	current_widget = gtk_notebook_get_nth_page (GTK_NOTEBOOK (capplet), current);
	if (current_widget == dsn)
		dsn_config_edit_properties (dsn);
}

void
database_capplet_select_all (GtkWidget *capplet)
{
	GtkWidget *dsn, *provider, *current_widget;
	gint current;

	dsn = g_object_get_data (G_OBJECT (capplet), DSN_PAGE);
	provider = g_object_get_data (G_OBJECT (capplet), PROVIDER_PAGE);

	current = gtk_notebook_get_current_page (GTK_NOTEBOOK (capplet));
	if (current == -1)
		return;

	current_widget = gtk_notebook_get_nth_page (GTK_NOTEBOOK (capplet), current);
	if (current_widget == dsn)
		dsn_config_select_all (dsn);
	else
		if (current_widget == provider)
			provider_config_select_all (provider);
}

void
database_capplet_deselect_all (GtkWidget *capplet)
{
	GtkWidget *dsn, *provider, *current_widget;
	gint current;

	dsn = g_object_get_data (G_OBJECT (capplet), DSN_PAGE);
	provider = g_object_get_data (G_OBJECT (capplet), PROVIDER_PAGE);

	current = gtk_notebook_get_current_page (GTK_NOTEBOOK (capplet));
	if (current == -1)
		return;

	current_widget = gtk_notebook_get_nth_page (GTK_NOTEBOOK (capplet), current);
	if (current_widget == dsn)
		dsn_config_unselect_all (dsn);
	else
		if (current_widget == provider)
			provider_config_unselect_all (provider);
}

gboolean
database_capplet_has_selection (GtkWidget *capplet)
{
	GtkWidget *dsn, *provider, *current_widget;
	gint current;

	dsn = g_object_get_data (G_OBJECT (capplet), DSN_PAGE);
	provider = g_object_get_data (G_OBJECT (capplet), PROVIDER_PAGE);

	current = gtk_notebook_get_current_page (GTK_NOTEBOOK (capplet));
	if (current == -1)
		return FALSE;

	current_widget = gtk_notebook_get_nth_page (GTK_NOTEBOOK (capplet), current);
	if (current_widget == dsn)
		return dsn_config_has_selection (dsn);
	else
		if (current_widget == provider)
			return provider_config_has_selection (provider);
	return FALSE;
}

void
database_capplet_switch (GtkWidget *capplet, const gchar *page)
{
	GtkWidget *notebook_page;
	gint num;
	
	notebook_page = g_object_get_data (G_OBJECT (capplet), page);
	g_return_if_fail (GTK_IS_WIDGET (notebook_page));
	
	num = gtk_notebook_page_num (GTK_NOTEBOOK (capplet), notebook_page);
	g_return_if_fail (num != -1);

	gtk_notebook_set_current_page (GTK_NOTEBOOK (capplet), num);
}
