/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:28:04 EDT
 */

package org.gnu.gnome;

import java.util.Vector;

import org.gnu.glib.EventMap;
import org.gnu.glib.Type;
import org.gnu.gnome.event.FontPickerEvent;
import org.gnu.gnome.event.FontPickerListener;
import org.gnu.gtk.Button;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.GtkEventType;
/**
 * The FontPicker widget is a button that, when selected, presents
 * a window that enables the user to select from among the many
 * available fonts.
 * 
 * @deprecated
 */
public class FontPicker extends Button {
	/**
	 * Listeners for handling FontPicker events
	 */
	private Vector fontPickerListeners = null;

	/**
	 * Creates a new font picker.
	 */
	public FontPicker() {
		noopInit();
	}

	/**
	 * Construct a FontPicker using a handle to a native resource.
	 */
	public FontPicker(int handle) {
		super(handle);
	}

	protected void noopInit() {
		if (-1 == handle) {
			handle = gnome_font_picker_new();
			initializeEventHandlers();
		}
	}

	/**
	 * Enables/Disables thre rendering of the font's name in its font.
	 * @param enable True if the font name should be rendered in its font.
	 *               False otherwise.
	 * @param size The font size to use when rendering the font names.
	 */
	public void enableFontPreview(boolean enable, int size) {
		gnome_font_picker_fi_set_use_font_in_label(handle, enable, size);
	}

	/**
	 * Enable/Disable the display of font sizes.
	 * @param showSize True if font sizes should be shown.  False otherwise.
	 */
	public void enableSize(boolean showSize) {
		gnome_font_picker_fi_set_show_size(handle, showSize);
	}

	/**
	 * Get the name of the selected font.
	 * @return The name of the selected font.
	 */
	public String getFontName() {
		return gnome_font_picker_get_font_name(handle);
	}

	/**
	 * Get the mode.
	 * @return The mode.
	 */
	public FontPickerMode getMode() {
		return FontPickerMode.intern(gnome_font_picker_get_mode(handle));

	}

	/**
	 * Get the text showen in the preview.
	 * @return The text in the preview.
	 */
	public String getPreviewText() {
		return gnome_font_picker_get_preview_text(handle);
	}

	/**
	 * Get the title of the dialog.
	 * @return The title.
	 */
	public String getTitle() {
		return gnome_font_picker_get_title(handle);
	}

	/**
	 * Get the user defined widget.  For use with USER_WIDGET mode.
	 * @return The widget.
	 * @see #getMode()
	 * @see #setMode(FontPickerMode)
	 */
	public Widget getUserWidget() {
		return new Widget(gnome_font_picker_uw_get_widget(handle));
	}

	/**
	 * Set the name of the font to be selected.  (Select the specified font)
	 * @param fontName The name of the font to select.
	 */
	public void setFontName(String fontName) {
		gnome_font_picker_set_font_name(handle, fontName);
	}

	/**
	 * Set the mode.
	 * @param mode The mode.
	 */
	public void setMode(FontPickerMode mode) {
		gnome_font_picker_set_mode(handle, mode.getValue());
	}

	/**
	 * Set the text to show in the preview.
	 * @param text The text to preview.
	 */
	public void setPreviewText(String text) {
		gnome_font_picker_set_preview_text(handle, text);
	}

	/**
	 * Set the title of the dialog.
	 * @param title The title.
	 */
	public void setTitle(String title) {
		gnome_font_picker_set_title(handle, title);
	}

	/**
	 * Set the user defined widget.  For use with USER_WIDGET mode.
	 * @param widget The widget.
	 * @see #getMode()
	 * @see #setMode(FontPickerMode)
	 */
	public void setUserWidget(Widget widget) {
		gnome_font_picker_uw_set_widget(handle, widget.getHandle());
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_font_picker_get_type());
	}

	//////////////////////////////////////////////////////
	// Event handling
	//////////////////////////////////////////////////////

	// TODO: events doen't seem to be propogated.
	/**
	 * Register an object to handle FontPicker events.
	 * @see org.gnu.gnome.event.FontPickerListener
	 */
	public void addListener(FontPickerListener listener) {
		// Don't add the listener a second time if it is in the Vector.
		int i = findListener(fontPickerListeners, listener);
		if (i == -1) {
			if (null == fontPickerListeners) {
				fontPickerListeners = new Vector();
			}
			fontPickerListeners.addElement(listener);
		}
	}
	/**
	 * Removes a listener
	 * @see #addListener(FontPickerListener)
	 */
	public void removeListener(FontPickerListener listener) {
		int i = findListener(fontPickerListeners, listener);
		if (i > -1) {
			fontPickerListeners.remove(i);
		}
		if (0 == fontPickerListeners.size()) {
			fontPickerListeners = null;
		}
	}

	protected void fireFontPickerEvent(FontPickerEvent event) {
		if (null == fontPickerListeners) {
			return;
		}
		int size = fontPickerListeners.size();
		int i = 0;
		while (i < size) {
			FontPickerListener fpl = (FontPickerListener)fontPickerListeners.elementAt(i);
			fpl.fontPickerEvent(event);
			i++;
		}
	}

	private void handleFontSet(String fontName) {
		fireFontPickerEvent(new FontPickerEvent(this));
	}

	protected void initializeEventHandlers() {
		super.initializeEventHandlers();
		evtMap.initialize(this);
	}

	public Class getEventListenerClass(String signal) {
		return evtMap.getListenerClass(signal);
	}

	public GtkEventType getEventType(String signal) {
		return evtMap.getEventType(signal);
	}

	private static EventMap evtMap = new EventMap();
	static {
		addEvents(evtMap);
	}

	/**
	* Implementation method to build an EventMap for this widget class.
	* Not useful (or supported) for application use.
	*/
	private static void addEvents(EventMap anEvtMap) {
		anEvtMap.addEvent("font_set", "handleFontSet", FontPickerEvent.Type.FONT_SET, FontPickerListener.class);
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_font_picker_get_type();
	native static final protected int gnome_font_picker_new();
	native static final protected void gnome_font_picker_set_title(int gfp, String title);
	native static final protected String gnome_font_picker_get_title(int gfp);
	native static final protected int gnome_font_picker_get_mode(int gfp);
	native static final protected void gnome_font_picker_set_mode(int gfp, int mode);
	native static final protected void gnome_font_picker_fi_set_use_font_in_label(
		int gfp,
		boolean use_font_in_label,
		int size);
	native static final protected void gnome_font_picker_fi_set_show_size(int gfp, boolean showSize);
	native static final protected void gnome_font_picker_uw_set_widget(int gfp, int widget);
	native static final protected int gnome_font_picker_uw_get_widget(int gfp);
	native static final protected String gnome_font_picker_get_font_name(int gfp);
	native static final protected boolean gnome_font_picker_set_font_name(int gfp, String fontname);
	native static final protected String gnome_font_picker_get_preview_text(int gfp);
	native static final protected void gnome_font_picker_set_preview_text(int gfp, String text);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
