#!/usr/bin/env python

import os
import gnome.vfs

class Shell:
    def __init__(self, cwd=None):
        if cwd:
            self.cwd = gnome.vfs.URI(cwd)
        else:
            self.cwd = gnome.vfs.URI(os.getcwd())
        if str(self.cwd)[-1] != '/':
            self.cwd = self.cwd.append_string('/')

    def run(self):
        while 1:
            try:
                line = raw_input('%s$ ' % self.cwd)
                words = line.split()
                command = getattr(self, words[0])
                args = words[1:]
                command(*args)
            except KeyboardInterrupt:
                break
            except EOFError:
                break
            except Exception, e:
                print "Error: %s:%s" % (e.__class__.__name__, str(e))

    def cd(self, dir):
        new_cwd = self.cwd.resolve_relative(dir)
        if str(new_cwd)[-1] != '/':
            new_cwd = new_cwd.append_string('/')
        if gnome.vfs.get_file_info(new_cwd).type != \
               gnome.vfs.FILE_TYPE_DIRECTORY:
            raise gnome.vfs.error('%s is not a directory' % dir)
        self.cwd = new_cwd

    def pwd(self):
        print str(self.cwd)

    def ls(self, dir=''):
        dir = self.cwd.resolve_relative(dir)

        dhandle = gnome.vfs.open_directory(dir)
        for file_info in dhandle:
            print file_info.name

    def less(self, file):
        file = self.cwd.resolve_relative(file)
        file_info = gnome.vfs.get_file_info(file)
        fp = gnome.vfs.open(file, gnome.vfs.OPEN_READ)
        less = os.popen('less -m -F -', 'w')
        buffer = fp.read(file_info.size)
        less.write(buffer)
        less.close()
    more = less
    cat = less

if __name__ == '__main__':
    shell = Shell()
    shell.run()
    print
