/* cue-sheet.c generated by valac 0.36.1.17-97a62, the Vala compiler
 * generated from cue-sheet.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_CUE_SHEET (games_cue_sheet_get_type ())
#define GAMES_CUE_SHEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_CUE_SHEET, GamesCueSheet))
#define GAMES_CUE_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_CUE_SHEET, GamesCueSheetClass))
#define GAMES_IS_CUE_SHEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_CUE_SHEET))
#define GAMES_IS_CUE_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_CUE_SHEET))
#define GAMES_CUE_SHEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_CUE_SHEET, GamesCueSheetClass))

typedef struct _GamesCueSheet GamesCueSheet;
typedef struct _GamesCueSheetClass GamesCueSheetClass;
typedef struct _GamesCueSheetPrivate GamesCueSheetPrivate;

#define GAMES_TYPE_CUE_SHEET_TRACK_NODE (games_cue_sheet_track_node_get_type ())
#define GAMES_CUE_SHEET_TRACK_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_CUE_SHEET_TRACK_NODE, GamesCueSheetTrackNode))
#define GAMES_CUE_SHEET_TRACK_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_CUE_SHEET_TRACK_NODE, GamesCueSheetTrackNodeClass))
#define GAMES_IS_CUE_SHEET_TRACK_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_CUE_SHEET_TRACK_NODE))
#define GAMES_IS_CUE_SHEET_TRACK_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_CUE_SHEET_TRACK_NODE))
#define GAMES_CUE_SHEET_TRACK_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_CUE_SHEET_TRACK_NODE, GamesCueSheetTrackNodeClass))

typedef struct _GamesCueSheetTrackNode GamesCueSheetTrackNode;
typedef struct _GamesCueSheetTrackNodeClass GamesCueSheetTrackNodeClass;
enum  {
	GAMES_CUE_SHEET_DUMMY_PROPERTY,
	GAMES_CUE_SHEET_FILE,
	GAMES_CUE_SHEET_TRACKS_NUMBER,
	GAMES_CUE_SHEET_LAST_PROPERTY
};
static GParamSpec* games_cue_sheet_properties[GAMES_CUE_SHEET_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define GAMES_TYPE_CUE_SHEET_FILE_NODE (games_cue_sheet_file_node_get_type ())
#define GAMES_CUE_SHEET_FILE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_CUE_SHEET_FILE_NODE, GamesCueSheetFileNode))
#define GAMES_CUE_SHEET_FILE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_CUE_SHEET_FILE_NODE, GamesCueSheetFileNodeClass))
#define GAMES_IS_CUE_SHEET_FILE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_CUE_SHEET_FILE_NODE))
#define GAMES_IS_CUE_SHEET_FILE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_CUE_SHEET_FILE_NODE))
#define GAMES_CUE_SHEET_FILE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_CUE_SHEET_FILE_NODE, GamesCueSheetFileNodeClass))

typedef struct _GamesCueSheetFileNode GamesCueSheetFileNode;
typedef struct _GamesCueSheetFileNodeClass GamesCueSheetFileNodeClass;

#define GAMES_TYPE_CUE_SHEET_FILE_FORMAT (games_cue_sheet_file_format_get_type ())

#define GAMES_TYPE_CUE_SHEET_TRACK_MODE (games_cue_sheet_track_mode_get_type ())

struct _GamesCueSheet {
	GObject parent_instance;
	GamesCueSheetPrivate * priv;
};

struct _GamesCueSheetClass {
	GObjectClass parent_class;
};

struct _GamesCueSheetPrivate {
	GFile* _file;
	GamesCueSheetTrackNode** tracks;
	gint tracks_length1;
	gint _tracks_size_;
};

typedef enum  {
	GAMES_CUE_SHEET_ERROR_UNEXPECTED_TOKEN,
	GAMES_CUE_SHEET_ERROR_UNEXPECTED_EOL,
	GAMES_CUE_SHEET_ERROR_UNEXPECTED_EOF,
	GAMES_CUE_SHEET_ERROR_INVALID_FILE_FORMAT,
	GAMES_CUE_SHEET_ERROR_INVALID_TRACK_NUMBER,
	GAMES_CUE_SHEET_ERROR_INVALID_TRACK_MODE,
	GAMES_CUE_SHEET_ERROR_NOT_A_TRACK
} GamesCueSheetError;
#define GAMES_CUE_SHEET_ERROR games_cue_sheet_error_quark ()
typedef enum  {
	GAMES_CUE_SHEET_FILE_FORMAT_INVALID,
	GAMES_CUE_SHEET_FILE_FORMAT_AIFF,
	GAMES_CUE_SHEET_FILE_FORMAT_BINARY,
	GAMES_CUE_SHEET_FILE_FORMAT_MOTOROLA,
	GAMES_CUE_SHEET_FILE_FORMAT_MP3,
	GAMES_CUE_SHEET_FILE_FORMAT_VORBIS,
	GAMES_CUE_SHEET_FILE_FORMAT_WAVE,
	GAMES_CUE_SHEET_FILE_FORMAT_UNKNOWN
} GamesCueSheetFileFormat;

typedef enum  {
	GAMES_CUE_SHEET_TRACK_MODE_INVALID,
	GAMES_CUE_SHEET_TRACK_MODE_AUDIO,
	GAMES_CUE_SHEET_TRACK_MODE_CDG,
	GAMES_CUE_SHEET_TRACK_MODE_MODE1_2048,
	GAMES_CUE_SHEET_TRACK_MODE_MODE1_2352,
	GAMES_CUE_SHEET_TRACK_MODE_MODE2_2336,
	GAMES_CUE_SHEET_TRACK_MODE_MODE2_2352,
	GAMES_CUE_SHEET_TRACK_MODE_CDI_2336,
	GAMES_CUE_SHEET_TRACK_MODE_CDI_2352
} GamesCueSheetTrackMode;


static gpointer games_cue_sheet_parent_class = NULL;
static GRegex* games_cue_sheet_token_regex;
static GRegex* games_cue_sheet_token_regex = NULL;

GType games_cue_sheet_get_type (void) G_GNUC_CONST;
GType games_cue_sheet_track_node_get_type (void) G_GNUC_CONST;
#define GAMES_CUE_SHEET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_CUE_SHEET, GamesCueSheetPrivate))
#define GAMES_CUE_SHEET_NEW_LINE "\n"
GamesCueSheet* games_cue_sheet_new (GFile* file, GError** error);
GamesCueSheet* games_cue_sheet_construct (GType object_type, GFile* file, GError** error);
static void games_cue_sheet_parse (GamesCueSheet* self, GError** error);
GamesCueSheetTrackNode* games_cue_sheet_get_track (GamesCueSheet* self, guint i, GError** error);
GFile* games_cue_sheet_get_file (GamesCueSheet* self);
GQuark games_cue_sheet_error_quark (void);
static gchar** games_cue_sheet_tokenize (GamesCueSheet* self, int* result_length1, GError** error);
static gchar** games_cue_sheet_tokenize_line (const gchar* line, int* result_length1);
static void _vala_array_add16 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add17 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add18 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add19 (gchar** * array, int* length, int* size, gchar* value);
GType games_cue_sheet_file_node_get_type (void) G_GNUC_CONST;
static GamesCueSheetFileNode* games_cue_sheet_parse_file_line (GamesCueSheet* self, gchar*** tokens, int* tokens_length1, gsize* i, gsize line, GError** error);
static GamesCueSheetTrackNode* games_cue_sheet_parse_track_line (GamesCueSheet* self, gchar*** tokens, int* tokens_length1, gsize* i, gsize line, GamesCueSheetFileNode* parent_file, GError** error);
static void _vala_array_add20 (GamesCueSheetTrackNode** * array, int* length, int* size, GamesCueSheetTrackNode* value);
static void games_cue_sheet_is_token (GamesCueSheet* self, const gchar* expected_token, gchar*** tokens, int* tokens_length1, gsize* i, gsize line, GError** error);
static gchar* games_cue_sheet_get_token (GamesCueSheet* self, gchar*** tokens, int* tokens_length1, gsize* i, gsize line, GError** error);
static gchar* games_cue_sheet_get_optional_token (GamesCueSheet* self, gchar*** tokens, int* tokens_length1, gsize* i, gsize line);
static void games_cue_sheet_is_end_of_line (GamesCueSheet* self, gchar*** tokens, int* tokens_length1, gsize* i, gsize line, GError** error);
GType games_cue_sheet_file_format_get_type (void) G_GNUC_CONST;
GamesCueSheetFileFormat games_cue_sheet_file_format_parse_string (const gchar* value);
GamesCueSheetFileNode* games_cue_sheet_file_node_new (GFile* file, GamesCueSheetFileFormat file_format);
GamesCueSheetFileNode* games_cue_sheet_file_node_construct (GType object_type, GFile* file, GamesCueSheetFileFormat file_format);
GType games_cue_sheet_track_mode_get_type (void) G_GNUC_CONST;
GamesCueSheetTrackMode games_cue_sheet_track_mode_parse_string (const gchar* value);
GamesCueSheetTrackNode* games_cue_sheet_track_node_new (GamesCueSheetFileNode* file, gint track_number, GamesCueSheetTrackMode track_mode);
GamesCueSheetTrackNode* games_cue_sheet_track_node_construct (GType object_type, GamesCueSheetFileNode* file, gint track_number, GamesCueSheetTrackMode track_mode);
guint games_cue_sheet_get_tracks_number (GamesCueSheet* self);
static void games_cue_sheet_finalize (GObject * obj);
static void _vala_games_cue_sheet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesCueSheet* games_cue_sheet_construct (GType object_type, GFile* file, GError** error) {
	GamesCueSheet * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesCueSheet*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp1_;
	games_cue_sheet_parse (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


GamesCueSheet* games_cue_sheet_new (GFile* file, GError** error) {
	return games_cue_sheet_construct (GAMES_TYPE_CUE_SHEET, file, error);
}


GamesCueSheetTrackNode* games_cue_sheet_get_track (GamesCueSheet* self, guint i, GError** error) {
	GamesCueSheetTrackNode* result = NULL;
	guint _tmp0_;
	GamesCueSheetTrackNode** _tmp1_;
	gint _tmp1__length1;
	GamesCueSheetTrackNode** _tmp9_;
	gint _tmp9__length1;
	guint _tmp10_;
	GamesCueSheetTrackNode* _tmp11_;
	GamesCueSheetTrackNode* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = i;
	_tmp1_ = self->priv->tracks;
	_tmp1__length1 = self->priv->tracks_length1;
	if (_tmp0_ >= ((guint) _tmp1__length1)) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		guint _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp2_ = games_cue_sheet_get_file (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = i;
		_tmp7_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_NOT_A_TRACK, _ ("“%s” doesn’t have a track for index %u."), _tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp9_ = self->priv->tracks;
	_tmp9__length1 = self->priv->tracks_length1;
	_tmp10_ = i;
	_tmp11_ = _tmp9_[_tmp10_];
	_tmp12_ = _g_object_ref0 (_tmp11_);
	result = _tmp12_;
	return result;
}


static void _vala_array_add16 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** games_cue_sheet_tokenize (GamesCueSheet* self, int* result_length1, GError** error) {
	gchar** result = NULL;
	GFileInputStream* stream;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* data_stream;
	GFileInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gchar** tokens;
	gchar** _tmp5_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar* line = NULL;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_cue_sheet_get_file (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error_);
	stream = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = stream;
	_tmp4_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
	data_stream = _tmp4_;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	tokens = _tmp5_;
	tokens_length1 = 0;
	_tokens_size_ = tokens_length1;
	while (TRUE) {
		gchar* _tmp6_;
		GDataInputStream* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gchar** _tmp13_;
		_tmp7_ = data_stream;
		_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data_stream);
			_g_object_unref0 (stream);
			return NULL;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_free0 (line);
		line = _tmp9_;
		_tmp10_ = line;
		if (!(_tmp10_ != NULL)) {
			_g_free0 (_tmp6_);
			break;
		}
		_tmp11_ = line;
		_tmp13_ = games_cue_sheet_tokenize_line (_tmp11_, &_tmp12_);
		{
			gchar** token_collection = NULL;
			gint token_collection_length1 = 0;
			gint _token_collection_size_ = 0;
			gint token_it = 0;
			token_collection = _tmp13_;
			token_collection_length1 = _tmp12_;
			for (token_it = 0; token_it < _tmp12_; token_it = token_it + 1) {
				gchar* _tmp14_;
				gchar* token = NULL;
				_tmp14_ = g_strdup (token_collection[token_it]);
				token = _tmp14_;
				{
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp15_ = tokens;
					_tmp15__length1 = tokens_length1;
					_tmp16_ = token;
					_tmp17_ = g_strdup (_tmp16_);
					_vala_array_add16 (&tokens, &tokens_length1, &_tokens_size_, _tmp17_);
					_g_free0 (token);
				}
			}
			token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (_tmp6_);
	}
	_tmp18_ = tokens;
	_tmp18__length1 = tokens_length1;
	if (result_length1) {
		*result_length1 = _tmp18__length1;
	}
	result = _tmp18_;
	_g_free0 (line);
	_g_object_unref0 (data_stream);
	_g_object_unref0 (stream);
	return result;
}


static inline GRegex* _thread_safe_regex_init (GRegex** re, const gchar * pattern, GRegexMatchFlags match_options) {
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, match_options, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


static void _vala_array_add17 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add18 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add19 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** games_cue_sheet_tokenize_line (const gchar* line, int* result_length1) {
	gchar** result = NULL;
	GRegex* _tmp0_;
	gchar** tokens;
	gchar** _tmp2_;
	gint tokens_length1;
	gint _tokens_size_;
	GRegex* _tmp3_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gboolean _tmp17_ = FALSE;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp24_;
	gint _tmp24__length1;
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = games_cue_sheet_token_regex;
	if (_tmp0_ == NULL) {
		GRegex* _tmp1_;
		_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "\\s*([^\"\\s]+)|(\".+?\")\\s*", 0));
		_g_regex_unref0 (games_cue_sheet_token_regex);
		games_cue_sheet_token_regex = _tmp1_;
	}
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	tokens = _tmp2_;
	tokens_length1 = 0;
	_tokens_size_ = tokens_length1;
	_tmp3_ = games_cue_sheet_token_regex;
	_tmp4_ = line;
	_tmp6_ = _tmp5_ = g_regex_split (_tmp3_, _tmp4_, 0);
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp6_;
		token_collection_length1 = _vala_array_length (_tmp5_);
		for (token_it = 0; token_it < _vala_array_length (_tmp5_); token_it = token_it + 1) {
			gchar* _tmp7_;
			gchar* token = NULL;
			_tmp7_ = g_strdup (token_collection[token_it]);
			token = _tmp7_;
			{
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				GQuark _tmp11_ = 0U;
				static GQuark _tmp10_label0 = 0;
				static GQuark _tmp10_label1 = 0;
				static GQuark _tmp10_label2 = 0;
				static GQuark _tmp10_label3 = 0;
				_tmp8_ = token;
				_tmp9_ = _tmp8_;
				_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
				if ((_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("\r")))) || (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("\r\n"))))) {
					switch (0) {
						default:
						{
							gchar** _tmp12_;
							gint _tmp12__length1;
							gchar* _tmp13_;
							_tmp12_ = tokens;
							_tmp12__length1 = tokens_length1;
							_tmp13_ = g_strdup (GAMES_CUE_SHEET_NEW_LINE);
							_vala_array_add17 (&tokens, &tokens_length1, &_tokens_size_, _tmp13_);
							break;
						}
					}
				} else if ((_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("")))) || (_tmp11_ == ((0 != _tmp10_label3) ? _tmp10_label3 : (_tmp10_label3 = g_quark_from_static_string (" "))))) {
					switch (0) {
						default:
						{
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp14_;
							gint _tmp14__length1;
							const gchar* _tmp15_;
							gchar* _tmp16_;
							_tmp14_ = tokens;
							_tmp14__length1 = tokens_length1;
							_tmp15_ = token;
							_tmp16_ = g_strdup (_tmp15_);
							_vala_array_add18 (&tokens, &tokens_length1, &_tokens_size_, _tmp16_);
							break;
						}
					}
				}
				_g_free0 (token);
			}
		}
		token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp18_ = tokens;
	_tmp18__length1 = tokens_length1;
	if (_tmp18__length1 != 0) {
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		_tmp19_ = tokens;
		_tmp19__length1 = tokens_length1;
		_tmp20_ = tokens;
		_tmp20__length1 = tokens_length1;
		_tmp21_ = _tmp19_[_tmp20__length1 - 1];
		_tmp17_ = g_strcmp0 (_tmp21_, GAMES_CUE_SHEET_NEW_LINE) != 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gchar** _tmp22_;
		gint _tmp22__length1;
		gchar* _tmp23_;
		_tmp22_ = tokens;
		_tmp22__length1 = tokens_length1;
		_tmp23_ = g_strdup (GAMES_CUE_SHEET_NEW_LINE);
		_vala_array_add19 (&tokens, &tokens_length1, &_tokens_size_, _tmp23_);
	}
	_tmp24_ = tokens;
	_tmp24__length1 = tokens_length1;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	return result;
}


static void _vala_array_add20 (GamesCueSheetTrackNode** * array, int* length, int* size, GamesCueSheetTrackNode* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesCueSheetTrackNode*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void games_cue_sheet_parse (GamesCueSheet* self, GError** error) {
	gchar** tokens;
	gint _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	GamesCueSheetFileNode* latest_file;
	gsize line;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = games_cue_sheet_tokenize (self, &_tmp0_, &_inner_error_);
	tokens = _tmp1_;
	tokens_length1 = _tmp0_;
	_tokens_size_ = tokens_length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	latest_file = NULL;
	line = (gsize) 1;
	{
		gsize i;
		i = (gsize) 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gsize _tmp4_;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gchar** _tmp6_;
				gint _tmp6__length1;
				gsize _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				GQuark _tmp11_ = 0U;
				static GQuark _tmp10_label0 = 0;
				static GQuark _tmp10_label1 = 0;
				if (!_tmp2_) {
					gsize _tmp3_;
					_tmp3_ = line;
					line = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = tokens;
				_tmp5__length1 = tokens_length1;
				if (!(_tmp4_ < ((gsize) _tmp5__length1))) {
					break;
				}
				_tmp6_ = tokens;
				_tmp6__length1 = tokens_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				_tmp9_ = _tmp8_;
				_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
				if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("FILE")))) {
					switch (0) {
						default:
						{
							GamesCueSheetFileNode* _tmp12_;
							gsize _tmp13_;
							GamesCueSheetFileNode* _tmp14_;
							GamesCueSheetFileNode* _tmp15_;
							_tmp13_ = line;
							_tmp14_ = games_cue_sheet_parse_file_line (self, &tokens, &tokens_length1, &i, _tmp13_, &_inner_error_);
							_tmp12_ = _tmp14_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (latest_file);
								tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
								return;
							}
							_tmp15_ = _tmp12_;
							_tmp12_ = NULL;
							_g_object_unref0 (latest_file);
							latest_file = _tmp15_;
							_g_object_unref0 (_tmp12_);
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("TRACK")))) {
					switch (0) {
						default:
						{
							GamesCueSheetTrackNode* _tmp16_;
							gsize _tmp17_;
							GamesCueSheetFileNode* _tmp18_;
							GamesCueSheetTrackNode* _tmp19_;
							GamesCueSheetTrackNode** _tmp20_;
							gint _tmp20__length1;
							GamesCueSheetTrackNode* _tmp21_;
							_tmp17_ = line;
							_tmp18_ = latest_file;
							_tmp19_ = games_cue_sheet_parse_track_line (self, &tokens, &tokens_length1, &i, _tmp17_, _tmp18_, &_inner_error_);
							_tmp16_ = _tmp19_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (latest_file);
								tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
								return;
							}
							_tmp20_ = self->priv->tracks;
							_tmp20__length1 = self->priv->tracks_length1;
							_tmp21_ = _tmp16_;
							_tmp16_ = NULL;
							_vala_array_add20 (&self->priv->tracks, &self->priv->tracks_length1, &self->priv->_tracks_size_, _tmp21_);
							_g_object_unref0 (_tmp16_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gsize _tmp29_;
							while (TRUE) {
								gboolean _tmp22_ = FALSE;
								gsize _tmp23_;
								gchar** _tmp24_;
								gint _tmp24__length1;
								gsize _tmp28_;
								_tmp23_ = i;
								_tmp24_ = tokens;
								_tmp24__length1 = tokens_length1;
								if (_tmp23_ < ((gsize) _tmp24__length1)) {
									gchar** _tmp25_;
									gint _tmp25__length1;
									gsize _tmp26_;
									const gchar* _tmp27_;
									_tmp25_ = tokens;
									_tmp25__length1 = tokens_length1;
									_tmp26_ = i;
									_tmp27_ = _tmp25_[_tmp26_];
									_tmp22_ = g_strcmp0 (_tmp27_, GAMES_CUE_SHEET_NEW_LINE) != 0;
								} else {
									_tmp22_ = FALSE;
								}
								if (!_tmp22_) {
									break;
								}
								_tmp28_ = i;
								i = _tmp28_ + 1;
							}
							_tmp29_ = i;
							i = _tmp29_ + 1;
							break;
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (latest_file);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static GamesCueSheetFileNode* games_cue_sheet_parse_file_line (GamesCueSheet* self, gchar*** tokens, int* tokens_length1, gsize* i, gsize line, GError** error) {
	GamesCueSheetFileNode* result = NULL;
	gsize _tmp0_;
	gchar* file_name;
	gsize _tmp1_;
	gchar* _tmp2_;
	gchar* file_format_string;
	gsize _tmp3_;
	gchar* _tmp4_;
	gsize _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	GFile* dir;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	GFile* child_file;
	GFile* _tmp23_;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	GamesCueSheetFileFormat file_format;
	const gchar* _tmp26_;
	GamesCueSheetFileFormat _tmp27_;
	GamesCueSheetFileFormat _tmp28_;
	GFile* _tmp37_;
	GamesCueSheetFileFormat _tmp38_;
	GamesCueSheetFileNode* _tmp39_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = line;
	games_cue_sheet_is_token (self, "FILE", tokens, tokens_length1, i, _tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = line;
	_tmp2_ = games_cue_sheet_get_token (self, tokens, tokens_length1, i, _tmp1_, &_inner_error_);
	file_name = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = line;
	_tmp4_ = games_cue_sheet_get_optional_token (self, tokens, tokens_length1, i, _tmp3_);
	file_format_string = _tmp4_;
	_tmp5_ = line;
	games_cue_sheet_is_end_of_line (self, tokens, tokens_length1, i, _tmp5_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (file_format_string);
			_g_free0 (file_name);
			return NULL;
		} else {
			_g_free0 (file_format_string);
			_g_free0 (file_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = file_name;
	_tmp9_ = g_str_has_prefix (_tmp8_, "\"");
	if (_tmp9_) {
		const gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = file_name;
		_tmp11_ = g_str_has_suffix (_tmp10_, "\"");
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = file_name;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp6_ = _tmp14_ > 1;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
		_tmp15_ = file_name;
		_tmp16_ = file_name;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_slice (_tmp15_, (glong) 1, (glong) (_tmp18_ - 1));
		_g_free0 (file_name);
		file_name = _tmp19_;
	}
	_tmp20_ = games_cue_sheet_get_file (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_file_get_parent (_tmp21_);
	dir = _tmp22_;
	_tmp23_ = dir;
	_tmp24_ = file_name;
	_tmp25_ = g_file_get_child (_tmp23_, _tmp24_);
	child_file = _tmp25_;
	_tmp26_ = file_format_string;
	_tmp27_ = games_cue_sheet_file_format_parse_string (_tmp26_);
	file_format = _tmp27_;
	_tmp28_ = file_format;
	if (_tmp28_ == GAMES_CUE_SHEET_FILE_FORMAT_INVALID) {
		GFile* _tmp29_;
		GFile* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gsize _tmp33_;
		const gchar* _tmp34_;
		GError* _tmp35_;
		GError* _tmp36_;
		_tmp29_ = games_cue_sheet_get_file (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_file_get_basename (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = line;
		_tmp34_ = file_format_string;
		_tmp35_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_INVALID_FILE_FORMAT, _ ("%s:%lu: Invalid file format %s, expected a valid file format or none."), _tmp32_, (gulong) _tmp33_, _tmp34_);
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp32_);
		_inner_error_ = _tmp36_;
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (child_file);
			_g_object_unref0 (dir);
			_g_free0 (file_format_string);
			_g_free0 (file_name);
			return NULL;
		} else {
			_g_object_unref0 (child_file);
			_g_object_unref0 (dir);
			_g_free0 (file_format_string);
			_g_free0 (file_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp37_ = child_file;
	_tmp38_ = file_format;
	_tmp39_ = games_cue_sheet_file_node_new (_tmp37_, _tmp38_);
	result = _tmp39_;
	_g_object_unref0 (child_file);
	_g_object_unref0 (dir);
	_g_free0 (file_format_string);
	_g_free0 (file_name);
	return result;
}


static GamesCueSheetTrackNode* games_cue_sheet_parse_track_line (GamesCueSheet* self, gchar*** tokens, int* tokens_length1, gsize* i, gsize line, GamesCueSheetFileNode* parent_file, GError** error) {
	GamesCueSheetTrackNode* result = NULL;
	GamesCueSheetFileNode* _tmp0_;
	gsize _tmp8_;
	gchar* track_number_string;
	gsize _tmp9_;
	gchar* _tmp10_;
	gchar* track_mode_string;
	gsize _tmp11_;
	gchar* _tmp12_;
	gsize _tmp13_;
	gint track_number;
	const gchar* _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_;
	GamesCueSheetTrackMode track_mode;
	const gchar* _tmp27_;
	GamesCueSheetTrackMode _tmp28_;
	GamesCueSheetTrackMode _tmp29_;
	GamesCueSheetFileNode* _tmp38_;
	gint _tmp39_;
	GamesCueSheetTrackMode _tmp40_;
	GamesCueSheetTrackNode* _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = parent_file;
	if (_tmp0_ == NULL) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gsize _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp1_ = games_cue_sheet_get_file (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_get_basename (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = line;
		_tmp6_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_TOKEN, _ ("%s:%lu: Unexpected token TRACK before a FILE token."), _tmp4_, (gulong) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp4_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = line;
	games_cue_sheet_is_token (self, "TRACK", tokens, tokens_length1, i, _tmp8_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = line;
	_tmp10_ = games_cue_sheet_get_token (self, tokens, tokens_length1, i, _tmp9_, &_inner_error_);
	track_number_string = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = line;
	_tmp12_ = games_cue_sheet_get_token (self, tokens, tokens_length1, i, _tmp11_, &_inner_error_);
	track_mode_string = _tmp12_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (track_number_string);
			return NULL;
		} else {
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = line;
	games_cue_sheet_is_end_of_line (self, tokens, tokens_length1, i, _tmp13_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			return NULL;
		} else {
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = track_number_string;
	_tmp15_ = atoi (_tmp14_);
	track_number = _tmp15_;
	_tmp17_ = track_number;
	if (_tmp17_ < 1) {
		_tmp16_ = TRUE;
	} else {
		gint _tmp18_;
		_tmp18_ = track_number;
		_tmp16_ = _tmp18_ > 99;
	}
	if (_tmp16_) {
		GFile* _tmp19_;
		GFile* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gsize _tmp23_;
		const gchar* _tmp24_;
		GError* _tmp25_;
		GError* _tmp26_;
		_tmp19_ = games_cue_sheet_get_file (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_file_get_basename (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = line;
		_tmp24_ = track_number_string;
		_tmp25_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_INVALID_TRACK_NUMBER, _ ("%s:%lu: Invalid track number %s, expected a number in the 1-99 range."), _tmp22_, (gulong) _tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp26_;
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			return NULL;
		} else {
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp27_ = track_mode_string;
	_tmp28_ = games_cue_sheet_track_mode_parse_string (_tmp27_);
	track_mode = _tmp28_;
	_tmp29_ = track_mode;
	if (_tmp29_ == GAMES_CUE_SHEET_TRACK_MODE_INVALID) {
		GFile* _tmp30_;
		GFile* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gsize _tmp34_;
		const gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		_tmp30_ = games_cue_sheet_get_file (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_file_get_basename (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = line;
		_tmp35_ = track_mode_string;
		_tmp36_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_INVALID_TRACK_MODE, _ ("%s:%lu: Invalid track mode %s, expected a valid track mode."), _tmp33_, (gulong) _tmp34_, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp33_);
		_inner_error_ = _tmp37_;
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			return NULL;
		} else {
			_g_free0 (track_mode_string);
			_g_free0 (track_number_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp38_ = parent_file;
	_tmp39_ = track_number;
	_tmp40_ = track_mode;
	_tmp41_ = games_cue_sheet_track_node_new (_tmp38_, _tmp39_, _tmp40_);
	result = _tmp41_;
	_g_free0 (track_mode_string);
	_g_free0 (track_number_string);
	return result;
}


static void games_cue_sheet_is_token (GamesCueSheet* self, const gchar* expected_token, gchar*** tokens, int* tokens_length1, gsize* i, gsize line, GError** error) {
	gsize _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gsize _tmp11_;
	const gchar* _tmp12_;
	gsize _tmp24_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expected_token != NULL);
	_tmp0_ = *i;
	_tmp1_ = *tokens;
	_tmp1__length1 = *tokens_length1;
	if (_tmp0_ >= ((gsize) _tmp1__length1)) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gsize _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp2_ = games_cue_sheet_get_file (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_basename (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = line;
		_tmp7_ = expected_token;
		_tmp8_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_EOF, _ ("%s:%lu: Unexpected end of file, expected %s."), _tmp5_, (gulong) _tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = *tokens;
	_tmp10__length1 = *tokens_length1;
	_tmp11_ = *i;
	_tmp12_ = _tmp10_[_tmp11_];
	if (g_strcmp0 (_tmp12_, GAMES_CUE_SHEET_NEW_LINE) == 0) {
		GFile* _tmp13_;
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gsize _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		gsize _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		_tmp13_ = games_cue_sheet_get_file (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_get_basename (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = line;
		_tmp18_ = *tokens;
		_tmp18__length1 = *tokens_length1;
		_tmp19_ = *i;
		_tmp20_ = _tmp18_[_tmp19_];
		_tmp21_ = expected_token;
		_tmp22_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_TOKEN, _ ("%s:%lu: Unexpected token %s, expected %s."), _tmp16_, (gulong) _tmp17_, _tmp20_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp16_);
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp24_ = *i;
	*i = _tmp24_ + 1;
}


static gchar* games_cue_sheet_get_token (GamesCueSheet* self, gchar*** tokens, int* tokens_length1, gsize* i, gsize line, GError** error) {
	gchar* result = NULL;
	gsize _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gsize _tmp10_;
	const gchar* _tmp11_;
	gchar* token;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gsize _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gsize _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = *i;
	_tmp1_ = *tokens;
	_tmp1__length1 = *tokens_length1;
	if (_tmp0_ >= ((gsize) _tmp1__length1)) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gsize _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp2_ = games_cue_sheet_get_file (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_basename (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = line;
		_tmp7_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_EOF, _ ("%s:%lu: Unexpected end of file, expected a token."), _tmp5_, (gulong) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = *tokens;
	_tmp9__length1 = *tokens_length1;
	_tmp10_ = *i;
	_tmp11_ = _tmp9_[_tmp10_];
	if (g_strcmp0 (_tmp11_, GAMES_CUE_SHEET_NEW_LINE) == 0) {
		GFile* _tmp12_;
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gsize _tmp16_;
		GError* _tmp17_;
		GError* _tmp18_;
		_tmp12_ = games_cue_sheet_get_file (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_file_get_basename (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = line;
		_tmp17_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_EOL, _ ("%s:%lu: Unexpected end of line, expected a token."), _tmp15_, (gulong) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp15_);
		_inner_error_ = _tmp18_;
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp19_ = *tokens;
	_tmp19__length1 = *tokens_length1;
	_tmp20_ = *i;
	_tmp21_ = _tmp19_[_tmp20_];
	_tmp22_ = g_strdup (_tmp21_);
	token = _tmp22_;
	_tmp23_ = *i;
	*i = _tmp23_ + 1;
	result = token;
	return result;
}


static gchar* games_cue_sheet_get_optional_token (GamesCueSheet* self, gchar*** tokens, int* tokens_length1, gsize* i, gsize line) {
	gchar* result = NULL;
	gsize _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gsize _tmp3_;
	const gchar* _tmp4_;
	gchar* token;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gsize _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gsize _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = *i;
	_tmp1_ = *tokens;
	_tmp1__length1 = *tokens_length1;
	if (_tmp0_ >= ((gsize) _tmp1__length1)) {
		result = NULL;
		return result;
	}
	_tmp2_ = *tokens;
	_tmp2__length1 = *tokens_length1;
	_tmp3_ = *i;
	_tmp4_ = _tmp2_[_tmp3_];
	if (g_strcmp0 (_tmp4_, GAMES_CUE_SHEET_NEW_LINE) == 0) {
		result = NULL;
		return result;
	}
	_tmp5_ = *tokens;
	_tmp5__length1 = *tokens_length1;
	_tmp6_ = *i;
	_tmp7_ = _tmp5_[_tmp6_];
	_tmp8_ = g_strdup (_tmp7_);
	token = _tmp8_;
	_tmp9_ = *i;
	*i = _tmp9_ + 1;
	result = token;
	return result;
}


static void games_cue_sheet_is_end_of_line (GamesCueSheet* self, gchar*** tokens, int* tokens_length1, gsize* i, gsize line, GError** error) {
	gboolean _tmp0_ = FALSE;
	gsize _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gsize _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = *i;
	_tmp2_ = *tokens;
	_tmp2__length1 = *tokens_length1;
	if (_tmp1_ < ((gsize) _tmp2__length1)) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		gsize _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = *tokens;
		_tmp3__length1 = *tokens_length1;
		_tmp4_ = *i;
		_tmp5_ = _tmp3_[_tmp4_];
		_tmp0_ = g_strcmp0 (_tmp5_, GAMES_CUE_SHEET_NEW_LINE) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gsize _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gsize _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
		GError* _tmp15_;
		_tmp6_ = games_cue_sheet_get_file (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = line;
		_tmp11_ = *tokens;
		_tmp11__length1 = *tokens_length1;
		_tmp12_ = *i;
		_tmp13_ = _tmp11_[_tmp12_];
		_tmp14_ = g_error_new (GAMES_CUE_SHEET_ERROR, GAMES_CUE_SHEET_ERROR_UNEXPECTED_TOKEN, _ ("%s:%lu: Unexpected token %s, expected end of line."), _tmp9_, (gulong) _tmp10_, _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == GAMES_CUE_SHEET_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = *i;
	*i = _tmp16_ + 1;
}


GFile* games_cue_sheet_get_file (GamesCueSheet* self) {
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}


guint games_cue_sheet_get_tracks_number (GamesCueSheet* self) {
	guint result;
	GamesCueSheetTrackNode** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->tracks;
	_tmp0__length1 = self->priv->tracks_length1;
	result = (guint) _tmp0__length1;
	return result;
}


static void games_cue_sheet_class_init (GamesCueSheetClass * klass) {
	games_cue_sheet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesCueSheetPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_cue_sheet_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_cue_sheet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_CUE_SHEET_FILE, games_cue_sheet_properties[GAMES_CUE_SHEET_FILE] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_CUE_SHEET_TRACKS_NUMBER, games_cue_sheet_properties[GAMES_CUE_SHEET_TRACKS_NUMBER] = g_param_spec_uint ("tracks-number", "tracks-number", "tracks-number", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void games_cue_sheet_instance_init (GamesCueSheet * self) {
	self->priv = GAMES_CUE_SHEET_GET_PRIVATE (self);
}


static void games_cue_sheet_finalize (GObject * obj) {
	GamesCueSheet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_CUE_SHEET, GamesCueSheet);
	_g_object_unref0 (self->priv->_file);
	self->priv->tracks = (_vala_array_free (self->priv->tracks, self->priv->tracks_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (games_cue_sheet_parent_class)->finalize (obj);
}


GType games_cue_sheet_get_type (void) {
	static volatile gsize games_cue_sheet_type_id__volatile = 0;
	if (g_once_init_enter (&games_cue_sheet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesCueSheetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_cue_sheet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesCueSheet), 0, (GInstanceInitFunc) games_cue_sheet_instance_init, NULL };
		GType games_cue_sheet_type_id;
		games_cue_sheet_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesCueSheet", &g_define_type_info, 0);
		g_once_init_leave (&games_cue_sheet_type_id__volatile, games_cue_sheet_type_id);
	}
	return games_cue_sheet_type_id__volatile;
}


static void _vala_games_cue_sheet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesCueSheet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_CUE_SHEET, GamesCueSheet);
	switch (property_id) {
		case GAMES_CUE_SHEET_FILE:
		g_value_set_object (value, games_cue_sheet_get_file (self));
		break;
		case GAMES_CUE_SHEET_TRACKS_NUMBER:
		g_value_set_uint (value, games_cue_sheet_get_tracks_number (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



