/* database.c generated by valac 0.36.1.17-97a62, the Vala compiler
 * generated from database.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>


#define GAMES_TYPE_DATABASE (games_database_get_type ())
#define GAMES_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE, GamesDatabase))
#define GAMES_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE, GamesDatabaseClass))
#define GAMES_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE))
#define GAMES_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE))
#define GAMES_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE, GamesDatabaseClass))

typedef struct _GamesDatabase GamesDatabase;
typedef struct _GamesDatabaseClass GamesDatabaseClass;
typedef struct _GamesDatabasePrivate GamesDatabasePrivate;
enum  {
	GAMES_DATABASE_DUMMY_PROPERTY,
	GAMES_DATABASE_LAST_PROPERTY
};
static GParamSpec* games_database_properties[GAMES_DATABASE_LAST_PROPERTY];
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_URI (games_uri_get_type ())
#define GAMES_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_URI, GamesUri))
#define GAMES_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_URI, GamesUriClass))
#define GAMES_IS_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_URI))
#define GAMES_IS_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_URI))
#define GAMES_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_URI, GamesUriClass))

typedef struct _GamesUri GamesUri;
typedef struct _GamesUriClass GamesUriClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define GAMES_TYPE_DATABASE_URI_SOURCE (games_database_uri_source_get_type ())
#define GAMES_DATABASE_URI_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE_URI_SOURCE, GamesDatabaseUriSource))
#define GAMES_DATABASE_URI_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE_URI_SOURCE, GamesDatabaseUriSourceClass))
#define GAMES_IS_DATABASE_URI_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE_URI_SOURCE))
#define GAMES_IS_DATABASE_URI_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE_URI_SOURCE))
#define GAMES_DATABASE_URI_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE_URI_SOURCE, GamesDatabaseUriSourceClass))

typedef struct _GamesDatabaseUriSource GamesDatabaseUriSource;
typedef struct _GamesDatabaseUriSourceClass GamesDatabaseUriSourceClass;

struct _GamesDatabase {
	GObject parent_instance;
	GamesDatabasePrivate * priv;
};

struct _GamesDatabaseClass {
	GObjectClass parent_class;
};

struct _GamesDatabasePrivate {
	sqlite3* database;
};

typedef enum  {
	GAMES_DATABASE_ERROR_COULDNT_OPEN,
	GAMES_DATABASE_ERROR_EXECUTION_FAILED,
	GAMES_DATABASE_ERROR_PREPARATION_FAILED,
	GAMES_DATABASE_ERROR_BINDING_FAILED
} GamesDatabaseError;
#define GAMES_DATABASE_ERROR games_database_error_quark ()

static gpointer games_database_parent_class = NULL;

GType games_database_get_type (void) G_GNUC_CONST;
#define GAMES_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_DATABASE, GamesDatabasePrivate))
#define GAMES_DATABASE_CREATE_TABLE_QUERY "\n" \
"\t\tCREATE TABLE IF NOT EXISTS game_resources (\n" \
"\t\t\tid INTEGER PRIMARY KEY NOT NULL,\n" \
"\t\t\turi TEXT NOT NULL\n" \
"\t\t);\n" \
"\t"
#define GAMES_DATABASE_ADD_GAME_RESOURCE_QUERY "\n\t\tINSERT INTO game_resources (id, uri) VALUES (NULL, $URI);\n\t"
#define GAMES_DATABASE_HAS_URI_QUERY "\n" \
"\t\tSELECT EXISTS (SELECT 1 FROM game_resources WHERE uri=$URI LIMIT 1" \
");\n" \
"\t"
GamesDatabase* games_database_new (const gchar* path, GError** error);
GamesDatabase* games_database_construct (GType object_type, const gchar* path, GError** error);
GQuark games_database_error_quark (void);
static void games_database_create_tables (GamesDatabase* self, GError** error);
gpointer games_uri_ref (gpointer instance);
void games_uri_unref (gpointer instance);
GParamSpec* games_param_spec_uri (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void games_value_set_uri (GValue* value, gpointer v_object);
void games_value_take_uri (GValue* value, gpointer v_object);
gpointer games_value_get_uri (const GValue* value);
GType games_uri_get_type (void) G_GNUC_CONST;
void games_database_add_uri (GamesDatabase* self, GamesUri* uri, GError** error);
gboolean games_database_has_uri (GamesDatabase* self, GamesUri* uri);
sqlite3_stmt* games_database_prepare (sqlite3* database, const gchar* query, GError** error);
void games_database_bind_text (sqlite3_stmt* statement, const gchar* parameter, const gchar* text, GError** error);
gchar* games_uri_to_string (GamesUri* self);
GType games_database_uri_source_get_type (void) G_GNUC_CONST;
GamesDatabaseUriSource* games_database_get_uri_source (GamesDatabase* self);
GamesDatabaseUriSource* games_database_uri_source_new (sqlite3* database);
GamesDatabaseUriSource* games_database_uri_source_construct (GType object_type, sqlite3* database);
static void games_database_exec (GamesDatabase* self, const gchar* query, sqlite3_callback callback, void* callback_target, GError** error);
static void games_database_finalize (GObject * obj);


GamesDatabase* games_database_construct (GType object_type, const gchar* path, GError** error) {
	GamesDatabase * self = NULL;
	const gchar* _tmp0_;
	sqlite3* _tmp1_ = NULL;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (GamesDatabase*) g_object_new (object_type, NULL);
	_tmp0_ = path;
	_tmp2_ = sqlite3_open (_tmp0_, &_tmp1_);
	_sqlite3_close0 (self->priv->database);
	self->priv->database = _tmp1_;
	if (_tmp2_ != SQLITE_OK) {
		const gchar* _tmp3_;
		GError* _tmp4_;
		_tmp3_ = path;
		_tmp4_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_COULDNT_OPEN, "Couldn’t open the database for “%s”.", _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	games_database_create_tables (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


GamesDatabase* games_database_new (const gchar* path, GError** error) {
	return games_database_construct (GAMES_TYPE_DATABASE, path, error);
}


void games_database_add_uri (GamesDatabase* self, GamesUri* uri, GError** error) {
	GamesUri* _tmp0_;
	gboolean _tmp1_;
	sqlite3_stmt* statement;
	sqlite3* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	GamesUri* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = uri;
	_tmp1_ = games_database_has_uri (self, _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->database;
	_tmp3_ = games_database_prepare (_tmp2_, GAMES_DATABASE_ADD_GAME_RESOURCE_QUERY, &_inner_error_);
	statement = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp4_ = statement;
	_tmp5_ = uri;
	_tmp6_ = games_uri_to_string (_tmp5_);
	_tmp7_ = _tmp6_;
	games_database_bind_text (_tmp4_, "$URI", _tmp7_, &_inner_error_);
	_g_free0 (_tmp7_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_sqlite3_finalize0 (statement);
		return;
	}
	_tmp8_ = statement;
	_tmp9_ = sqlite3_step (_tmp8_);
	if (_tmp9_ != SQLITE_DONE) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Execution failed.");
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		_sqlite3_finalize0 (statement);
		return;
	}
	_sqlite3_finalize0 (statement);
}


gboolean games_database_has_uri (GamesDatabase* self, GamesUri* uri) {
	gboolean result = FALSE;
	sqlite3_stmt* statement;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp3_;
	GamesUri* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->database;
	_tmp1_ = games_database_prepare (_tmp0_, GAMES_DATABASE_HAS_URI_QUERY, &_inner_error_);
	statement = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp2_;
	}
	_tmp3_ = statement;
	_tmp4_ = uri;
	_tmp5_ = games_uri_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	games_database_bind_text (_tmp3_, "$URI", _tmp6_, &_inner_error_);
	_g_free0 (_tmp6_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		_sqlite3_finalize0 (statement);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	_tmp8_ = statement;
	_tmp9_ = sqlite3_step (_tmp8_);
	switch (_tmp9_) {
		case SQLITE_ROW:
		{
			sqlite3_stmt* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = statement;
			_tmp11_ = sqlite3_column_text (_tmp10_, 0);
			result = g_strcmp0 (_tmp11_, "1") == 0;
			_sqlite3_finalize0 (statement);
			return result;
		}
		default:
		{
			g_debug ("database.vala:49: Execution failed.");
			result = FALSE;
			_sqlite3_finalize0 (statement);
			return result;
		}
	}
	_sqlite3_finalize0 (statement);
}


GamesDatabaseUriSource* games_database_get_uri_source (GamesDatabase* self) {
	GamesDatabaseUriSource* result = NULL;
	sqlite3* _tmp0_;
	GamesDatabaseUriSource* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = games_database_uri_source_new (_tmp0_);
	result = _tmp1_;
	return result;
}


static void games_database_create_tables (GamesDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	games_database_exec (self, GAMES_DATABASE_CREATE_TABLE_QUERY, NULL, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar* * errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


static void games_database_exec (GamesDatabase* self, const gchar* query, sqlite3_callback callback, void* callback_target, GError** error) {
	gchar* error_message = NULL;
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	sqlite3_callback _tmp2_;
	void* _tmp2__target;
	gchar* _tmp3_ = NULL;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = query;
	_tmp2_ = callback;
	_tmp2__target = callback_target;
	_tmp4_ = _sqlite3_exec (_tmp0_, _tmp1_, _tmp2_, _tmp2__target, &_tmp3_);
	_g_free0 (error_message);
	error_message = _tmp3_;
	if (_tmp4_ != SQLITE_OK) {
		const gchar* _tmp5_;
		GError* _tmp6_;
		_tmp5_ = error_message;
		_tmp6_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_EXECUTION_FAILED, "Execution failed: %s", _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (error_message);
		return;
	}
	_g_free0 (error_message);
}


sqlite3_stmt* games_database_prepare (sqlite3* database, const gchar* query, GError** error) {
	sqlite3_stmt* result = NULL;
	sqlite3_stmt* statement = NULL;
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (database != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = database;
	_tmp1_ = query;
	_tmp2_ = query;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp6_ = sqlite3_prepare_v2 (_tmp0_, _tmp1_, _tmp4_, &_tmp5_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp5_;
	if (_tmp6_ != SQLITE_OK) {
		sqlite3* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
		_tmp7_ = database;
		_tmp8_ = sqlite3_errmsg (_tmp7_);
		_tmp9_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_PREPARATION_FAILED, "Preparation failed: %s", _tmp8_);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_sqlite3_finalize0 (statement);
		return NULL;
	}
	result = statement;
	return result;
}


void games_database_bind_text (sqlite3_stmt* statement, const gchar* parameter, const gchar* text, GError** error) {
	gint position;
	sqlite3_stmt* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp7_;
	gint _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GDestroyNotify _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (statement != NULL);
	g_return_if_fail (parameter != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = statement;
	_tmp1_ = parameter;
	_tmp2_ = sqlite3_bind_parameter_index (_tmp0_, _tmp1_);
	position = _tmp2_;
	_tmp3_ = position;
	if (_tmp3_ <= 0) {
		const gchar* _tmp4_;
		gint _tmp5_;
		GError* _tmp6_;
		_tmp4_ = parameter;
		_tmp5_ = position;
		_tmp6_ = g_error_new (GAMES_DATABASE_ERROR, GAMES_DATABASE_ERROR_BINDING_FAILED, "Couldn't bind text to the parameter “%s”, unexpected position: %d.", _tmp4_, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp7_ = statement;
	_tmp8_ = position;
	_tmp9_ = text;
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = g_free;
	sqlite3_bind_text (_tmp7_, _tmp8_, _tmp10_, -1, _tmp11_);
}


static void games_database_class_init (GamesDatabaseClass * klass) {
	games_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesDatabasePrivate));
	G_OBJECT_CLASS (klass)->finalize = games_database_finalize;
}


static void games_database_instance_init (GamesDatabase * self) {
	self->priv = GAMES_DATABASE_GET_PRIVATE (self);
}


static void games_database_finalize (GObject * obj) {
	GamesDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_DATABASE, GamesDatabase);
	_sqlite3_close0 (self->priv->database);
	G_OBJECT_CLASS (games_database_parent_class)->finalize (obj);
}


GType games_database_get_type (void) {
	static volatile gsize games_database_type_id__volatile = 0;
	if (g_once_init_enter (&games_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesDatabase), 0, (GInstanceInitFunc) games_database_instance_init, NULL };
		GType games_database_type_id;
		games_database_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesDatabase", &g_define_type_info, 0);
		g_once_init_leave (&games_database_type_id__volatile, games_database_type_id);
	}
	return games_database_type_id__volatile;
}



