/* contacts-avatar-dialog.c generated by valac 0.15.0.96-556a, the Vala compiler
 * generated from contacts-avatar-dialog.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <math.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>


#define CONTACTS_TYPE_AVATAR_DIALOG (contacts_avatar_dialog_get_type ())
#define CONTACTS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog))
#define CONTACTS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))
#define CONTACTS_IS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_IS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_AVATAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))

typedef struct _ContactsAvatarDialog ContactsAvatarDialog;
typedef struct _ContactsAvatarDialogClass ContactsAvatarDialogClass;
typedef struct _ContactsAvatarDialogPrivate ContactsAvatarDialogPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;

#define CONTACTS_TYPE_CONTACT_FRAME (contacts_contact_frame_get_type ())
#define CONTACTS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrame))
#define CONTACTS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))
#define CONTACTS_IS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_IS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_CONTACT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))

typedef struct _ContactsContactFrame ContactsContactFrame;
typedef struct _ContactsContactFrameClass ContactsContactFrameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block35Data Block35Data;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block36Data Block36Data;

#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;
typedef struct _Block37Data Block37Data;

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_MEMORY_ICON (contacts_memory_icon_get_type ())
#define CONTACTS_MEMORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MEMORY_ICON, ContactsMemoryIcon))
#define CONTACTS_MEMORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MEMORY_ICON, ContactsMemoryIconClass))
#define CONTACTS_IS_MEMORY_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MEMORY_ICON))
#define CONTACTS_IS_MEMORY_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MEMORY_ICON))
#define CONTACTS_MEMORY_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MEMORY_ICON, ContactsMemoryIconClass))

typedef struct _ContactsMemoryIcon ContactsMemoryIcon;
typedef struct _ContactsMemoryIconClass ContactsMemoryIconClass;

struct _ContactsAvatarDialog {
	GtkDialog parent_instance;
	ContactsAvatarDialogPrivate * priv;
};

struct _ContactsAvatarDialogClass {
	GtkDialogClass parent_class;
};

struct _ContactsAvatarDialogPrivate {
	GnomeDesktopThumbnailFactory* thumbnail_factory;
	ContactsContact* contact;
	GtkGrid* view_grid;
	ContactsContactFrame* main_frame;
	GdkPixbuf* new_pixbuf;
};

struct _Block35Data {
	int _ref_count_;
	ContactsAvatarDialog * self;
	GdkPixbuf* avatar_pixbuf;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block36Data {
	int _ref_count_;
	ContactsAvatarDialog * self;
	GtkFileChooserDialog* chooser;
};

struct _Block37Data {
	int _ref_count_;
	ContactsAvatarDialog * self;
	ContactsContact* contact;
};

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GSettings* settings;
	ContactsWindow* window;
	ContactsStore* contacts_store;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};


static gpointer contacts_avatar_dialog_parent_class = NULL;
extern ContactsApp* contacts_app_app;

GType contacts_avatar_dialog_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
GType contacts_contact_frame_get_type (void) G_GNUC_CONST;
#define CONTACTS_AVATAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogPrivate))
enum  {
	CONTACTS_AVATAR_DIALOG_DUMMY_PROPERTY
};
#define CONTACTS_AVATAR_DIALOG_main_size 96
#define CONTACTS_AVATAR_DIALOG_icons_size 64
static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (Block35Data* _data35_);
ContactsContactFrame* contacts_contact_frame_new (gint size, gboolean with_button);
ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size, gboolean with_button);
void contacts_contact_frame_set_pixbuf (ContactsContactFrame* self, GdkPixbuf* a_pixbuf);
static void __lambda34_ (Block35Data* _data35_);
static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void ___lambda34__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename);
static void contacts_avatar_dialog_update_grid (ContactsAvatarDialog* self);
GType contacts_store_get_type (void) G_GNUC_CONST;
gchar** contacts_utils_get_stock_avatars (int* result_length1);
void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser);
static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (Block36Data* _data36_);
GType contacts_window_get_type (void) G_GNUC_CONST;
static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self);
static void __lambda35_ (Block36Data* _data36_, gint response);
static void ___lambda35__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsContact* contact);
ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsContact* contact);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (Block37Data* _data37_);
GType contacts_app_get_type (void) G_GNUC_CONST;
void contacts_contact_keep_widget_uptodate (ContactsContact* self, GtkWidget* w, GtkCallback callback, void* callback_target);
static void __lambda36_ (Block37Data* _data37_, GtkWidget* w);
void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details, ContactsContact* contact);
static void ___lambda36__gtk_callback (GtkWidget* widget, gpointer self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda37_ (ContactsAvatarDialog* self, gint response_id);
ContactsMemoryIcon* contacts_memory_icon_new_from_pixbuf (GdkPixbuf* pixbuf, GError** error);
ContactsMemoryIcon* contacts_memory_icon_construct_from_pixbuf (GType object_type, GdkPixbuf* pixbuf, GError** error);
GType contacts_memory_icon_get_type (void) G_GNUC_CONST;
static void ___lambda37__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void contacts_avatar_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	gint _tmp1_ = 0;
	gint w;
	GdkPixbuf* _tmp2_;
	gint _tmp3_ = 0;
	gint h;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gboolean _tmp7_;
	gint _tmp10_;
	gint _tmp11_;
	GdkPixbuf* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GdkPixbuf* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	w = _tmp1_;
	_tmp2_ = pixbuf;
	_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
	h = _tmp3_;
	_tmp5_ = w;
	if (_tmp5_ <= 128) {
		gint _tmp6_;
		_tmp6_ = h;
		_tmp4_ = _tmp6_ <= 128;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		_tmp8_ = pixbuf;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = w;
	_tmp11_ = h;
	if (_tmp10_ > _tmp11_) {
		gint _tmp12_;
		gint _tmp13_;
		gdouble _tmp14_ = 0.0;
		_tmp12_ = h;
		_tmp13_ = w;
		_tmp14_ = round ((_tmp12_ * 128.0) / _tmp13_);
		h = (gint) _tmp14_;
		w = 128;
	} else {
		gint _tmp15_;
		gint _tmp16_;
		gdouble _tmp17_ = 0.0;
		_tmp15_ = w;
		_tmp16_ = h;
		_tmp17_ = round ((_tmp15_ * 128.0) / _tmp16_);
		w = (gint) _tmp17_;
		h = 128;
	}
	_tmp18_ = pixbuf;
	_tmp19_ = w;
	_tmp20_ = h;
	_tmp21_ = gdk_pixbuf_scale_simple (_tmp18_, _tmp19_, _tmp20_, GDK_INTERP_HYPER);
	result = _tmp21_;
	return result;
}


static Block35Data* block35_data_ref (Block35Data* _data35_) {
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}


static void block35_data_unref (Block35Data* _data35_) {
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		ContactsAvatarDialog * self;
		self = _data35_->self;
		_g_object_unref0 (_data35_->avatar_pixbuf);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}


static void __lambda34_ (Block35Data* _data35_) {
	ContactsAvatarDialog * self;
	self = _data35_->self;
	contacts_avatar_dialog_selected_pixbuf (self, _data35_->avatar_pixbuf);
}


static void ___lambda34__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self) {
	__lambda34_ (self);
}


static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf) {
	ContactsContactFrame* result = NULL;
	Block35Data* _data35_;
	ContactsContactFrame* _tmp0_;
	ContactsContactFrame* _tmp1_;
	ContactsContactFrame* image_frame;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_pixbuf != NULL, NULL);
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = g_object_ref (self);
	_tmp0_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_icons_size, TRUE);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	image_frame = _tmp1_;
	_tmp2_ = source_pixbuf;
	_tmp3_ = gdk_pixbuf_scale_simple (_tmp2_, CONTACTS_AVATAR_DIALOG_icons_size, CONTACTS_AVATAR_DIALOG_icons_size, GDK_INTERP_HYPER);
	pixbuf = _tmp3_;
	contacts_contact_frame_set_pixbuf (image_frame, pixbuf);
	_tmp4_ = source_pixbuf;
	_tmp5_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp4_);
	_data35_->avatar_pixbuf = _tmp5_;
	g_signal_connect_data (image_frame, "clicked", (GCallback) ___lambda34__contacts_contact_frame_clicked, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
	result = image_frame;
	_g_object_unref0 (pixbuf);
	block35_data_unref (_data35_);
	_data35_ = NULL;
	return result;
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona) {
	ContactsContactFrame* result = NULL;
	FolksPersona* _tmp0_;
	FolksAvatarDetails* _tmp1_;
	FolksAvatarDetails* details;
	gboolean _tmp2_ = FALSE;
	FolksAvatarDetails* _tmp3_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (FOLKS_IS_AVATAR_DETAILS (_tmp0_) ? ((FolksAvatarDetails*) _tmp0_) : NULL);
	details = _tmp1_;
	_tmp3_ = details;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		FolksAvatarDetails* _tmp4_;
		GLoadableIcon* _tmp5_;
		GLoadableIcon* _tmp6_;
		_tmp4_ = details;
		_tmp5_ = folks_avatar_details_get_avatar (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == NULL;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		result = NULL;
		_g_object_unref0 (details);
		return result;
	}
	{
		FolksAvatarDetails* _tmp8_;
		GLoadableIcon* _tmp9_;
		GLoadableIcon* _tmp10_;
		GInputStream* _tmp11_ = NULL;
		GInputStream* stream;
		GInputStream* _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* pixbuf;
		GdkPixbuf* _tmp14_;
		ContactsContactFrame* _tmp15_ = NULL;
		_tmp8_ = details;
		_tmp9_ = folks_avatar_details_get_avatar (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_loadable_icon_load (_tmp10_, 128, NULL, NULL, &_inner_error_);
		stream = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
		_tmp12_ = stream;
		_tmp13_ = gdk_pixbuf_new_from_stream (_tmp12_, NULL, &_inner_error_);
		pixbuf = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			goto __catch25_g_error;
		}
		_tmp14_ = pixbuf;
		_tmp15_ = contacts_avatar_dialog_create_frame (self, _tmp14_);
		result = _tmp15_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (stream);
		_g_object_unref0 (details);
		return result;
	}
	goto __finally25;
	__catch25_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally25:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (details);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (details);
	return result;
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename) {
	ContactsContactFrame* result = NULL;
	ContactsContactFrame* image_frame;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	image_frame = NULL;
	{
		const gchar* _tmp0_;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* pixbuf;
		ContactsContactFrame* _tmp2_ = NULL;
		_tmp0_ = filename;
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error_);
		pixbuf = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
		_tmp2_ = contacts_avatar_dialog_create_frame (self, pixbuf);
		result = _tmp2_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (image_frame);
		return result;
	}
	goto __finally26;
	__catch26_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally26:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (image_frame);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = image_frame;
	return result;
}


static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	{
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* p;
		ContactsContactFrame* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp0_ = pixbuf;
		_tmp1_ = gdk_pixbuf_scale_simple (_tmp0_, CONTACTS_AVATAR_DIALOG_main_size, CONTACTS_AVATAR_DIALOG_main_size, GDK_INTERP_HYPER);
		p = _tmp1_;
		_tmp2_ = self->priv->main_frame;
		contacts_contact_frame_set_pixbuf (_tmp2_, p);
		_tmp3_ = pixbuf;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (self->priv->new_pixbuf);
		self->priv->new_pixbuf = _tmp4_;
		_g_object_unref0 (p);
	}
	goto __finally27;
	__catch27_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally27:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void contacts_avatar_dialog_update_grid (ContactsAvatarDialog* self) {
	gint i;
	gint j;
	gint _tmp20_;
	gint _tmp22_;
	gint _tmp28_ = 0;
	gchar** _tmp29_ = NULL;
	gchar** stock_files;
	gint stock_files_length1;
	gint _stock_files_size_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	GtkGrid* _tmp43_;
	g_return_if_fail (self != NULL);
	i = 0;
	j = 0;
	{
		ContactsContact* _tmp0_;
		FolksIndividual* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = self->priv->contact;
		_tmp1_ = _tmp0_->individual;
		_tmp2_ = folks_individual_get_personas (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_p_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp9_;
			ContactsContactFrame* _tmp10_ = NULL;
			ContactsContactFrame* frame;
			ContactsContactFrame* _tmp11_;
			_tmp5_ = _p_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _p_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			p = (FolksPersona*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = contacts_avatar_dialog_frame_for_persona (self, _tmp9_);
			frame = _tmp10_;
			_tmp11_ = frame;
			if (_tmp11_ != NULL) {
				GtkGrid* _tmp12_;
				ContactsContactFrame* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				_tmp12_ = self->priv->view_grid;
				_tmp13_ = frame;
				_tmp14_ = i;
				_tmp15_ = j;
				gtk_grid_attach (_tmp12_, (GtkWidget*) _tmp13_, _tmp14_, _tmp15_, 1, 1);
				_tmp16_ = i;
				i = _tmp16_ + 1;
				_tmp17_ = i;
				if (_tmp17_ >= 4) {
					gint _tmp18_;
					gint _tmp19_;
					_tmp18_ = i;
					i = _tmp18_ - 4;
					_tmp19_ = j;
					j = _tmp19_ + 1;
				}
			}
			_g_object_unref0 (frame);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp20_ = i;
	if (_tmp20_ != 0) {
		gint _tmp21_;
		i = 0;
		_tmp21_ = j;
		j = _tmp21_ + 1;
	}
	_tmp22_ = j;
	if (_tmp22_ != 0) {
		GtkSeparator* _tmp23_;
		GtkSeparator* _tmp24_;
		GtkSeparator* s;
		GtkGrid* _tmp25_;
		GtkSeparator* _tmp26_;
		gint _tmp27_;
		_tmp23_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		_tmp24_ = g_object_ref_sink (_tmp23_);
		s = _tmp24_;
		_tmp25_ = self->priv->view_grid;
		_tmp26_ = s;
		_tmp27_ = j;
		j = _tmp27_ + 1;
		gtk_grid_attach (_tmp25_, (GtkWidget*) _tmp26_, 0, _tmp27_, 4, 1);
		_g_object_unref0 (s);
	}
	_tmp29_ = contacts_utils_get_stock_avatars (&_tmp28_);
	stock_files = _tmp29_;
	stock_files_length1 = _tmp28_;
	_stock_files_size_ = stock_files_length1;
	_tmp30_ = stock_files;
	_tmp30__length1 = stock_files_length1;
	{
		gchar** file_name_collection = NULL;
		gint file_name_collection_length1 = 0;
		gint _file_name_collection_size_ = 0;
		gint file_name_it = 0;
		file_name_collection = _tmp30_;
		file_name_collection_length1 = _tmp30__length1;
		for (file_name_it = 0; file_name_it < _tmp30__length1; file_name_it = file_name_it + 1) {
			gchar* _tmp31_;
			gchar* file_name = NULL;
			_tmp31_ = g_strdup (file_name_collection[file_name_it]);
			file_name = _tmp31_;
			{
				const gchar* _tmp32_;
				ContactsContactFrame* _tmp33_ = NULL;
				ContactsContactFrame* frame;
				ContactsContactFrame* _tmp34_;
				_tmp32_ = file_name;
				_tmp33_ = contacts_avatar_dialog_frame_for_filename (self, _tmp32_);
				frame = _tmp33_;
				_tmp34_ = frame;
				if (_tmp34_ != NULL) {
					GtkGrid* _tmp35_;
					ContactsContactFrame* _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					_tmp35_ = self->priv->view_grid;
					_tmp36_ = frame;
					_tmp37_ = i;
					_tmp38_ = j;
					gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, _tmp37_, _tmp38_, 1, 1);
					_tmp39_ = i;
					i = _tmp39_ + 1;
					_tmp40_ = i;
					if (_tmp40_ >= 4) {
						gint _tmp41_;
						gint _tmp42_;
						_tmp41_ = i;
						i = _tmp41_ - 4;
						_tmp42_ = j;
						j = _tmp42_ + 1;
					}
				}
				_g_object_unref0 (frame);
				_g_free0 (file_name);
			}
		}
	}
	_tmp43_ = self->priv->view_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp43_);
	stock_files = (_vala_array_free (stock_files, stock_files_length1, (GDestroyNotify) g_free), NULL);
}


void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser) {
	GtkFileChooser* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* uri;
	const gchar* _tmp2_;
	GtkFileChooser* _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chooser != NULL);
	_tmp0_ = chooser;
	_tmp1_ = gtk_file_chooser_get_preview_uri (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	if (_tmp2_ != NULL) {
		GdkPixbuf* pixbuf;
		GtkFileChooser* _tmp3_;
		GtkWidget* _tmp4_ = NULL;
		GtkImage* _tmp5_;
		GtkImage* preview;
		const gchar* _tmp6_;
		GFile* _tmp7_ = NULL;
		GFile* file;
		GtkFileChooser* _tmp20_;
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_;
		pixbuf = NULL;
		_tmp3_ = chooser;
		_tmp4_ = gtk_file_chooser_get_preview_widget (_tmp3_);
		_tmp5_ = _g_object_ref0 (GTK_IS_IMAGE (_tmp4_) ? ((GtkImage*) _tmp4_) : NULL);
		preview = _tmp5_;
		_tmp6_ = uri;
		_tmp7_ = g_file_new_for_uri (_tmp6_);
		file = _tmp7_;
		{
			GFile* _tmp8_;
			GFileInfo* _tmp9_ = NULL;
			GFileInfo* file_info;
			GFileInfo* _tmp10_;
			_tmp8_ = file;
			_tmp9_ = g_file_query_info (_tmp8_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			file_info = _tmp9_;
			if (_inner_error_ != NULL) {
				goto __catch28_g_error;
			}
			_tmp10_ = file_info;
			if (_tmp10_ != NULL) {
				GFileInfo* _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gchar* mime_type;
				const gchar* _tmp14_;
				_tmp11_ = file_info;
				_tmp12_ = g_file_info_get_content_type (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				mime_type = _tmp13_;
				_tmp14_ = mime_type;
				if (_tmp14_ != NULL) {
					GnomeDesktopThumbnailFactory* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					GdkPixbuf* _tmp18_ = NULL;
					GdkPixbuf* _tmp19_;
					_tmp15_ = self->priv->thumbnail_factory;
					_tmp16_ = uri;
					_tmp17_ = mime_type;
					_tmp18_ = gnome_desktop_thumbnail_factory_generate_thumbnail (_tmp15_, _tmp16_, _tmp17_);
					_tmp19_ = _g_object_ref0 (_tmp18_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp19_;
				}
				_g_free0 (mime_type);
			}
			_g_object_unref0 (file_info);
		}
		goto __finally28;
		__catch28_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally28:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			_g_object_unref0 (preview);
			_g_object_unref0 (pixbuf);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp20_ = chooser;
		_tmp21_ = pixbuf;
		gtk_dialog_set_response_sensitive (GTK_IS_DIALOG (_tmp20_) ? ((GtkDialog*) _tmp20_) : NULL, (gint) GTK_RESPONSE_ACCEPT, _tmp21_ != NULL);
		_tmp22_ = pixbuf;
		if (_tmp22_ != NULL) {
			GtkImage* _tmp23_;
			GdkPixbuf* _tmp24_;
			_tmp23_ = preview;
			_tmp24_ = pixbuf;
			gtk_image_set_from_pixbuf (_tmp23_, _tmp24_);
		} else {
			GtkImage* _tmp25_;
			_tmp25_ = preview;
			gtk_image_set_from_stock (_tmp25_, GTK_STOCK_DIALOG_QUESTION, GTK_ICON_SIZE_DIALOG);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (preview);
		_g_object_unref0 (pixbuf);
	}
	_tmp26_ = chooser;
	gtk_file_chooser_set_preview_widget_active (_tmp26_, TRUE);
	_g_free0 (uri);
}


static Block36Data* block36_data_ref (Block36Data* _data36_) {
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}


static void block36_data_unref (Block36Data* _data36_) {
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		ContactsAvatarDialog * self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}


static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self) {
	contacts_avatar_dialog_update_preview (self, _sender);
}


static void __lambda35_ (Block36Data* _data36_, gint response) {
	ContactsAvatarDialog * self;
	gint _tmp0_;
	GtkFileChooserDialog* _tmp15_;
	GError * _inner_error_ = NULL;
	self = _data36_->self;
	_tmp0_ = response;
	if (_tmp0_ != ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp1_;
		_tmp1_ = _data36_->chooser;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
		return;
	}
	{
		GtkFileChooserDialog* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFile* file;
		GFile* _tmp7_;
		GFileInputStream* _tmp8_ = NULL;
		GFileInputStream* in_stream;
		GFileInputStream* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* pixbuf;
		GFileInputStream* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_ = NULL;
		GdkPixbuf* _tmp14_;
		_tmp2_ = _data36_->chooser;
		_tmp3_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		file = _tmp6_;
		_tmp7_ = file;
		_tmp8_ = g_file_read (_tmp7_, NULL, &_inner_error_);
		in_stream = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch29_g_error;
		}
		_tmp9_ = in_stream;
		_tmp10_ = gdk_pixbuf_new_from_stream ((GInputStream*) _tmp9_, NULL, &_inner_error_);
		pixbuf = _tmp10_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch29_g_error;
		}
		_tmp11_ = in_stream;
		g_input_stream_close ((GInputStream*) _tmp11_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch29_g_error;
		}
		_tmp12_ = pixbuf;
		_tmp13_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp12_);
		_tmp14_ = _tmp13_;
		contacts_avatar_dialog_selected_pixbuf (self, _tmp14_);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (in_stream);
		_g_object_unref0 (file);
	}
	goto __finally29;
	__catch29_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally29:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = _data36_->chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
}


static void ___lambda35__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda35_ (self, response_id);
}


static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self) {
	Block36Data* _data36_;
	const gchar* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkFileChooserDialog* _tmp2_;
	GtkFileChooserDialog* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	GtkFileChooserDialog* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* preview;
	GtkImage* _tmp8_;
	GtkFileChooserDialog* _tmp9_;
	GtkImage* _tmp10_;
	GtkFileChooserDialog* _tmp11_;
	GtkImage* _tmp12_;
	GtkFileChooserDialog* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* folder;
	const gchar* _tmp16_;
	GtkFileChooserDialog* _tmp19_;
	GtkFileChooserDialog* _tmp20_;
	g_return_if_fail (self != NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = _ ("Browse for more pictures");
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, (GtkWindow*) CONTACTS_WINDOW (_tmp1_), GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_data36_->chooser = _tmp3_;
	_tmp4_ = _data36_->chooser;
	gtk_window_set_modal ((GtkWindow*) _tmp4_, TRUE);
	_tmp5_ = _data36_->chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp5_, FALSE);
	_tmp6_ = (GtkImage*) gtk_image_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	preview = _tmp7_;
	_tmp8_ = preview;
	gtk_widget_set_size_request ((GtkWidget*) _tmp8_, 128, -1);
	_tmp9_ = _data36_->chooser;
	_tmp10_ = preview;
	gtk_file_chooser_set_preview_widget ((GtkFileChooser*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = _data36_->chooser;
	gtk_file_chooser_set_use_preview_label ((GtkFileChooser*) _tmp11_, FALSE);
	_tmp12_ = preview;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = _data36_->chooser;
	g_signal_connect_object ((GtkFileChooser*) _tmp13_, "update-preview", (GCallback) _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview, self, 0);
	_tmp14_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_tmp15_ = g_strdup (_tmp14_);
	folder = _tmp15_;
	_tmp16_ = folder;
	if (_tmp16_ != NULL) {
		GtkFileChooserDialog* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = _data36_->chooser;
		_tmp18_ = folder;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp17_, _tmp18_);
	}
	_tmp19_ = _data36_->chooser;
	g_signal_connect_data ((GtkDialog*) _tmp19_, "response", (GCallback) ___lambda35__gtk_dialog_response, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp20_ = _data36_->chooser;
	gtk_window_present ((GtkWindow*) _tmp20_);
	_g_free0 (folder);
	_g_object_unref0 (preview);
	block36_data_unref (_data36_);
	_data36_ = NULL;
}


static Block37Data* block37_data_ref (Block37Data* _data37_) {
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}


static void block37_data_unref (Block37Data* _data37_) {
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		ContactsAvatarDialog * self;
		self = _data37_->self;
		_g_object_unref0 (_data37_->contact);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}


static void __lambda36_ (Block37Data* _data37_, GtkWidget* w) {
	ContactsAvatarDialog * self;
	GtkWidget* _tmp0_;
	ContactsContact* _tmp1_;
	FolksIndividual* _tmp2_;
	ContactsContact* _tmp3_;
	self = _data37_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = _data37_->contact;
	_tmp2_ = _tmp1_->individual;
	_tmp3_ = _data37_->contact;
	contacts_contact_frame_set_image (CONTACTS_IS_CONTACT_FRAME (_tmp0_) ? ((ContactsContactFrame*) _tmp0_) : NULL, (FolksAvatarDetails*) _tmp2_, _tmp3_);
}


static void ___lambda36__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda36_ (self, widget);
}


static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	contacts_avatar_dialog_select_avatar_file_cb (self);
}


static void __lambda37_ (ContactsAvatarDialog* self, gint response_id) {
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_CLOSE)) {
		GdkPixbuf* _tmp1_;
		_tmp1_ = self->priv->new_pixbuf;
		if (_tmp1_ != NULL) {
			GdkPixbuf* _tmp2_;
			ContactsMemoryIcon* _tmp3_;
			ContactsMemoryIcon* icon;
			ContactsMemoryIcon* _tmp4_;
			_tmp2_ = self->priv->new_pixbuf;
			_tmp3_ = contacts_memory_icon_new_from_pixbuf (_tmp2_, &_inner_error_);
			icon = _tmp3_;
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp4_ = icon;
			g_signal_emit_by_name (self, "set-avatar", (GIcon*) _tmp4_);
			_g_object_unref0 (icon);
		}
	}
	gtk_widget_destroy ((GtkWidget*) self);
}


static void ___lambda37__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda37_ (self, response_id);
}


ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsContact* contact) {
	ContactsAvatarDialog * self = NULL;
	Block37Data* _data37_;
	ContactsContact* _tmp0_;
	ContactsContact* _tmp1_;
	GnomeDesktopThumbnailFactory* _tmp2_;
	ContactsContact* _tmp3_;
	ContactsContact* _tmp4_;
	const gchar* _tmp5_ = NULL;
	ContactsApp* _tmp6_;
	ContactsWindow* _tmp7_;
	const gchar* _tmp8_ = NULL;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkGrid* grid;
	GtkBox* _tmp11_ = NULL;
	GtkContainer* _tmp12_;
	GtkContainer* container;
	ContactsContactFrame* _tmp13_;
	ContactsContactFrame* _tmp14_;
	ContactsContact* _tmp15_;
	ContactsContactFrame* _tmp16_;
	ContactsContactFrame* _tmp17_;
	ContactsContactFrame* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* label;
	ContactsContact* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GtkFrame* _tmp28_;
	GtkFrame* _tmp29_;
	GtkFrame* frame;
	GtkStyleContext* _tmp30_ = NULL;
	GtkGrid* _tmp31_;
	GtkGrid* _tmp32_;
	GtkGrid* frame_grid;
	GtkScrolledWindow* _tmp33_;
	GtkScrolledWindow* _tmp34_;
	GtkScrolledWindow* scrolled;
	GtkGrid* _tmp35_;
	GtkGrid* _tmp36_;
	GtkGrid* _tmp37_;
	GtkToolbar* _tmp38_;
	GtkToolbar* _tmp39_;
	GtkToolbar* toolbar;
	GtkStyleContext* _tmp40_ = NULL;
	GtkToolButton* _tmp41_;
	GtkToolButton* _tmp42_;
	GtkToolButton* add_button;
	GtkStyleContext* _tmp43_ = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_tmp0_ = contact;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data37_->contact = _tmp1_;
	self = (ContactsAvatarDialog*) g_object_new (object_type, NULL);
	_data37_->self = g_object_ref (self);
	_tmp2_ = gnome_desktop_thumbnail_factory_new (GNOME_DESKTOP_THUMBNAIL_SIZE_NORMAL);
	_g_object_unref0 (self->priv->thumbnail_factory);
	self->priv->thumbnail_factory = _tmp2_;
	_tmp3_ = _data37_->contact;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->contact);
	self->priv->contact = _tmp4_;
	_tmp5_ = _ ("Select Picture");
	gtk_window_set_title ((GtkWindow*) self, _tmp5_);
	_tmp6_ = contacts_app_app;
	_tmp7_ = _tmp6_->window;
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp7_);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	_tmp8_ = _ ("Close");
	gtk_dialog_add_buttons ((GtkDialog*) self, _tmp8_, GTK_RESPONSE_CLOSE, NULL, NULL);
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	grid = _tmp10_;
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 8);
	gtk_grid_set_column_spacing (grid, (guint) 8);
	_tmp11_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp12_ = _g_object_ref0 (GTK_IS_CONTAINER (_tmp11_) ? ((GtkContainer*) _tmp11_) : NULL);
	container = _tmp12_;
	gtk_container_add (container, (GtkWidget*) grid);
	_tmp13_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_main_size, FALSE);
	_tmp14_ = g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->main_frame);
	self->priv->main_frame = _tmp14_;
	_tmp15_ = _data37_->contact;
	_tmp16_ = self->priv->main_frame;
	contacts_contact_keep_widget_uptodate (_tmp15_, (GtkWidget*) _tmp16_, ___lambda36__gtk_callback, _data37_);
	_tmp17_ = self->priv->main_frame;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, FALSE);
	_tmp18_ = self->priv->main_frame;
	gtk_grid_attach (grid, (GtkWidget*) _tmp18_, 0, 0, 1, 1);
	_tmp19_ = (GtkLabel*) gtk_label_new ("");
	_tmp20_ = g_object_ref_sink (_tmp19_);
	label = _tmp20_;
	_tmp21_ = _data37_->contact;
	_tmp22_ = contacts_contact_get_display_name (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat ("<span font='13'>", _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp25_, "</span>", NULL);
	_tmp27_ = _tmp26_;
	gtk_label_set_markup (label, _tmp27_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	gtk_widget_set_valign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) label, TRUE);
	g_object_set ((GtkMisc*) label, "xalign", 0.0f, NULL);
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
	gtk_grid_attach (grid, (GtkWidget*) label, 1, 0, 1, 1);
	gtk_grid_set_row_spacing (grid, (guint) 18);
	_tmp28_ = (GtkFrame*) gtk_frame_new (NULL);
	_tmp29_ = g_object_ref_sink (_tmp28_);
	frame = _tmp29_;
	_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) frame);
	gtk_style_context_add_class (_tmp30_, "contacts-avatar-frame");
	gtk_grid_attach (grid, (GtkWidget*) frame, 0, 1, 2, 1);
	_tmp31_ = (GtkGrid*) gtk_grid_new ();
	_tmp32_ = g_object_ref_sink (_tmp31_);
	frame_grid = _tmp32_;
	gtk_orientable_set_orientation ((GtkOrientable*) frame_grid, GTK_ORIENTATION_VERTICAL);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) frame_grid);
	_tmp33_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_tmp34_ = g_object_ref_sink (_tmp33_);
	scrolled = _tmp34_;
	gtk_scrolled_window_set_policy (scrolled, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_vexpand ((GtkWidget*) scrolled, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) scrolled, TRUE);
	gtk_widget_set_size_request ((GtkWidget*) scrolled, -1, 300);
	gtk_container_add ((GtkContainer*) frame_grid, (GtkWidget*) scrolled);
	_tmp35_ = (GtkGrid*) gtk_grid_new ();
	_tmp36_ = g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->view_grid);
	self->priv->view_grid = _tmp36_;
	_tmp37_ = self->priv->view_grid;
	gtk_scrolled_window_add_with_viewport (scrolled, (GtkWidget*) _tmp37_);
	_tmp38_ = (GtkToolbar*) gtk_toolbar_new ();
	_tmp39_ = g_object_ref_sink (_tmp38_);
	toolbar = _tmp39_;
	_tmp40_ = gtk_widget_get_style_context ((GtkWidget*) toolbar);
	gtk_style_context_add_class (_tmp40_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_MENU);
	gtk_widget_set_vexpand ((GtkWidget*) toolbar, FALSE);
	gtk_container_add ((GtkContainer*) frame_grid, (GtkWidget*) toolbar);
	_tmp41_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	_tmp42_ = g_object_ref_sink (_tmp41_);
	add_button = _tmp42_;
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
	_tmp43_ = gtk_widget_get_style_context ((GtkWidget*) add_button);
	gtk_style_context_add_class (_tmp43_, GTK_STYLE_CLASS_RAISED);
	gtk_tool_item_set_is_important ((GtkToolItem*) add_button, TRUE);
	gtk_container_add ((GtkContainer*) toolbar, (GtkWidget*) add_button);
	g_signal_connect_object (add_button, "clicked", (GCallback) _contacts_avatar_dialog_select_avatar_file_cb_gtk_tool_button_clicked, self, 0);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda37__gtk_dialog_response, self, 0);
	contacts_avatar_dialog_update_grid (self);
	gtk_widget_show_all ((GtkWidget*) grid);
	_g_object_unref0 (add_button);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (frame_grid);
	_g_object_unref0 (frame);
	_g_object_unref0 (label);
	_g_object_unref0 (container);
	_g_object_unref0 (grid);
	block37_data_unref (_data37_);
	_data37_ = NULL;
	return self;
}


ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsContact* contact) {
	return contacts_avatar_dialog_construct (CONTACTS_TYPE_AVATAR_DIALOG, contact);
}


static void contacts_avatar_dialog_class_init (ContactsAvatarDialogClass * klass) {
	contacts_avatar_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsAvatarDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_avatar_dialog_finalize;
	g_signal_new ("set_avatar", CONTACTS_TYPE_AVATAR_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_ICON);
}


static void contacts_avatar_dialog_instance_init (ContactsAvatarDialog * self) {
	self->priv = CONTACTS_AVATAR_DIALOG_GET_PRIVATE (self);
}


static void contacts_avatar_dialog_finalize (GObject* obj) {
	ContactsAvatarDialog * self;
	self = CONTACTS_AVATAR_DIALOG (obj);
	_g_object_unref0 (self->priv->thumbnail_factory);
	_g_object_unref0 (self->priv->contact);
	_g_object_unref0 (self->priv->view_grid);
	_g_object_unref0 (self->priv->main_frame);
	_g_object_unref0 (self->priv->new_pixbuf);
	G_OBJECT_CLASS (contacts_avatar_dialog_parent_class)->finalize (obj);
}


GType contacts_avatar_dialog_get_type (void) {
	static volatile gsize contacts_avatar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_avatar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAvatarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_avatar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAvatarDialog), 0, (GInstanceInitFunc) contacts_avatar_dialog_instance_init, NULL };
		GType contacts_avatar_dialog_type_id;
		contacts_avatar_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "ContactsAvatarDialog", &g_define_type_info, 0);
		g_once_init_leave (&contacts_avatar_dialog_type_id__volatile, contacts_avatar_dialog_type_id);
	}
	return contacts_avatar_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



