#include <stdio.h>
#include <string.h>

#include <libbonobo.h>

#include "Evolution-DataServer-Mail.h"
#include "e-mail-remote-glue-folderchange.h"
#include "e-mail-remote-glue-messageinfo.h"

static void e_mail_remote_glue_folderchange_class_init (EMailRemoteGlueFolderChangeClass *klass);
static void e_mail_remote_glue_folderchange_init (EMailRemoteGlueFolderChange *comp, EMailRemoteGlueFolderChangeClass *klass);
static void e_mail_remote_glue_folderchange_finalize (GObject *object);

/*static guint e_mail_remote_signals[LAST_SIGNAL] = { 0 };*/

static GObjectClass *parent_class;

/**
 * e_mail_remote_glue_folderchange_get_type:
 *
 * Registers the #EMailRemoteGlueFolderChange class if necessary, and returns the type ID
 * associated to it.
 *
 * Return value: The type ID of the #EMailRemoteGlueFolderChange class.
 **/
GType
e_mail_remote_glue_folderchange_get_type (void)
{
  static GType e_mail_remote_glue_folderchange_type = 0;

  if (!e_mail_remote_glue_folderchange_type) {
    static GTypeInfo info = {
      sizeof (EMailRemoteGlueFolderChangeClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) e_mail_remote_glue_folderchange_class_init,
      NULL, NULL,
      sizeof (EMailRemoteGlueFolderChange),
      0,
      (GInstanceInitFunc) e_mail_remote_glue_folderchange_init
    };
    e_mail_remote_glue_folderchange_type = g_type_register_static (G_TYPE_OBJECT, "EMailRemoteGlueFolderChange", &info, 0);
  }

  return e_mail_remote_glue_folderchange_type;
}

/* Class initialization function for the calendar-glue object */
static void
e_mail_remote_glue_folderchange_class_init (EMailRemoteGlueFolderChangeClass *klass)
{
  GObjectClass *object_class;

  object_class = (GObjectClass *) klass;

  parent_class = g_type_class_peek_parent (klass);

  object_class->finalize = e_mail_remote_glue_folderchange_finalize;
}

/* Object initialization function for the calendar-glue object */
static void
e_mail_remote_glue_folderchange_init (EMailRemoteGlueFolderChange *emrg_schange, EMailRemoteGlueFolderChangeClass *klass)
{  
  emrg_schange->msg_infos = NULL;
}

/**
 * e_mail_remote_glue_folderchange_new:
 *
 * Creates a new empty calendar-glue component object.  
 *
 * Return value: A newly-created calendar-glue component object.
 **/
EMailRemoteGlueFolderChange *
e_mail_remote_glue_folderchange_new (void)
{
  return E_MAIL_REMOTE_GLUE_FOLDERCHANGE (g_object_new (E_TYPE_MAIL_REMOTE_GLUE_FOLDERCHANGE, NULL));
}

/* Finalize handler for the calendar-glue component object */
static void
e_mail_remote_glue_folderchange_finalize (GObject *object)
{
  EMailRemoteGlueFolderChange *fchange;

  g_return_if_fail (object != NULL);
  g_return_if_fail (E_IS_MAIL_REMOTE_GLUE_FOLDERCHANGE (object));

  fchange = E_MAIL_REMOTE_GLUE_FOLDERCHANGE (object);

  if (fchange->msg_infos) {
    g_slist_foreach (fchange->msg_infos, (GFunc)g_object_unref, NULL);
    g_slist_free (fchange->msg_infos);
  }
  
  if (G_OBJECT_CLASS (parent_class)->finalize)
    (* G_OBJECT_CLASS (parent_class)->finalize) (object);
}

EMailRemoteGlueFolderChange*
e_mail_remote_glue_folderchange_new_clone (EMailRemoteGlueFolderChange* fchange)
{
  EMailRemoteGlueFolderChange* emrg_fchange = NULL;
  EMailRemoteGlueMessageInfo* msginfo = NULL;
  GSList* l;

  emrg_fchange = e_mail_remote_glue_folderchange_new ();
  for (l = fchange->msg_infos; l; l = l->next) {
    msginfo = e_mail_remote_glue_messageinfo_new_clone (l->data);
    emrg_fchange->msg_infos = g_slist_append (emrg_fchange->msg_infos, msginfo);
  }
  return emrg_fchange;
}


EMailRemoteGlueFolderChange*
e_mail_remote_glue_folderchange_new_from_EMFolderChange (Evolution_Mail_FolderChange fchange)
{
  EMailRemoteGlueFolderChange* emrg_fchange;
  EMailRemoteGlueMessageInfo* msginfo = NULL;
  int i = 0;

  emrg_fchange = e_mail_remote_glue_folderchange_new ();
  for (i = 0; i < fchange.messages._length; i++) {
    msginfo = e_mail_remote_glue_messageinfo_new_from_EMMessageInfo (fchange.messages._buffer[i]);
    emrg_fchange->msg_infos = g_slist_append (emrg_fchange->msg_infos, msginfo);
  }
  return emrg_fchange;
}

GSList*
e_mail_remote_glue_folderchange_get_message_info_list (EMailRemoteGlueFolderChange* fchange)
{
  g_return_val_if_fail (fchange != NULL, NULL);
  return fchange->msg_infos;
}
