#include <stdio.h>
#include <string.h>

#include <libbonobo.h>

#include "Evolution-DataServer-Mail.h"
#include "e-mail-remote-glue-messageinfo.h"

static void e_mail_remote_glue_messageinfo_class_init (EMailRemoteGlueMessageInfoClass *klass);
static void e_mail_remote_glue_messageinfo_init (EMailRemoteGlueMessageInfo *comp, EMailRemoteGlueMessageInfoClass *klass);
static void e_mail_remote_glue_messageinfo_finalize (GObject *object);

/*static guint e_mail_remote_signals[LAST_SIGNAL] = { 0 };*/

static GObjectClass *parent_class;

struct _EMailRemoteGlueMessageInfoPrivate {
  char* uid;
  char* subject;
  char* to;
  char* from;
  long flags;
  GSList* user_flags;
  GSList* user_tags;
};

/**
 * e_mail_remote_glue_messageinfo_get_type:
 *
 * Registers the #EMailRemoteGlueMessageInfo class if necessary, and returns the type ID
 * associated to it.
 *
 * Return value: The type ID of the #EMailRemoteGlueMessageInfo class.
 **/
GType
e_mail_remote_glue_messageinfo_get_type (void)
{
  static GType e_mail_remote_glue_messageinfo_type = 0;

  if (!e_mail_remote_glue_messageinfo_type) {
    static GTypeInfo info = {
      sizeof (EMailRemoteGlueMessageInfoClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) e_mail_remote_glue_messageinfo_class_init,
      NULL, NULL,
      sizeof (EMailRemoteGlueMessageInfo),
      0,
      (GInstanceInitFunc) e_mail_remote_glue_messageinfo_init
    };
    e_mail_remote_glue_messageinfo_type = g_type_register_static (G_TYPE_OBJECT, "EMailRemoteGlueMessageInfo", &info, 0);
  }

  return e_mail_remote_glue_messageinfo_type;
}

/* Class initialization function for the calendar-glue object */
static void
e_mail_remote_glue_messageinfo_class_init (EMailRemoteGlueMessageInfoClass *klass)
{
  GObjectClass *object_class;

  object_class = (GObjectClass *) klass;

  parent_class = g_type_class_peek_parent (klass);

  object_class->finalize = e_mail_remote_glue_messageinfo_finalize;
}

/* Object initialization function for the calendar-glue object */
static void
e_mail_remote_glue_messageinfo_init (EMailRemoteGlueMessageInfo *emrg_finfo, EMailRemoteGlueMessageInfoClass *klass)
{  
  emrg_finfo->priv = g_new0 (EMailRemoteGlueMessageInfoPrivate, 1);
}

/**
 * e_mail_remote_glue_messageinfo_new:
 *
 * Creates a new empty calendar-glue component object.  
 *
 * Return value: A newly-created calendar-glue component object.
 **/
EMailRemoteGlueMessageInfo *
e_mail_remote_glue_messageinfo_new (void)
{
  return E_MAIL_REMOTE_GLUE_MESSAGEINFO (g_object_new (E_TYPE_MAIL_REMOTE_GLUE_MESSAGEINFO, NULL));
}

static void
emrgmi_free_user_tag (gpointer user_tag, gpointer user_data) 
{
  EMUserTag* tag = user_tag;
  if (tag) {
    g_free (tag->name);
    g_free (tag->value);
  }
  g_free (tag);
}

void
e_mail_remote_glue_messageinfo_free_user_tag_list (GSList* user_tag_list)
{
    if (user_tag_list) {
      g_slist_foreach (user_tag_list, emrgmi_free_user_tag, NULL);
      g_slist_free (user_tag_list);
    }
}

/* Finalize handler for the calendar-glue component object */
static void
e_mail_remote_glue_messageinfo_finalize (GObject *object)
{
  EMailRemoteGlueMessageInfo *sinfo;

  g_return_if_fail (object != NULL);
  g_return_if_fail (E_IS_MAIL_REMOTE_GLUE_MESSAGEINFO (object));

  sinfo = E_MAIL_REMOTE_GLUE_MESSAGEINFO (object);
  if (sinfo->priv) {
    g_free (sinfo->priv->subject);
    g_free (sinfo->priv->uid);
    g_free (sinfo->priv->from);
    g_free (sinfo->priv->to);

    e_mail_remote_glue_messageinfo_free_user_tag_list (sinfo->priv->user_tags);
    
    if (sinfo->priv->user_flags) {
      g_slist_foreach (sinfo->priv->user_flags, (GFunc)g_free, NULL);
      g_slist_free (sinfo->priv->user_flags);
    }
  }
  
  if (G_OBJECT_CLASS (parent_class)->finalize)
    (* G_OBJECT_CLASS (parent_class)->finalize) (object);
}

EMailRemoteGlueMessageInfo*
e_mail_remote_glue_messageinfo_new_clone (EMailRemoteGlueMessageInfo* info)
{
  EMailRemoteGlueMessageInfo* emrg_msginfo = e_mail_remote_glue_messageinfo_new ();
  EMailRemoteGlueMessageInfoPrivate* priv = emrg_msginfo->priv;
  EMUserTag* tag = NULL;
  GSList* l;

  priv->uid = g_strdup (info->priv->uid);
  priv->subject = g_strdup (info->priv->subject);
  priv->to = g_strdup (info->priv->to);
  priv->from = g_strdup (info->priv->from);

  for (l = info->priv->user_flags; l; l = l->next)
    priv->user_flags = g_slist_append (priv->user_flags, g_strdup (l->data));

  for (l = info->priv->user_tags; l; l = l->next) {
    tag = g_new0 (EMUserTag, 1);
    tag->name = g_strdup (((EMUserTag *)l->data)->name);
    tag->value = g_strdup (((EMUserTag *)l->data)->value);
    priv->user_tags = g_slist_prepend (priv->user_tags, tag);
  }
  priv->user_tags = g_slist_reverse (priv->user_tags);

  return emrg_msginfo;
}

EMailRemoteGlueMessageInfo*
e_mail_remote_glue_messageinfo_new_from_EMMessageInfo (Evolution_Mail_MessageInfo info)
{
  EMailRemoteGlueMessageInfo* emrg_msginfo = e_mail_remote_glue_messageinfo_new ();
  EMailRemoteGlueMessageInfoPrivate* priv = emrg_msginfo->priv;  
  EMUserTag* tag = NULL;
  GSList *tags = NULL, *flags = NULL;
  int i;
  
  priv->uid = g_strdup (info.uid);
  priv->subject = g_strdup (info.subject);
  priv->to = g_strdup (info.to);
  priv->from = g_strdup (info.from);
  priv->flags = info.flags;
  for (i = 0; i < info.userTags._length; i++) {
    tag = g_new0 (EMUserTag, 1);
    tag->name = g_strdup (info.userTags._buffer[i].name);
    tag->value = g_strdup (info.userTags._buffer[i].value);
    tags = g_slist_prepend (tags, tag);
  }
  tags = g_slist_reverse (tags);

  for (i = 0; i < info.userFlags._length; i++) {
    flags = g_slist_append (flags, g_strdup (info.userFlags._buffer[i]));
  }

  priv->user_tags = tags;
  priv->user_flags = flags;

  return emrg_msginfo;
}

char* 
e_mail_remote_glue_messageinfo_peek_uid (EMailRemoteGlueMessageInfo* msginfo)
{
  g_return_val_if_fail (msginfo != NULL, NULL);
  g_return_val_if_fail (msginfo->priv != NULL, NULL);
  
  return msginfo->priv->uid;
}

char* 
e_mail_remote_glue_messageinfo_peek_subject (EMailRemoteGlueMessageInfo* msginfo)
{
  g_return_val_if_fail (msginfo != NULL, NULL);
  g_return_val_if_fail (msginfo->priv != NULL, NULL);
  
  return msginfo->priv->subject;
}

char* 
e_mail_remote_glue_messageinfo_peek_to (EMailRemoteGlueMessageInfo* msginfo)
{
  g_return_val_if_fail (msginfo != NULL, NULL);
  g_return_val_if_fail (msginfo->priv != NULL, NULL);
  
  return msginfo->priv->to;
}

char* 
e_mail_remote_glue_messageinfo_peek_from (EMailRemoteGlueMessageInfo* msginfo)
{
  g_return_val_if_fail (msginfo != NULL, NULL);
  g_return_val_if_fail (msginfo->priv != NULL, NULL);
  
  return msginfo->priv->from;
}

long 
e_mail_remote_glue_messageinfo_peek_flags (EMailRemoteGlueMessageInfo* msginfo)
{
  g_return_val_if_fail (msginfo != NULL, 0);
  g_return_val_if_fail (msginfo->priv != NULL, 0);
  
  return msginfo->priv->flags;
}

GSList*
e_mail_remote_glue_messageinfo_peek_user_flags (EMailRemoteGlueMessageInfo* msginfo)
{
  g_return_val_if_fail (msginfo != NULL, NULL);
  g_return_val_if_fail (msginfo->priv != NULL, NULL);
  
  return msginfo->priv->user_flags;
}

GSList* 
e_mail_remote_glue_messageinfo_peek_user_tags (EMailRemoteGlueMessageInfo* msginfo)
{
  g_return_val_if_fail (msginfo != NULL, NULL);
  g_return_val_if_fail (msginfo->priv != NULL, NULL);
  
  return msginfo->priv->user_tags;
}
