using System;
using System.Collections;

// TODO: (Also, we need exception-rules support.
// As of now, this provides a very basic support, (ie),
// represent whatever is there in the underlying e-d-s, AS IS.
// More "resonable" interpretation is yet to be done.
	
namespace Evolution {

	//
	// Recurrence enumerations
	//

	public enum FrequencyType {
		//
		// Please do not change the order/values of the items.
		//

		SECONDLY=0,
		MINUTELY=1,
		HOURLY=2,
		DAILY=3,
		WEEKLY=4,
		MONTHLY=5,
		YEARLY=6,
		FREQUENCY_NO=7
	};

	public enum WeekDayType {
		NO_WEEKDAY,
		SUNDAY,
		MONDAY,
		TUESDAY,
		WEDNESDAY,
		THURSDAY,
		FRIDAY,
		SATURDAY
	};

	public enum ByValuesType {
		SECOND,
		MINUTE,
		HOUR,
		DAY,
		MONTH_DAY,
		YEAR_DAY,
		WEEK_NUMBER,
		MONTH,
		SET_POS
	};

	public class CalRecurrence {

		static short recurrence_array_max = 0x7f7f;
		static short recurrence_array_max_byte = 0x7f;
		
		FrequencyType freq;
		DateTime until;
		int count;
		int week_start_day;
		short interval;
		short[] by_second;
		short[] by_minute;
		short[] by_hour;
		short[] by_day;
		short[] by_month_day;
		short[] by_year_day;
		short[] by_week_no;
		short[] by_month;
		short[] by_set_pos;

		public CalRecurrence ()
		{
			freq = FrequencyType.FREQUENCY_NO;
			count = -1;
			week_start_day = -1;
			interval = -1;
			by_second = null;
			by_minute = null;
			by_hour = null;
			by_day = null;
			by_month_day = null;
			by_year_day = null;
			by_week_no = null;
			by_month = null;
			by_set_pos = null;
		}

		public FrequencyType Frequency {
			get {
				return freq;
			}

			set {
				freq = value;
			}
		}

		public int Count {
			get {
				return count;
			}

			set {
				count = value;
			}
		}

		public DateTime Enddate {
			get {
				return until;
			}

			set {
				until = value;
			}
		}

		public int WeekStartDay {
			get {
				return week_start_day;
			}

			set {
				week_start_day = value;
			}
		}

                public short Interval {
                        get {
                                return interval;
                        }

                        set {
                                interval = value;
                        }
                }

                public short[] BySecond {
                        get {
                                return by_second;
                        }

                        set {
                                by_second = value;
                        }
                }

                public short[] ByMinute {
                        get {
                                return by_minute;
                        }

                        set {
                                by_minute = value;
                        }
                }

                public short[] ByHour {
                        get {
                                return by_hour;
                        }

                        set {
                                by_hour = value;
                        }
                }
                public short[] ByDay {
                        get {
                                return by_day;
                        }

                        set {
                                by_day = value;
                        }
                }
                public short[] ByMonthDay {
                        get {
                                return by_month_day;
                        }

                        set {
                                by_month_day = value;
                        }
                }
               public short[] ByYearDay {
                        get {
                                return by_year_day;
                        }

                        set {
                                by_year_day = value;
                        }
                }
               public short[] ByWeekNumber {
                        get {
                                return by_week_no;
                        }

                        set {
                                by_week_no = value;
                        }
                }

               public short[] ByMonth {
                        get {
                                return by_month;
                        }

                        set {
                                by_month = value;
                        }
                }

               public short[] BySetPos {
                        get {
                                return by_set_pos;
                        }

                        set {
                                by_set_pos = value;
                        }
                }

		public string FrequencyToString (FrequencyType f)
		{
			switch (f) {
			case FrequencyType.SECONDLY: return "second(s)";
			case FrequencyType.MINUTELY: return "minute(s)";
			case FrequencyType.HOURLY: return "hour(s)";
			case FrequencyType.DAILY: return "day(s)";
			case FrequencyType.WEEKLY: return "week(s)";
			case FrequencyType.MONTHLY: return "month(s)";
			case FrequencyType.YEARLY: return "year(s)";
			}
			return "";
		}

		public string WeekDayToString (WeekDayType d)
		{
			switch (d) {
			case WeekDayType.SUNDAY: return "sunday";
			case WeekDayType.MONDAY: return "monday";
			case WeekDayType.TUESDAY: return "tuesday";
			case WeekDayType.WEDNESDAY: return "wednesday";
			case WeekDayType.THURSDAY: return "thursday";
			case WeekDayType.FRIDAY: return "friday";
			case WeekDayType.SATURDAY: return "saturday";
			}
			return "";
		}

		private string DecodeSeconds (short[] by_value)
		{
			int i;
			string retval;
			
			for (i = 0; i < by_value.Length; i++) {
				if (by_value [i] != recurrence_array_max) {
					;//retval 
				}
			}
			return "";
		}

		private string DecodeByValues (short[] by_value, ByValuesType which_by)
		{
			switch (which_by) {
			case ByValuesType.SECOND: return DecodeSeconds (by_value);
				/*
			case ByValuesType.MINUTE: return DecodeMinutes (by_value);
			case ByValuesType.HOUR: return DecodeHours (by_value);
			case ByValuesType.DAY: return DecodeDayOfWeek (by_value);
			case ByValuesType.MONTH_DAY: return DecodeDayOfMonth (by_value);
			case ByValuesType.YEAR_DAY: return DecodeDayOfYear (by_value);
			case ByValuesType.WEEK_NUMBER: return DecodeWeekNumber (by_value);
			case ByValuesType.MONTH: return DecodeMonth (by_value);
			case ByValuesType.SET_POS: return DecodeSetPos (by_value);
				*/
			}
			return "";
		}

		override public string ToString () 
		{
			string strFreq;
			string strRecur;
			
			strFreq = String.Format ("every {0} {1}", interval, FrequencyToString (Frequency));
			strRecur = String.Format ("Meeting occurs {0}", strFreq);
			
			return strRecur;
		}
	}
}
