#include <string.h>

#include "Evolution-DataServer-Mail.h"
#include "e-mail-remote-glue-utils.h"

void 
e_mail_exception_dump (CORBA_Environment *ev, char *what)
{
  const char *id = CORBA_exception_id (ev);

  switch (ev->_major) {
  case CORBA_USER_EXCEPTION:
    if (!strcmp (id, ex_Evolution_Mail_MailException)) {
      Evolution_Mail_MailException *x = CORBA_exception_value(ev);

      switch (x->id) {
      case Evolution_Mail_SYSTEM_ERROR:
	printf ("Failed %s: System error %s\n", what, x->desc);
	break;
      case Evolution_Mail_CAMEL_ERROR:
	printf ("Failed %s: Camel error %s\n", what, x->desc);
	break;
      default:
	printf ("Failed %s: %s\n", what, x->desc);
	break;
      }
      break;
    }
  default:
    printf ("Failed %s: %s\n", what, id);
    break;
  }

  CORBA_exception_free (ev);
}
