/* This is -*- C -*- */
/* $Id: guppi-plot-window.c,v 1.4 2000/04/13 19:45:20 trow Exp $ */

/*
 * guppi-plot-window.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <guppi-debug.h>
#include <guppi-exit.h>
#include "guppi-plot-window.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_plot_window_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_plot_window_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_plot_window_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_plot_window_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_plot_window_class_init(GuppiPlotWindowClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(gnome_app_get_type());

  object_class->get_arg = guppi_plot_window_get_arg;
  object_class->set_arg = guppi_plot_window_set_arg;
  object_class->destroy = guppi_plot_window_destroy;
  object_class->finalize = guppi_plot_window_finalize;

}

/***************************************************************************/

/* Menu Callbacks */

static void
new_view_cb(GtkWidget* w, gpointer data)
{
  GuppiPlotWindow* win = GUPPI_PLOT_WINDOW(data);
  GtkWidget* new_win;

  g_return_if_fail(win != NULL);

  new_win = guppi_plot_window_new(win->view->state);
  gtk_widget_show(new_win);
}

static void
save_cb(GtkWidget* w, gpointer data)
{
  guppi_unimplemented_function_dialog("Save");
}

static void
saveas_cb(GtkWidget* w, gpointer data)
{
  guppi_unimplemented_function_dialog("Save As");
}

static void
print_cb(GtkWidget* w, gpointer data)
{
  guppi_unimplemented_function_dialog("Print");
}

static void
close_cb(GtkWidget* w, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

static void
exit_cb(GtkWidget* w, gpointer data)
{
  guppi_exit();
}

/***************************************************************************/

static void
guppi_plot_window_build_menus(GuppiPlotWindow* gpw)
{
  GnomeApp* app;

  static GnomeUIInfo file_menu[] = {
    {GNOME_APP_UI_ITEM,
     N_("New View"), N_("Create a New View Window For This Plot"),
     new_view_cb, NULL, NULL,
     GNOME_APP_PIXMAP_NONE, NULL,
     0, (GdkModifierType)0, NULL },
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_MENU_SAVE_ITEM(save_cb, NULL),
    GNOMEUIINFO_MENU_SAVE_AS_ITEM(saveas_cb, NULL),
    GNOMEUIINFO_MENU_PRINT_ITEM(print_cb, NULL),
    GNOMEUIINFO_MENU_CLOSE_ITEM(close_cb, NULL),
    GNOMEUIINFO_MENU_EXIT_ITEM(exit_cb, NULL),
    GNOMEUIINFO_END
  };

  static GnomeUIInfo plotwin_menus[] = {
    GNOMEUIINFO_MENU_FILE_TREE(file_menu),
    GNOMEUIINFO_END
  };

  app = GNOME_APP(gpw);
  g_return_if_fail(app != NULL);


  gnome_app_create_menus_with_data(app, plotwin_menus, gpw);
}

/***************************************************************************/

static void
guppi_plot_window_init(GuppiPlotWindow* obj)
{
  obj->view = NULL;
}

GtkType
guppi_plot_window_get_type(void)
{
  static GtkType guppi_plot_window_type = 0;
  if (!guppi_plot_window_type) {
    static const GtkTypeInfo guppi_plot_window_info = {
      "GuppiPlotWindow",
      sizeof(GuppiPlotWindow),
      sizeof(GuppiPlotWindowClass),
      (GtkClassInitFunc)guppi_plot_window_class_init,
      (GtkObjectInitFunc)guppi_plot_window_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_plot_window_type = gtk_type_unique(gnome_app_get_type(),
					     &guppi_plot_window_info);
  }
  return guppi_plot_window_type;
}

void
guppi_plot_window_construct(GuppiPlotWindow* gpw, GuppiPlotState* state)
{
  g_return_if_fail(gpw != NULL);
  g_return_if_fail(state != NULL);
  g_return_if_fail(gpw->view == NULL);

  gnome_app_construct(GNOME_APP(gpw), PACKAGE, "Plot");

  guppi_plot_window_build_menus(gpw);

  gpw->status_bar = GNOME_APPBAR(gnome_appbar_new(FALSE, TRUE, 
						  GNOME_PREFERENCES_USER));
  gnome_app_set_statusbar(GNOME_APP(gpw), GTK_WIDGET(gpw->status_bar));

  /* Building a view is just like building a canvas, so we need to
     push our visual and colormap. */
  gtk_widget_push_visual(gdk_rgb_get_visual());
  gtk_widget_push_colormap(gdk_rgb_get_cmap());
  gpw->view = GUPPI_PLOT_VIEW(guppi_plot_view_new(state));
  gtk_widget_pop_colormap();
  gtk_widget_pop_visual(); 

  gnome_app_set_contents(GNOME_APP(gpw), GTK_WIDGET(gpw->view));
}

GtkWidget*
guppi_plot_window_new(GuppiPlotState* state)
{
  GuppiPlotWindow* win;

  g_return_val_if_fail(state != NULL, NULL);

  win = GUPPI_PLOT_WINDOW(gtk_type_new(guppi_plot_window_get_type()));

  guppi_plot_window_construct(win, state);

  return GTK_WIDGET(win);
}



/* $Id: guppi-plot-window.c,v 1.4 2000/04/13 19:45:20 trow Exp $ */
