/* This is -*- C -*- */
/* $Id: guppi-plot-view.h,v 1.2 2000/04/13 19:45:20 trow Exp $ */

/*
 * guppi-plot-view.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PLOT_VIEW_H
#define _INC_GUPPI_PLOT_VIEW_H

#include <config.h>
#include <gnome.h>
#include "guppi-plot-state.h"

typedef struct _GuppiPlotView GuppiPlotView;
typedef struct _GuppiPlotViewClass GuppiPlotViewClass;

struct _GuppiPlotView {
  GnomeCanvas parent;

  GuppiPlotState* state;
};

struct _GuppiPlotViewClass {
  GnomeCanvasClass parent_class;
};

#define GUPPI_TYPE_PLOT_VIEW (guppi_plot_view_get_type())
#define GUPPI_PLOT_VIEW(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_PLOT_VIEW,GuppiPlotView))
#define GUPPI_PLOT_VIEW_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_PLOT_VIEW,GuppiPlotViewClass))
#define GUPPI_IS_PLOT_VIEW(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_PLOT_VIEW))
#define GUPPI_IS_PLOT_VIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_PLOT_VIEW))

GtkType guppi_plot_view_get_type(void);

GtkWidget* guppi_plot_view_new(GuppiPlotState*);



#endif /* _INC_GUPPI_PLOT_VIEW_H */

/* $Id: guppi-plot-view.h,v 1.2 2000/04/13 19:45:20 trow Exp $ */
