/* This is -*- C -*- */
/* $Id: guppi-plot-state.h,v 1.5 2000/04/21 23:22:44 trow Exp $ */

/*
 * guppi-plot-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PLOT_STATE_H
#define _INC_GUPPI_PLOT_STATE_H

#include <config.h>
#include <gnome.h>
#include "guppi-plot-element.h"

typedef struct _GuppiPlotState GuppiPlotState;
typedef struct _GuppiPlotStateClass GuppiPlotStateClass;

struct _GuppiPlotState {
  GtkObject parent;

  /* elements are listed top to bottom */
  GList* elements;
};

struct _GuppiPlotStateClass {
  GtkObjectClass parent_class;

  void (*add)(GuppiPlotState*, GuppiPlotElement*);
  void (*remove)(GuppiPlotState*, GuppiPlotElement*);
};

#define GUPPI_TYPE_PLOT_STATE (guppi_plot_state_get_type())
#define GUPPI_PLOT_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_PLOT_STATE,GuppiPlotState))
#define GUPPI_PLOT_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_PLOT_STATE,GuppiPlotStateClass))
#define GUPPI_IS_PLOT_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_PLOT_STATE))
#define GUPPI_IS_PLOT_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_PLOT_STATE))

GtkType guppi_plot_state_get_type(void);

GuppiPlotState* guppi_plot_state_new(void);

void guppi_plot_state_add_element(GuppiPlotState*, GuppiPlotElement*);
void guppi_plot_state_add_element_at(GuppiPlotState*, GuppiPlotElement*,
				     gint gridpos_x, gint gridpos_y);
void guppi_plot_state_remove_element(GuppiPlotState*, GuppiPlotElement*);
guint guppi_plot_state_element_count(GuppiPlotState*);
GuppiPlotElement* guppi_plot_state_get_element(GuppiPlotState*, gint);

void guppi_plot_state_render(GuppiPlotState*, GnomeCanvas*);

/* Debug fn */
void guppi_plot_state_view(GuppiPlotState*);



#endif /* _INC_GUPPI_PLOT_STATE_H */

/* $Id: guppi-plot-state.h,v 1.5 2000/04/21 23:22:44 trow Exp $ */
