/* This is -*- C -*- */
/* $Id: guppi-plot-control.h,v 1.2 2000/04/13 19:45:20 trow Exp $ */

/*
 * guppi-plot-control.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PLOT_CONTROL_H
#define _INC_GUPPI_PLOT_CONTROL_H

#include <config.h>
#include <gnome.h>
#include "guppi-plot-state.h"

typedef struct _GuppiPlotControl GuppiPlotControl;
typedef struct _GuppiPlotControlClass GuppiPlotControlClass;

struct _GuppiPlotControl {
  GtkVBox parent;

  GtkCList* clist;
  gint current_selection;
  GuppiPlotState* state;
};

struct _GuppiPlotControlClass {
  GtkVBoxClass parent_class;
};

#define GUPPI_TYPE_PLOT_CONTROL (guppi_plot_control_get_type())
#define GUPPI_PLOT_CONTROL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_PLOT_CONTROL,GuppiPlotControl))
#define GUPPI_PLOT_CONTROL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_PLOT_CONTROL,GuppiPlotControlClass))
#define GUPPI_IS_PLOT_CONTROL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_PLOT_CONTROL))
#define GUPPI_IS_PLOT_CONTROL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_PLOT_CONTROL))

GtkType guppi_plot_control_get_type(void);

void guppi_plot_control_construct(GuppiPlotControl*, GuppiPlotState*);
GtkWidget* guppi_plot_control_new(GuppiPlotState*);



#endif /* _INC_GUPPI_PLOT_CONTROL_H */

/* $Id: guppi-plot-control.h,v 1.2 2000/04/13 19:45:20 trow Exp $ */
