/* This is -*- C -*- */
/* $Id: guppi-layout-grid.h,v 1.3 2000/05/03 17:06:51 trow Exp $ */

/*
 * guppi-layout-grid.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_LAYOUT_GRID_H
#define _INC_GUPPI_LAYOUT_GRID_H

#include <config.h>
#include <gnome.h>

#include "guppi-layout-grid-cell.h"

typedef struct _GuppiLayoutGrid GuppiLayoutGrid;
typedef struct _GuppiLayoutGridClass GuppiLayoutGridClass;

struct _GuppiLayoutGrid {
  GtkObject parent;
  
  gint cols, rows;
  GuppiLayoutGridCell** cells;

  GnomeCanvas* connected_canvas;

  guint idle_id;
  double last_x0, last_x1, last_y0, last_y1;
};

struct _GuppiLayoutGridClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_LAYOUT_GRID (guppi_layout_grid_get_type())
#define GUPPI_LAYOUT_GRID(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_LAYOUT_GRID,GuppiLayoutGrid))
#define GUPPI_LAYOUT_GRID0(obj) ((obj) ? (GUPPI_LAYOUT_GRID(obj)) : NULL)
#define GUPPI_LAYOUT_GRID_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_LAYOUT_GRID,GuppiLayoutGridClass))
#define GUPPI_IS_LAYOUT_GRID(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_LAYOUT_GRID))
#define GUPPI_IS_LAYOUT_GRID0(obj) (((obj) == NULL) || (GUPPI_IS_LAYOUT_GRID(obj)))
#define GUPPI_IS_LAYOUT_GRID_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_LAYOUT_GRID))

GtkType guppi_layout_grid_get_type(void);

GuppiLayoutGrid* guppi_layout_grid_new(void);

void guppi_layout_grid_schedule_allocation(GuppiLayoutGrid*);

void guppi_layout_grid_set_size(GuppiLayoutGrid*, gint cols, gint rows);
void guppi_layout_grid_set_add_columns(GuppiLayoutGrid*, gint c, gint N);
void guppi_layout_grid_set_add_rows(GuppiLayoutGrid*, gint r, gint N);

GuppiLayoutGridCell* guppi_layout_grid_get_cell(GuppiLayoutGrid*, 
						gint c, gint r);

void guppi_layout_grid_allocate(GuppiLayoutGrid*, 
				double x0, double y0, double x1, double y1);

void guppi_layout_grid_connect_to_canvas(GuppiLayoutGrid*, GnomeCanvas*);

/* Connect up data and scales in the expected way. */
void guppi_layout_grid_connect_items_gridwise(GuppiLayoutGrid*);


#endif /* _INC_GUPPI_LAYOUT_GRID_H */

/* $Id: guppi-layout-grid.h,v 1.3 2000/05/03 17:06:51 trow Exp $ */
