/* This is -*- C -*- */
/* $Id: guppi-layout-grid-cell.h,v 1.3 2000/05/01 04:41:38 trow Exp $ */

/*
 * guppi-layout-grid-cell.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_LAYOUT_GRID_CELL_H
#define _INC_GUPPI_LAYOUT_GRID_CELL_H

#include <config.h>
#include <gnome.h>

#include "guppi-canvas-item.h"

typedef enum _GuppiLayoutGridCellAlign GuppiLayoutGridCellAlign;
enum _GuppiLayoutGridCellAlign {
  GUPPI_CELL_ALIGN_FILL,
  GUPPI_CELL_ALIGN_CENTER,
  GUPPI_CELL_ALIGN_LEFT,
  GUPPI_CELL_ALIGN_RIGHT,
  GUPPI_CELL_ALIGN_TOP,
  GUPPI_CELL_ALIGN_BOTTOM,
  GUPPI_CELL_ALIGN_LAST
};

typedef struct _GuppiLayoutGridCell GuppiLayoutGridCell;
typedef struct _GuppiLayoutGridCellClass GuppiLayoutGridCellClass;

struct _GuppiLayoutGridCell {
  GtkObject parent;

  gboolean changed_geometry;

  double x, y;
  double width, height;

  GuppiLayoutGridCellAlign align_horizontal, align_vertical;

  double min_width, min_height;
  double req_width, req_height;
  double max_width, max_height;
  double hunger_width, hunger_height;

  GList* items;
};

struct _GuppiLayoutGridCellClass {
  GtkObjectClass parent_class;

  void (*changed)(GuppiLayoutGridCell*);
};

#define GUPPI_TYPE_LAYOUT_GRID_CELL (guppi_layout_grid_cell_get_type())
#define GUPPI_LAYOUT_GRID_CELL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_LAYOUT_GRID_CELL,GuppiLayoutGridCell))
#define GUPPI_LAYOUT_GRID_CELL0(obj) ((obj) ? (GUPPI_LAYOUT_GRID_CELL(obj)) : NULL)
#define GUPPI_LAYOUT_GRID_CELL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_LAYOUT_GRID_CELL,GuppiLayoutGridCellClass))
#define GUPPI_IS_LAYOUT_GRID_CELL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_LAYOUT_GRID_CELL))
#define GUPPI_IS_LAYOUT_GRID_CELL0(obj) (((obj) == NULL) || (GUPPI_IS_LAYOUT_GRID_CELL(obj)))
#define GUPPI_IS_LAYOUT_GRID_CELL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_LAYOUT_GRID_CELL))

GtkType guppi_layout_grid_cell_get_type(void);

GuppiLayoutGridCell* guppi_layout_grid_cell_new(void);

void guppi_layout_grid_cell_calc_properties(GuppiLayoutGridCell*);

void guppi_layout_grid_cell_add_item(GuppiLayoutGridCell*, GuppiCanvasItem*);

void guppi_layout_grid_cell_set_allocation(GuppiLayoutGridCell*,
					   double x, double y,
					   double width, double height);


#endif /* _INC_GUPPI_LAYOUT_GRID_CELL_H */

/* $Id: guppi-layout-grid-cell.h,v 1.3 2000/05/01 04:41:38 trow Exp $ */
