/* This is -*- C -*- */
/* $Id: guppi-graphpaper-state.c,v 1.1 2000/04/21 23:22:40 trow Exp $ */

/*
 * guppi-graphpaper-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-graphpaper-state.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_graphpaper_state_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_graphpaper_state_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_graphpaper_state_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_graphpaper_state_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_graphpaper_state_class_init(GuppiGraphpaperStateClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GUPPI_TYPE_ITEM_STATE);

  object_class->get_arg = guppi_graphpaper_state_get_arg;
  object_class->set_arg = guppi_graphpaper_state_set_arg;
  object_class->destroy = guppi_graphpaper_state_destroy;
  object_class->finalize = guppi_graphpaper_state_finalize;

}

static void
guppi_graphpaper_state_init(GuppiGraphpaperState* obj)
{

}

GtkType
guppi_graphpaper_state_get_type(void)
{
  static GtkType guppi_graphpaper_state_type = 0;
  if (!guppi_graphpaper_state_type) {
    static const GtkTypeInfo guppi_graphpaper_state_info = {
      "GuppiGraphpaperState",
      sizeof(GuppiGraphpaperState),
      sizeof(GuppiGraphpaperStateClass),
      (GtkClassInitFunc)guppi_graphpaper_state_class_init,
      (GtkObjectInitFunc)guppi_graphpaper_state_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_graphpaper_state_type = gtk_type_unique(GUPPI_TYPE_ITEM_STATE, &guppi_graphpaper_state_info);
  }
  return guppi_graphpaper_state_type;
}

GtkObject*
guppi_graphpaper_state_new(void)
{
  return GTK_OBJECT(gtk_type_new(guppi_graphpaper_state_get_type()));
}



/* $Id: guppi-graphpaper-state.c,v 1.1 2000/04/21 23:22:40 trow Exp $ */
