/* This is -*- C -*- */
/* $Id: guppi-graphpaper-element.h,v 1.2 2000/04/25 13:57:14 trow Exp $ */

/*
 * guppi-graphpaper-element.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_GRAPHPAPER_ELEMENT_H
#define _INC_GUPPI_GRAPHPAPER_ELEMENT_H

#include <config.h>
#include <gnome.h>

#include <guppi-plot-element.h>
#include "guppi-graphpaper-state.h"

typedef struct _GuppiGraphpaperElement GuppiGraphpaperElement;
typedef struct _GuppiGraphpaperElementClass GuppiGraphpaperElementClass;

struct _GuppiGraphpaperElement {
  GuppiPlotElement parent;
};

struct _GuppiGraphpaperElementClass {
  GuppiPlotElementClass parent_class;
};

#define GUPPI_TYPE_GRAPHPAPER_ELEMENT (guppi_graphpaper_element_get_type())
#define GUPPI_GRAPHPAPER_ELEMENT(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_GRAPHPAPER_ELEMENT,GuppiGraphpaperElement))
#define GUPPI_GRAPHPAPER_ELEMENT0(obj) ((obj) ? (GUPPI_GRAPHPAPER_ELEMENT(obj)) : NULL)
#define GUPPI_GRAPHPAPER_ELEMENT_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_GRAPHPAPER_ELEMENT,GuppiGraphpaperElementClass))
#define GUPPI_IS_GRAPHPAPER_ELEMENT(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_GRAPHPAPER_ELEMENT))
#define GUPPI_IS_GRAPHPAPER_ELEMENT0(obj) (((obj) == NULL) || (GUPPI_IS_GRAPHPAPER_ELEMENT(obj)))
#define GUPPI_IS_GRAPHPAPER_ELEMENT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_GRAPHPAPER_ELEMENT))

GtkType guppi_graphpaper_element_get_type(void);

GuppiPlotElement* guppi_graphpaper_element_new(void);




#endif /* _INC_GUPPI_GRAPHPAPER_ELEMENT_H */

/* $Id: guppi-graphpaper-element.h,v 1.2 2000/04/25 13:57:14 trow Exp $ */
