/* This is -*- C -*- */
/* $Id: guppi-boxplot-item.h,v 1.1 2000/04/25 13:57:13 trow Exp $ */

/*
 * guppi-boxplot-item.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_BOXPLOT_ITEM_H
#define _INC_GUPPI_BOXPLOT_ITEM_H

#include <config.h>
#include <gnome.h>

#include <guppi-canvas-item.h>

typedef struct _GuppiBoxplotItem GuppiBoxplotItem;
typedef struct _GuppiBoxplotItemClass GuppiBoxplotItemClass;

struct _GuppiBoxplotItem {
  GuppiCanvasItem parent;

  ArtSVP* box_svp;
};

struct _GuppiBoxplotItemClass {
  GuppiCanvasItemClass parent_class;
};

#define GUPPI_TYPE_BOXPLOT_ITEM (guppi_boxplot_item_get_type())
#define GUPPI_BOXPLOT_ITEM(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_BOXPLOT_ITEM,GuppiBoxplotItem))
#define GUPPI_BOXPLOT_ITEM0(obj) ((obj) ? (GUPPI_BOXPLOT_ITEM(obj)) : NULL)
#define GUPPI_BOXPLOT_ITEM_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_BOXPLOT_ITEM,GuppiBoxplotItemClass))
#define GUPPI_IS_BOXPLOT_ITEM(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_BOXPLOT_ITEM))
#define GUPPI_IS_BOXPLOT_ITEM0(obj) (((obj) == NULL) || (GUPPI_IS_BOXPLOT_ITEM(obj)))
#define GUPPI_IS_BOXPLOT_ITEM_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_BOXPLOT_ITEM))

GtkType guppi_boxplot_item_get_type(void);

GtkObject* guppi_boxplot_item_new(void);



#endif /* _INC_GUPPI_BOXPLOT_ITEM_H */

/* $Id: guppi-boxplot-item.h,v 1.1 2000/04/25 13:57:13 trow Exp $ */
