/* $Id: guppi-axis-calc.c,v 1.4 2000/04/21 23:22:40 trow Exp $ */

/*
 * guppi-axis-calc.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.

 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <math.h>
#include <guppi-useful.h>
#include <guppi-nice-values.h>
#include "guppi-axis-calc.h"

GList*
optimal_guppi_axis_numerical_labels(double pos_min, double pos_max,
				    gint goal, gint base)
{
  gsize N;
  gint i;
  double* values;
  GList* label_list = NULL;
  GuppiAxisLabel* label;

  values = guppi_nice_values(pos_min, pos_max, goal, base, &N);
  for (i=0; i<N; ++i) {
    label = g_new0(GuppiAxisLabel, 1);
    label->pos = values[i];
    label->text = g_strdup_printf("%g", label->pos);
    label_list = g_list_prepend(label_list, label);
  }
  label_list = g_list_reverse(label_list);

  g_free(values);
  return label_list;
}

void
guppi_axis_label_list_free(GList* ll)
{
  GList* iter = ll;
  GuppiAxisLabel* label;

  while (iter != NULL) {

    label = (GuppiAxisLabel*)iter->data;
    g_assert(label != NULL);

    if (label->text) {
      g_free(label->text);
      label->text = NULL;

      if (label->atemp)
	gtk_object_unref(GTK_OBJECT(label->atemp));
    }

    g_free(label);

    iter = g_list_next(iter);
  }

  if (ll)
    g_list_free(ll);
}

void
guppi_axis_label_render_labels(GList* new_list, GList* old_list)
{
  GList* new_iter;
  GList* old_iter;
  GuppiAxisLabel* new_label;
  GuppiAxisLabel* old_label;
  GnomeFont* font;
  double size;

  g_return_if_fail(new_list != NULL);

  /* Steal already-rendered text alpha templates from old list */
  if (old_list) {
    new_iter = new_list;

    while (new_iter) {

      new_label = (GuppiAxisLabel*)new_iter->data;

      old_iter = old_list;
      while (old_iter) {
	old_label = (GuppiAxisLabel*)old_iter->data;

	if (new_label->font == old_label->font &&
	    new_label->size == old_label->size &&
	    new_label->rot == old_label->rot &&
	    !strcmp(new_label->text, old_label->text)) {
	  new_label->atemp = old_label->atemp;
	  old_label->atemp = NULL;
	  break;
	}
	old_iter = g_list_next(old_iter);
      }
      new_iter = g_list_next(new_iter);
    }
  }

  /* Go through and do the rendering for the remaining labels */
  new_iter = new_list;
  while (new_iter) {
    new_label = (GuppiAxisLabel*)new_iter->data;
    if (new_label->atemp == NULL) {

      font = new_label->font;
      if (font == NULL)
	font = guppi_default_font();

      size = new_label->size;
      if (size <= 0)
	size = guppi_default_axis_label_size();

      new_label->atemp = guppi_alpha_template_text_general(font,
							   size,
							   new_label->text,
							   new_label->rot,
							   TRUE, 0);
    }
    new_iter = g_list_next(new_iter);
  }
}


/* $Id: guppi-axis-calc.c,v 1.4 2000/04/21 23:22:40 trow Exp $ */
