/* This is -*- C -*- */
/* $Id: guppi-plot-tool.h,v 1.2 2000/03/04 18:52:51 trow Exp $ */

/*
 * guppi-plot-tool.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PLOT_TOOL_H
#define _INC_GUPPI_PLOT_TOOL_H

#include <config.h>
#include <gnome.h>

#include "guppi-canvas-item.h"

typedef enum {
  GPTPC_NONE,
  GPTPC_FRAME,
  GPTPC_CIRCLE
} GuppiPlotToolPositionCue;

typedef struct _GuppiPlotTool GuppiPlotTool;
typedef struct _GuppiPlotToolClass GuppiPlotToolClass;

struct _GuppiPlotTool {
  GtkObject parent;

  gint tool_id;
  const gchar* name;
  GtkType acts_on;

  GdkCursor* cursor;

  gboolean tracks_motion;
  GuppiPlotToolPositionCue cue_type;
  guint32 cue_fill_color;
  double cue_arg;
  GnomeCanvasItem* cue_item;

  gboolean repeating;
  gint repeat_interval;

  double arg1, arg2;
  gpointer arg3;

  double raw_start_x, raw_start_y;
  double raw_prev_x, raw_prev_y;
  double raw_x, raw_y;
  
  double start_x, start_y;
  double prev_x, prev_y;
  double x, y; /* current x, y */
  gint repeater_tag;

  GuppiCanvasItem* canvas_item;

  void (*first)(GuppiPlotTool*, GuppiCanvasItem*);
  void (*middle)(GuppiPlotTool*, GuppiCanvasItem*);
  void (*repeat)(GuppiPlotTool*, GuppiCanvasItem*);
  void (*last)(GuppiPlotTool*, GuppiCanvasItem*);
};

struct _GuppiPlotToolClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_PLOT_TOOL (guppi_plot_tool_get_type())
#define GUPPI_PLOT_TOOL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_PLOT_TOOL,GuppiPlotTool))
#define GUPPI_PLOT_TOOL0(obj) ((obj) ? (GUPPI_PLOT_TOOL(obj)) : NULL)
#define GUPPI_PLOT_TOOL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_PLOT_TOOL,GuppiPlotToolClass))
#define GUPPI_IS_PLOT_TOOL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_PLOT_TOOL))
#define GUPPI_IS_PLOT_TOOL0(obj) (((obj) == NULL) || (GUPPI_IS_PLOT_TOOL(obj)))
#define GUPPI_IS_PLOT_TOOL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_PLOT_TOOL))

GtkType guppi_plot_tool_get_type(void);

/* Returns assigned tool id */
gint guppi_plot_tool_register(GuppiPlotTool*);

GuppiPlotTool* guppi_plot_tool_new(void);
GuppiPlotTool* guppi_plot_tool_new_by_id(gint);

GuppiPlotTool* guppi_plot_tool_new_rescale(double scale);
GuppiPlotTool* guppi_plot_tool_new_recenter(void);
GuppiPlotTool* guppi_plot_tool_new_drag(void);
GuppiPlotTool* guppi_plot_tool_new_reframe(void);






#endif /* _INC_GUPPI_PLOT_TOOL_H */

/* $Id: guppi-plot-tool.h,v 1.2 2000/03/04 18:52:51 trow Exp $ */
