/* This is -*- C -*- */
/* $Id: guppi-seq-boolean.c,v 1.3 2000/04/13 19:45:19 trow Exp $ */

/*
 * guppi-seq-boolean.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-seq-boolean.h"
#include "guppi-seq-boolean-impl.h"
#include "guppi-seq-boolean-core-impl.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_seq_boolean_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_boolean_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_boolean_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_seq_boolean_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_seq_boolean_class_init(GuppiSeqBooleanClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiDataClass* data_class = GUPPI_DATA_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_SEQ);

  data_class->default_impl = GUPPI_TYPE_SEQ_BOOLEAN_CORE_IMPL;
  data_class->type_name = _("Boolean Sequence");

  object_class->get_arg = guppi_seq_boolean_get_arg;
  object_class->set_arg = guppi_seq_boolean_set_arg;
  object_class->destroy = guppi_seq_boolean_destroy;
  object_class->finalize = guppi_seq_boolean_finalize;

}

static void
guppi_seq_boolean_init(GuppiSeqBoolean* obj)
{

}

GtkType
guppi_seq_boolean_get_type(void)
{
  static GtkType guppi_seq_boolean_type = 0;
  if (!guppi_seq_boolean_type) {
    static const GtkTypeInfo guppi_seq_boolean_info = {
      "GuppiSeqBoolean",
      sizeof(GuppiSeqBoolean),
      sizeof(GuppiSeqBooleanClass),
      (GtkClassInitFunc)guppi_seq_boolean_class_init,
      (GtkObjectInitFunc)guppi_seq_boolean_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_seq_boolean_type = gtk_type_unique(GUPPI_TYPE_SEQ, &guppi_seq_boolean_info);
  }
  return guppi_seq_boolean_type;
}

GuppiData*
guppi_seq_boolean_new(void)
{
  return GUPPI_DATA(gtk_type_new(guppi_seq_boolean_get_type()));
}

GuppiData*
guppi_seq_boolean_new_aligned(const GuppiSeq* seq)
{
  GuppiSeqBoolean* aligned;

  if (seq == NULL)
    return NULL;

  aligned = GUPPI_SEQ_BOOLEAN(guppi_seq_boolean_new());
  
  guppi_seq_boolean_append_many(aligned, FALSE, guppi_seq_size(seq));
  guppi_seq_set_min_index(GUPPI_SEQ(aligned), guppi_seq_min_index(seq));

  return GUPPI_DATA(aligned);
}

gboolean
guppi_seq_boolean_get(const GuppiSeqBoolean* seq, gint i)
{
  const GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;

  g_return_val_if_fail(seq != NULL, FALSE);
  g_return_val_if_fail(guppi_seq_in_bounds(GUPPI_SEQ(seq), i), FALSE);

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);
  
  g_assert(impl_class->get);
  return (impl_class->get)(impl, i);
}

void
guppi_seq_boolean_set(GuppiSeqBoolean* seq, gint i, gboolean x)
{
  GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));
  g_return_if_fail(guppi_seq_in_bounds(GUPPI_SEQ(seq), i));

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);
  
  g_assert(impl_class->set);
  (impl_class->set)(impl, i, x);
}

void
guppi_seq_boolean_set_all(GuppiSeqBoolean* seq, gboolean x)
{
  GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;
  gint i,i0,i1;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);
  
  if (impl_class->set_all) {
    (impl_class->set_all)(impl, x);
    return;
  }

  g_assert(impl_class->set);
  guppi_seq_indices(GUPPI_SEQ(seq), &i0, &i1);
  for (i=i0; i<=i1; ++i)
    (impl_class->set)(impl, i, x);
}

void
guppi_seq_boolean_clear(GuppiSeqBoolean* seq)
{
  guppi_seq_boolean_set_all(seq, FALSE);
}

void
guppi_seq_boolean_prepend(GuppiSeqBoolean* seq, gboolean x)
{
  GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;
  gint i;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);
  
  i = guppi_seq_min_index(GUPPI_SEQ(seq));
  
  g_assert(impl_class->insert);
  (impl_class->insert)(impl, i, x);
}

void
guppi_seq_boolean_prepend_many(GuppiSeqBoolean* seq, gboolean x, gsize n)
{
  GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;
  gint i;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));

  if (n == 0)
    return;

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  i = guppi_seq_min_index(GUPPI_SEQ(seq));

  if (impl_class->insert_many) {
    (impl_class->insert_many)(impl, i, x, n);
    return;
  }

  g_assert(impl_class->insert);
  while (n) {
    (impl_class->insert)(impl, i, x);
    --n;
  }
}

void
guppi_seq_boolean_append(GuppiSeqBoolean* seq, gboolean x)
{
  GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;
  gint i;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);
  
  i = guppi_seq_max_index(GUPPI_SEQ(seq));
  
  g_assert(impl_class->insert);
  (impl_class->insert)(impl, i+1, x);
}

void
guppi_seq_boolean_append_many(GuppiSeqBoolean* seq, gboolean x, gsize n)
{
  GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;
  gint i;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));

  if (n == 0)
    return;

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  i = guppi_seq_max_index(GUPPI_SEQ(seq));

  if (impl_class->insert_many) {
    (impl_class->insert_many)(impl, i+1, x, n);
    return;
  }

  g_assert(impl_class->insert);
  while (n) {
    ++i; /* We always insert at the end.  This is often more efficient. */
    (impl_class->insert)(impl, i, x);
    --n;
  }
}

void
guppi_seq_boolean_insert(GuppiSeqBoolean* seq, gint i, gboolean x)
{
  GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);
  
  g_assert(impl_class->insert);
  (impl_class->insert)(impl, i, x);
}

void
guppi_seq_boolean_insert_many(GuppiSeqBoolean* seq, gint i, gboolean x,
			      gsize n)
{
  GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));

  if (n == 0)
    return;

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  if (impl_class->insert_many) {
    (impl_class->insert_many)(impl, i, x, n);
    return;
  }

  g_assert(impl_class->insert);
  while (n) {
    ++i; 
    (impl_class->insert)(impl, i, x);
    --n;
  }
}

void
guppi_seq_boolean_bitwise_and(GuppiSeqBoolean* seq,
			      const GuppiSeqBoolean* other)
{
  GuppiSeqBooleanImpl* impl;
  const GuppiSeqBooleanImpl* other_impl;
  GuppiSeqBooleanImplClass* impl_class;
  GuppiSeqBooleanImplClass* other_class;
  gint i, i0, i1;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));
  g_return_if_fail(other != NULL);

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  other_impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(other)));
  other_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(other_impl)->klass);

  if (impl_class->bitwise_and &&
      GTK_OBJECT_TYPE(impl) == GTK_OBJECT_TYPE(other_impl)) {
    (impl_class->bitwise_and)(impl, other_impl);
    return;
  }

  g_assert(impl_class->get);
  g_assert(impl_class->set);
  g_assert(other_class->get);

  guppi_seq_common_bounds(GUPPI_SEQ(seq), GUPPI_SEQ(other), &i0, &i1);
  for (i=i0; i<=i1; ++i) {
    (impl_class->set)(impl, i,
		      (impl_class->get)(impl, i) &&
		      (other_class->get)(other_impl, i));
  }
}

void
guppi_seq_boolean_bitwise_or(GuppiSeqBoolean* seq,
			      const GuppiSeqBoolean* other)
{
  GuppiSeqBooleanImpl* impl;
  const GuppiSeqBooleanImpl* other_impl;
  GuppiSeqBooleanImplClass* impl_class;
  GuppiSeqBooleanImplClass* other_class;
  gint i, i0, i1;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));
  g_return_if_fail(other != NULL);

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  other_impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(other)));
  other_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(other_impl)->klass);

  if (impl_class->bitwise_or &&
      GTK_OBJECT_TYPE(impl) == GTK_OBJECT_TYPE(other_impl)) {
    (impl_class->bitwise_or)(impl, other_impl);
    return;
  }

  g_assert(impl_class->get);
  g_assert(impl_class->set);
  g_assert(other_class->get);

  guppi_seq_common_bounds(GUPPI_SEQ(seq), GUPPI_SEQ(other), &i0, &i1);
  for (i=i0; i<=i1; ++i) {
    (impl_class->set)(impl, i,
		      (impl_class->get)(impl, i) ||
		      (other_class->get)(other_impl, i));
  }
}

void
guppi_seq_boolean_bitwise_xor(GuppiSeqBoolean* seq,
			      const GuppiSeqBoolean* other)
{
  GuppiSeqBooleanImpl* impl;
  const GuppiSeqBooleanImpl* other_impl;
  GuppiSeqBooleanImplClass* impl_class;
  GuppiSeqBooleanImplClass* other_class;
  gint i, i0, i1;
  gboolean x, y;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));
  g_return_if_fail(other != NULL);

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  other_impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(other)));
  other_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(other_impl)->klass);

  if (impl_class->bitwise_xor &&
      GTK_OBJECT_TYPE(impl) == GTK_OBJECT_TYPE(other_impl)) {
    (impl_class->bitwise_xor)(impl, other_impl);
    return;
  }

  g_assert(impl_class->get);
  g_assert(impl_class->set);
  g_assert(other_class->get);

  guppi_seq_common_bounds(GUPPI_SEQ(seq), GUPPI_SEQ(other), &i0, &i1);
  for (i=i0; i<=i1; ++i) {
    x = (impl_class->get)(impl, i);
    y = (other_class->get)(other_impl, i);
    (impl_class->set)(impl, i, x ? !y : y);
  }
}

void
guppi_seq_boolean_bitwise_not(GuppiSeqBoolean* seq)
{
  GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;
  gint i, i0, i1;
  gboolean x;

  g_return_if_fail(seq != NULL);
  g_return_if_fail(guppi_data_can_change(GUPPI_DATA(seq)));

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  if (impl_class->bitwise_not) {
    (impl_class->bitwise_not)(impl);
    return;
  }

  g_assert(impl_class->get);
  g_assert(impl_class->set);

  guppi_seq_indices(GUPPI_SEQ(seq), &i0, &i1);
  for (i=i0; i<=i1; ++i) {
    x = (impl_class->get)(impl, i);
    (impl_class->set)(impl, i, !x);
  }
}

gint
guppi_seq_boolean_first_true(const GuppiSeqBoolean* seq)
{
  const GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;
  gint i, i0, i1;

  g_return_val_if_fail(seq != NULL, 1);

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  i0 = guppi_seq_min_index(GUPPI_SEQ(seq));
  
  if (impl_class->next_true) {
    return (impl_class->next_true)(impl, i0-1);
  }

  g_assert(impl_class->get);
  i1 = guppi_seq_max_index(GUPPI_SEQ(seq));
  for (i=i0; i<=i1 && (impl_class->get)(impl, i); ++i);
  return i;
}

gint
guppi_seq_boolean_next_true(const GuppiSeqBoolean* seq, gint i)
{
  const GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;
  gint i1;

  g_return_val_if_fail(seq != NULL, 1);

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);

  i1 = guppi_seq_max_index(GUPPI_SEQ(seq));
  if (i1 < i)
    return i;

  if (impl_class->next_true) {
    return (impl_class->next_true)(impl, i);
  }

  g_assert(impl_class->get);

  while (i < i1) {
    ++i;
    if ((impl_class->get)(impl, i))
      return i;
  }
  return i;
}

gsize
guppi_seq_boolean_true_count(const GuppiSeqBoolean* seq)
{
  const GuppiSeqBooleanImpl* impl;
  GuppiSeqBooleanImplClass* impl_class;
  gint i, i0, i1;
  gsize count=0;

  g_return_val_if_fail(seq != NULL, 0);

  impl = GUPPI_SEQ_BOOLEAN_IMPL(guppi_data_impl(GUPPI_DATA(seq)));
  impl_class = GUPPI_SEQ_BOOLEAN_IMPL_CLASS(GTK_OBJECT(impl)->klass);
  
  if (impl_class->true_count) {
    return (impl_class->true_count)(impl);
  }

  g_assert(impl_class->get);

  guppi_seq_indices(GUPPI_SEQ(seq), &i0, &i1);

  for (i=i0; i<=i1; ++i) {
    if ((impl_class->get)(impl, i))
      ++count;
  }

  return count;
}

/* $Id: guppi-seq-boolean.c,v 1.3 2000/04/13 19:45:19 trow Exp $ */
