/* This is -*- C -*- */
/* $Id: guppi-data.h,v 1.4 2000/04/13 19:45:19 trow Exp $ */

/*
 * guppi-data.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATA_H
#define _INC_GUPPI_DATA_H

#include <config.h>
#include <gnome.h>
#include "guppi-data-impl.h"

typedef struct _GuppiData GuppiData;
typedef struct _GuppiDataClass GuppiDataClass;

struct _GuppiData {
  GtkObject parent;

  gchar* label;
  gboolean read_only;

  gint freeze_count;
  gboolean pending_change;

  GtkType requested_impl;
  GuppiDataImpl* impl;

  GList* local_subdata;
};

struct _GuppiDataClass {
  GtkObjectClass parent_class;

  GtkType default_impl;
  const gchar* type_name;
  
  /* signals */
  void (*changed)(GuppiData*);
  void (*changed_label)(GuppiData*);
  void (*changed_subdata)(GuppiData*);

  /* virtual functions */
  void (*emit_pending_signals)(GuppiData*);
  GtkWidget* (*browser_widget)(GuppiData*);
  GtkWidget* (*info_widget)(GuppiData*);
  GList* (*general_subdata)(GuppiData*);
};

#define GUPPI_TYPE_DATA (guppi_data_get_type())
#define GUPPI_DATA(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATA,GuppiData))
#define GUPPI_DATA0(obj) ((obj) ? (GUPPI_DATA(obj)) : NULL)
#define GUPPI_DATA_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_DATA,GuppiDataClass))
#define GUPPI_IS_DATA(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATA))
#define GUPPI_IS_DATA0(obj) (((obj) == NULL) || (GUPPI_IS_DATA(obj)))
#define GUPPI_IS_DATA_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_DATA))

GtkType guppi_data_get_type(void);
GuppiDataImpl* guppi_data_impl(GuppiData*);

const gchar* guppi_data_get_type_name(const GuppiData*);
const gchar* guppi_data_get_impl_name(const GuppiData*);

#define guppi_data_label(x) guppi_data_get_label(x)
const gchar* guppi_data_get_label(const GuppiData*);
void guppi_data_set_label(GuppiData*, const gchar*);

gboolean guppi_data_is_read_only(const GuppiData*);
gboolean guppi_data_can_change(const GuppiData*);

void guppi_data_freeze(GuppiData*);
void guppi_data_thaw(GuppiData*);
gboolean guppi_data_frozen(GuppiData*);

void guppi_data_changed(GuppiData*);

gboolean guppi_data_has_hook(const GuppiData*, const gchar*);
gpointer guppi_data_call_hook(GuppiData*, const gchar*, gpointer);

GtkWidget* guppi_data_make_browser_widget(GuppiData*);
GtkWidget* guppi_data_make_info_widget(GuppiData*);

GuppiData* guppi_data_copy(const GuppiData*);
gint guppi_data_get_size_in_bytes(GuppiData*);
void guppi_data_get_size_info(GuppiData*, gchar*, gsize);

GList* guppi_data_get_subdata(GuppiData*);
void guppi_data_add_subdata(GuppiData*, GuppiData*);

#endif /* _INC_GUPPI_DATA_H */

/* $Id: guppi-data.h,v 1.4 2000/04/13 19:45:19 trow Exp $ */
