/* This is -*- C -*- */
/* $Id: guppi-array-core-impl.h,v 1.3 2000/04/13 19:45:19 trow Exp $ */

/*
 * guppi-array-core-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_ARRAY_CORE_IMPL_H
#define _INC_GUPPI_ARRAY_CORE_IMPL_H

#include <config.h>
#include <gnome.h>

#include "guppi-array.h"
#include "guppi-array-impl.h"
#include <guppi-garray.h>

typedef struct _GuppiArrayCoreImpl GuppiArrayCoreImpl;
typedef struct _GuppiArrayCoreImplClass GuppiArrayCoreImplClass;

struct _GuppiArrayCoreImpl {
  GuppiArrayImpl parent;

  gint dims;
  gint* index_min;
  gint* index_sizes;
  gint* strides;
  GuppiGArray* garray;
};

struct _GuppiArrayCoreImplClass {
  GuppiArrayImplClass parent_class;
};

#define GUPPI_TYPE_ARRAY_CORE_IMPL (guppi_array_core_impl_get_type())
#define GUPPI_ARRAY_CORE_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_ARRAY_CORE_IMPL,GuppiArrayCoreImpl))
#define GUPPI_ARRAY_CORE_IMPL0(obj) ((obj) ? (GUPPI_ARRAY_CORE_IMPL(obj)) : NULL)
#define GUPPI_ARRAY_CORE_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_ARRAY_CORE_IMPL,GuppiArrayCoreImplClass))
#define GUPPI_IS_ARRAY_CORE_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_ARRAY_CORE_IMPL))
#define GUPPI_IS_ARRAY_CORE_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_ARRAY_CORE_IMPL(obj)))
#define GUPPI_IS_ARRAY_CORE_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_ARRAY_CORE_IMPL))

GtkType guppi_array_core_impl_get_type(void);

GuppiDataImpl* guppi_array_core_impl_new(void);



#endif /* _INC_GUPPI_ARRAY_CORE_IMPL_H */

/* $Id: guppi-array-core-impl.h,v 1.3 2000/04/13 19:45:19 trow Exp $ */
