/* This is -*- C -*- */
/* $Id: guppi-array-core-impl.c,v 1.2 2000/04/13 19:45:19 trow Exp $ */

/*
 * guppi-array-core-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-array-core-impl.h"

static void core_construct(GuppiArrayImpl*, gint,
			   const gint*, const gint*);

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_array_core_impl_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_array_core_impl_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_array_core_impl_destroy(GtkObject* obj)
{
  GuppiArrayCoreImpl* impl = GUPPI_ARRAY_CORE_IMPL(obj);
  if (parent_class->destroy)
    parent_class->destroy(obj);

   g_free(impl->index_min);
  impl->index_min = NULL;

  g_free(impl->index_sizes);
  impl->index_sizes = NULL;
  
  g_free(impl->strides);
  impl->strides = NULL;

  gtk_object_unref(GTK_OBJECT(impl->garray));
  impl->garray = NULL;
}

static void
guppi_array_core_impl_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_array_core_impl_class_init(GuppiArrayCoreImplClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiArrayImplClass* impl_class = GUPPI_ARRAY_IMPL_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_ARRAY_IMPL);

  object_class->get_arg = guppi_array_core_impl_get_arg;
  object_class->set_arg = guppi_array_core_impl_set_arg;
  object_class->destroy = guppi_array_core_impl_destroy;
  object_class->finalize = guppi_array_core_impl_finalize;

  GUPPI_DATA_IMPL_CLASS(klass)->impl_name = _("Core Array");

  impl_class->construct = core_construct;
}

static void
guppi_array_core_impl_init(GuppiArrayCoreImpl* obj)
{

}

GtkType
guppi_array_core_impl_get_type(void)
{
  static GtkType guppi_array_core_impl_type = 0;
  if (!guppi_array_core_impl_type) {
    static const GtkTypeInfo guppi_array_core_impl_info = {
      "GuppiArrayCoreImpl",
      sizeof(GuppiArrayCoreImpl),
      sizeof(GuppiArrayCoreImplClass),
      (GtkClassInitFunc)guppi_array_core_impl_class_init,
      (GtkObjectInitFunc)guppi_array_core_impl_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_array_core_impl_type = gtk_type_unique(GUPPI_TYPE_ARRAY_IMPL, &guppi_array_core_impl_info);
  }
  return guppi_array_core_impl_type;
}

GuppiDataImpl*
guppi_array_core_impl_new(void)
{
  return GUPPI_DATA_IMPL(gtk_type_new(guppi_array_core_impl_get_type()));
}

/****************************************************************************/

static void
core_construct(GuppiArrayImpl* gda, gint dims,
	       const gint* sizes, const gint* mins)
{
  gint i, s;
  GuppiArrayCoreImpl* impl = GUPPI_ARRAY_CORE_IMPL(gda);
  g_assert(impl != NULL);
  
  impl->dims = dims;
  impl->index_min = mins ? g_memdup(mins, sizeof(gint)*dims) : NULL;
  impl->index_sizes = g_memdup(sizes, sizeof(gint)*dims);
  impl->strides = g_new(gint, dims);

  s=1;
  for (i=0; i<dims; ++i) {
    impl->strides[i] = s;
    s *= impl->index_sizes[i];
  }
  
  impl->garray = guppi_garray_new(sizeof(double));
  guppi_garray_set_size(impl->garray, s);
    

  gda->dims = &impl->dims;
  gda->index_min = &impl->index_min;
  gda->index_sizes = &impl->index_sizes;
  gda->strides = &impl->strides;
  gda->data = (double**)&(guppi_garray_data(impl->garray));
}


/* $Id: guppi-array-core-impl.c,v 1.2 2000/04/13 19:45:19 trow Exp $ */
