/* This is -*- C -*- */
/* $Id: guppi-slinreg-element.h,v 1.1 2000/04/07 18:32:42 trow Exp $ */

/*
 * guppi-slinreg-element.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SLINREG_ELEMENT_H
#define _INC_GUPPI_SLINREG_ELEMENT_H

#include <config.h>
#include <gnome.h>

#include <guppi-plot-element.h>
#include "guppi-slinreg-state.h"

typedef struct _GuppiSlinregElement GuppiSlinregElement;
typedef struct _GuppiSlinregElementClass GuppiSlinregElementClass;

struct _GuppiSlinregElement {
  GuppiPlotElement parent;

  GuppiSlinregState* state;
};

struct _GuppiSlinregElementClass {
  GuppiPlotElementClass parent_class;
};

#define GUPPI_TYPE_SLINREG_ELEMENT (guppi_slinreg_element_get_type())
#define GUPPI_SLINREG_ELEMENT(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SLINREG_ELEMENT,GuppiSlinregElement))
#define GUPPI_SLINREG_ELEMENT0(obj) ((obj) ? (GUPPI_SLINREG_ELEMENT(obj)) : NULL)
#define GUPPI_SLINREG_ELEMENT_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SLINREG_ELEMENT,GuppiSlinregElementClass))
#define GUPPI_IS_SLINREG_ELEMENT(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SLINREG_ELEMENT))
#define GUPPI_IS_SLINREG_ELEMENT0(obj) (((obj) == NULL) || (GUPPI_IS_SLINREG_ELEMENT(obj)))
#define GUPPI_IS_SLINREG_ELEMENT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SLINREG_ELEMENT))

GtkType guppi_slinreg_element_get_type(void);

GuppiPlotElement* guppi_slinreg_element_new(void);
GuppiPlotElement* guppi_slinreg_element_new_with_state(GuppiSlinregState*);



#endif /* _INC_GUPPI_SLINREG_ELEMENT_H */

/* $Id: guppi-slinreg-element.h,v 1.1 2000/04/07 18:32:42 trow Exp $ */
