/* This is -*- C -*- */
/* $Id: guppi-scatter-marker-menu.h,v 1.2 2000/04/13 19:45:17 trow Exp $ */

/*
 * guppi-scatter-marker-menu.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SCATTER_MARKER_MENU_H
#define _INC_GUPPI_SCATTER_MARKER_MENU_H

#include <config.h>
#include <gnome.h>
#include <guppi-scatter-style.h>

typedef struct _GuppiScatterMarkerMenu GuppiScatterMarkerMenu;
typedef struct _GuppiScatterMarkerMenuClass GuppiScatterMarkerMenuClass;

struct _GuppiScatterMarkerMenu {
  GtkOptionMenu parent;
};

struct _GuppiScatterMarkerMenuClass {
  GtkOptionMenuClass parent_class;

  void (*selected_marker)(GuppiScatterMarkerMenu*, GuppiScatterMarker);
};

#define GUPPI_TYPE_SCATTER_MARKER_MENU (guppi_scatter_marker_menu_get_type())
#define GUPPI_SCATTER_MARKER_MENU(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SCATTER_MARKER_MENU,GuppiScatterMarkerMenu))
#define GUPPI_SCATTER_MARKER_MENU_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SCATTER_MARKER_MENU,GuppiScatterMarkerMenuClass))
#define GUPPI_IS_SCATTER_MARKER_MENU(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SCATTER_MARKER_MENU))
#define GUPPI_IS_SCATTER_MARKER_MENU_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SCATTER_MARKER_MENU))

GtkType guppi_scatter_marker_menu_get_type(void);

void guppi_scatter_marker_menu_construct(GuppiScatterMarkerMenu*);
GtkWidget* guppi_scatter_marker_menu_new(void);

GuppiScatterMarker guppi_scatter_marker_menu_get_selection(GuppiScatterMarkerMenu*);
void guppi_scatter_marker_menu_set_selection(GuppiScatterMarkerMenu*,
					     GuppiScatterMarker);

GtkWidget* guppi_scatter_marker_menu_glade_custom_func(gchar* name,
						       gchar* def_marker,
						       gchar* dummy_str,
						       gint dummy_int1,
						       gint dummy_int2);

#endif /* _INC_GUPPI_SCATTER_MARKER_MENU_H */

/* $Id: guppi-scatter-marker-menu.h,v 1.2 2000/04/13 19:45:17 trow Exp $ */





















