/* This is -*- C -*- */
/* $Id: guppi-scatter-element.h,v 1.2 2000/04/13 19:45:17 trow Exp $ */

/*
 * guppi-scatter-element.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SCATTER_ELEMENT_H
#define _INC_GUPPI_SCATTER_ELEMENT_H

#include <config.h>
#include <gnome.h>
#include <guppi-plot-element.h>
#include "guppi-scatter-state.h"

typedef struct _GuppiScatterElement GuppiScatterElement;
typedef struct _GuppiScatterElementClass GuppiScatterElementClass;

struct _GuppiScatterElement {
  GuppiPlotElement parent;

  GuppiScatterState* state;
};

struct _GuppiScatterElementClass {
  GuppiPlotElementClass parent_class;
};

#define GUPPI_TYPE_SCATTER_ELEMENT (guppi_scatter_element_get_type())
#define GUPPI_SCATTER_ELEMENT(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SCATTER_ELEMENT,GuppiScatterElement))
#define GUPPI_SCATTER_ELEMENT_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SCATTER_ELEMENT,GuppiScatterElementClass))
#define GUPPI_IS_SCATTER_ELEMENT(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SCATTER_ELEMENT))
#define GUPPI_IS_SCATTER_ELEMENT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SCATTER_ELEMENT))

GtkType guppi_scatter_element_get_type(void);

GuppiPlotElement* guppi_scatter_element_new(void);
GuppiPlotElement* guppi_scatter_element_new_with_state(GuppiScatterState*);

/*
  The scatter element has no "identity" other than as a generic plot
  element.  Hence it has no unique interface.
*/


#endif /* _INC_GUPPI_SCATTER_ELEMENT_H */

/* $Id: guppi-scatter-element.h,v 1.2 2000/04/13 19:45:17 trow Exp $ */
